# 画面設計書 196-パスワード変更

## 概要

本ドキュメントは、パスワード変更画面の設計書である。ログインユーザーが自身のパスワードを変更する画面の仕様を定義する。

### 本画面の処理概要

ログインユーザーが自身のアカウントパスワードを変更するための画面である。現在のパスワードを入力し、新しいパスワードを設定する。パスワードリセットメールの送信も可能である。

**業務上の目的・背景**：パスワードの定期的な変更はセキュリティのベストプラクティスである。また、パスワードの漏洩が疑われる場合や、組織のセキュリティポリシーに従って変更が必要となる場合がある。本画面は、ユーザーが自主的にパスワードを管理するために必要である。

**画面へのアクセス方法**：
1. 右上のユーザーアバターをクリック
2. 「設定」を選択
3. 左サイドバーから「パスワード」を選択
4. または URL `/-/user_settings/password/edit` に直接アクセス

**主要な操作・処理内容**：
1. 現在のパスワードの入力
2. 新しいパスワードの入力
3. 新しいパスワードの確認入力
4. パスワードの更新
5. パスワードリセットメールの送信（「パスワードを忘れた場合」）

**画面遷移**：
- 遷移元: ユーザー設定メニュー
- 遷移先: ログイン画面（パスワード変更成功後）

**権限による表示制御**：
- ログイン必須
- パスワード認証が許可されているユーザーのみアクセス可能
- LDAPやOAuthのみのユーザーは404エラー

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 78 | パスワード管理 | 主機能 | パスワードの変更 |

## 画面種別

編集

## URL/ルーティング

```
GET  /-/user_settings/password/edit    # 編集画面表示
PUT  /-/user_settings/password         # パスワード更新
PUT  /-/user_settings/password/reset   # パスワードリセットメール送信
```

## 入出力項目

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| 現在のパスワード | user[password] | 入力 | password | Yes* | 自動設定でない場合必須 |
| 新しいパスワード | user[new_password] | 入力 | password | Yes | 新パスワード |
| パスワード確認 | user[password_confirmation] | 入力 | password | Yes | 新パスワードの確認 |

*`password_automatically_set` が true の場合、現在のパスワードは不要

## 表示項目

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| Passkey 有効アラート | @user.passkeys_enabled? | Passkey使用中の案内 |
| Passkey 推奨アラート | !@user.passkeys_enabled? | Passkey追加の推奨 |

## イベント仕様

### 1-パスワード更新

**トリガー**: 「Save password」ボタン押下

**処理フロー**:
1. 現在のパスワードの検証（`password_automatically_set` でない場合）
2. 新パスワードのバリデーション（複雑性要件等）
3. `Users::UpdateService` でパスワード更新
4. 成功時: ログイン画面へリダイレクト（再ログインを要求）
5. 失敗時: エラーメッセージを表示して画面に留まる

### 2-パスワードリセット

**トリガー**: 「I forgot my password」リンク押下

**処理フロー**:
1. PUT リクエストで `/reset` エンドポイントを呼び出し
2. `current_user.send_reset_password_instructions` でリセットメール送信
3. 成功メッセージを表示してパスワード編集画面に留まる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パスワード更新 | users | UPDATE | パスワードハッシュの更新 |
| パスワード更新失敗 | users | UPDATE | failed_attempts のインクリメント |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | encrypted_password | bcrypt ハッシュ | 新パスワードのハッシュ |
| UPDATE | password_automatically_set | false | 自動設定フラグをクリア |
| UPDATE | password_expires_at | NULL | パスワード期限をクリア |
| UPDATE | updated_at | 現在日時 | 更新日時 |
| UPDATE (失敗時) | failed_attempts | +1 | 認証失敗カウント |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-001 | 成功 | Password was successfully updated. Please sign in again. | パスワード更新成功時 |
| MSG-002 | 成功 | We sent you an email with reset password instructions | リセットメール送信時 |
| MSG-003 | エラー | You must provide a valid current password. | 現在のパスワードが不正 |
| MSG-004 | 情報 | You must provide your current password in order to change it. | フォーム説明 |
| MSG-005 | 情報 | Change your password. / Change your password or recover your current one. | ページ説明 |
| MSG-006 | 情報 | You currently use passkeys for secure and faster sign in. Manage passkeys. | Passkey有効時 |
| MSG-007 | 情報 | Add a passkey to sign in securely with your trusted device. | Passkey推奨 |

## 例外処理

| 例外 | 発生条件 | 対応処理 |
|-----|---------|---------|
| 未認証 | ログインしていない | ログイン画面へリダイレクト |
| 404 Not Found | パスワード認証が許可されていない | 404ページ表示 |
| バリデーションエラー | 新パスワードが要件を満たさない | エラーメッセージを表示 |

## 備考

- パスワード変更成功後は強制的にログアウトされ、再ログインが必要
- Feature Flag `passkeys` が有効な場合、Passkey関連の案内が表示される
- 弱いパスワードの場合、追跡イベントが記録される（`track_weak_password_error`）
- パスワード複雑性要件は EE 機能として提供される場合がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | パスワード関連の属性・メソッドを確認 |

**読解のコツ**: `password_automatically_set` フラグは、OAuth等で初回ログインした場合に true となる。この場合、現在のパスワード入力が不要となる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | passwords_controller.rb | `app/controllers/user_settings/passwords_controller.rb` | edit/update/resetアクションを確認 |

**主要処理フロー**:
1. **40行目**: `edit` アクション - 編集画面の表示
2. **42-59行目**: `update` アクション - パスワード更新処理
3. **62-65行目**: `reset` アクション - リセットメール送信
4. **81-83行目**: `authorize_change_password!` - パスワード認証許可チェック

#### Step 3: ビューレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | edit.html.haml | `app/views/user_settings/passwords/edit.html.haml` | フォーム構造を確認 |

**主要処理フロー**:
- **7-21行目**: Passkey 関連アラート表示
- **23-50行目**: パスワード変更フォーム
- **33-38行目**: 現在のパスワード入力（条件付き）
- **39-42行目**: 新しいパスワード入力
- **43-45行目**: パスワード確認入力
- **48-50行目**: リセットメールリンク

#### Step 4: サービスレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | update_service.rb | `app/services/users/update_service.rb` | パスワード更新ロジック |

### プログラム呼び出し階層図

```
UserSettings::PasswordsController#edit
    │
    ├─ authorize_change_password!
    │      └─ @user.allow_password_authentication?
    │
    └─ render 'edit'
           ├─ Passkey アラート (Feature.enabled?(:passkeys))
           └─ gitlab_ui_form_for @user

UserSettings::PasswordsController#update
    │
    ├─ @user.valid_password?(user_params[:password])
    │      └─ 現在のパスワード検証
    │
    ├─ [失敗時] handle_invalid_current_password_attempt!
    │      └─ @user.increment_failed_attempts!
    │
    └─ Users::UpdateService#execute
           ├─ password_attributes
           │      ├─ password: new_password
           │      ├─ password_confirmation
           │      └─ password_automatically_set: false
           │
           └─ [成功時] redirect_to new_user_session_path

UserSettings::PasswordsController#reset
    │
    └─ current_user.send_reset_password_instructions
           └─ Devise::Mailer
```

### データフロー図

```
[入力]               [処理]                    [出力]

現在のパスワード ───▶ valid_password? ───▶ 検証結果
    │                      │
    │                      └─ [失敗] increment_failed_attempts!
    │
新パスワード ───▶ Users::UpdateService ───▶ encrypted_password
    │                      │
    │                      └─ password_automatically_set = false
    │
    └───────────────────────────────────────────▶ redirect_to sign_in

リセット要求 ───▶ send_reset_password_instructions ───▶ メール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| passwords_controller.rb | `app/controllers/user_settings/passwords_controller.rb` | コントローラー | リクエスト処理 |
| edit.html.haml | `app/views/user_settings/passwords/edit.html.haml` | テンプレート | 編集画面 |
| user.rb | `app/models/user.rb` | モデル | ユーザーデータ定義 |
| update_service.rb | `app/services/users/update_service.rb` | サービス | ユーザー更新ロジック |
| user_settings.rb | `config/routes/user_settings.rb` | 設定 | ルーティング定義 |
| weak_password_error_event.rb | `app/controllers/concerns/gitlab/tracking/helpers/weak_password_error_event.rb` | Concern | 弱いパスワード追跡 |
