# 画面設計書 197-パスワード新規設定

## 概要

本ドキュメントは、パスワード新規設定画面の設計書である。初回パスワード設定や期限切れパスワードの更新を行う画面の仕様を定義する。

### 本画面の処理概要

OAuth等の外部認証でアカウントを作成したユーザーや、パスワードが期限切れとなったユーザーが、パスワードを新規に設定するための画面である。この画面を完了するまで他の機能にアクセスできない強制画面として表示される。

**業務上の目的・背景**：セキュリティポリシーにより、外部認証のみでログインしたユーザーにもパスワード設定を求める場合がある。また、パスワードの有効期限が設定されている場合、期限切れ後に新しいパスワードの設定が強制される。本画面は、これらのセキュリティ要件を満たすために必要である。

**画面へのアクセス方法**：
- パスワードが未設定または期限切れの状態でログインすると自動的にリダイレクト
- URL `/-/user_settings/password/new` に直接アクセス

**主要な操作・処理内容**：
1. 現在のパスワードの入力（既存パスワードがある場合）
2. 新しいパスワードの入力
3. 新しいパスワードの確認入力
4. パスワードの設定
5. サインアウト

**画面遷移**：
- 遷移元: ログイン後（パスワード更新が必要な場合）
- 遷移先: ルートページ（パスワード設定成功後）、ログイン画面（サインアウト時）

**権限による表示制御**：
- ログイン必須
- パスワード認証が許可されているユーザーのみアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 78 | パスワード管理 | 主機能 | 初回パスワード設定 |

## 画面種別

登録

## URL/ルーティング

```
GET  /-/user_settings/password/new     # 新規設定画面表示
POST /-/user_settings/password         # パスワード設定
```

## 入出力項目

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| 現在のパスワード | user[password] | 入力 | password | No* | 自動設定でない場合必須 |
| 新しいパスワード | user[new_password] | 入力 | password | Yes | 新パスワード |
| パスワード確認 | user[password_confirmation] | 入力 | password | Yes | 新パスワードの確認 |

*`password_automatically_set` が true の場合、現在のパスワードは不要

## 表示項目

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| ユーザー名 | current_user.name | ページタイトルに表示 |
| ユーザーアバター | current_user | ユーザー情報表示 |
| ユーザー名（@形式） | current_user.username | サインイン情報表示 |

## イベント仕様

### 1-パスワード設定

**トリガー**: 「Update password」ボタン押下

**処理フロー**:
1. 現在のパスワードの検証（`password_automatically_set` でない場合）
2. 新パスワードのバリデーション（複雑性要件等）
3. `Users::UpdateService` でパスワード設定
4. `password_expires_at` を NULL にクリア
5. 成功時: ルートページへリダイレクト
6. 失敗時: エラーメッセージを表示して画面に留まる

### 2-サインアウト

**トリガー**: 「Sign out」ボタン押下

**処理フロー**:
1. POST `/users/sign_out` へリクエスト
2. セッションを終了
3. ログイン画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パスワード設定 | users | UPDATE | パスワードハッシュの更新 |
| パスワード設定 | users | UPDATE | password_expires_at のクリア |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | encrypted_password | bcrypt ハッシュ | 新パスワードのハッシュ |
| UPDATE | password_automatically_set | false | 自動設定フラグをクリア |
| UPDATE | password_expires_at | NULL | パスワード期限をクリア |
| UPDATE | updated_at | 現在日時 | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-001 | 成功 | Password successfully changed | パスワード設定成功時 |
| MSG-002 | エラー | You must provide a valid current password. | 現在のパスワードが不正 |
| MSG-003 | 情報 | Update password for %{current_name} | ページタイトル |
| MSG-004 | 情報 | To continue, please update your password. After you update, you'll be directed to sign in again. | ページ説明 |
| MSG-005 | 情報 | Signed in as %{username} | サインイン情報 |

## 例外処理

| 例外 | 発生条件 | 対応処理 |
|-----|---------|---------|
| 未認証 | ログインしていない | ログイン画面へリダイレクト |
| 404 Not Found | パスワード認証が許可されていない | 404ページ表示 |
| バリデーションエラー | 新パスワードが要件を満たさない | エラーメッセージを表示 |

## 備考

- 本画面は `minimal` レイアウトを使用し、シンプルな表示となる
- パスワード設定完了後はルートページ（通常はダッシュボード）にリダイレクト
- 非アクティブ化されたユーザーがこの画面でパスワードを設定すると、自動的にアクティブ化される
- `skip_before_action :check_password_expiration` により、この画面自体へのアクセスは期限切れチェックを受けない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | パスワード関連の属性・メソッドを確認 |

**読解のコツ**: `password_automatically_set` と `password_expires_at` の2つのフラグがこの画面の表示条件を決定する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | passwords_controller.rb | `app/controllers/user_settings/passwords_controller.rb` | new/createアクションを確認 |

**主要処理フロー**:
1. **18-19行目**: `new` アクション - 非アクティブユーザーの自動アクティブ化
2. **22-37行目**: `create` アクション - パスワード設定処理
3. **30-31行目**: `password_expires_at` を NULL にクリア
4. **73-78行目**: `determine_layout` - minimal レイアウトの適用

#### Step 3: ビューレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/user_settings/passwords/new.html.haml` | フォーム構造を確認 |

**主要処理フロー**:
- **3行目**: シンプルなレイアウト（`.gl-ml-auto.gl-mr-auto`）
- **5行目**: ページタイトルにユーザー名を表示
- **8-13行目**: サインイン情報表示
- **14-30行目**: パスワード設定フォーム
- **31-32行目**: サインアウトボタン

### プログラム呼び出し階層図

```
UserSettings::PasswordsController#new
    │
    ├─ authorize_change_password!
    │      └─ @user.allow_password_authentication?
    │
    └─ current_user.activate (deactivated? の場合)

UserSettings::PasswordsController#create
    │
    ├─ @user.valid_password?(user_params[:password])
    │      └─ 現在のパスワード検証（password_automatically_set でない場合）
    │
    ├─ Users::UpdateService#execute
    │      └─ password_attributes
    │
    ├─ [成功時] Users::UpdateService#execute
    │      └─ password_expires_at: nil
    │
    └─ [成功時] redirect_to root_path
```

### データフロー図

```
[入力]               [処理]                    [出力]

現在のパスワード ───▶ valid_password? ───▶ 検証結果
    │                      │
    │                      └─ [失敗] redirect with alert
    │
新パスワード ───▶ Users::UpdateService ───▶ encrypted_password
    │                      │
    │                      └─ password_automatically_set = false
    │                      │
    │                      └─ password_expires_at = nil
    │
    └───────────────────────────────────────────▶ redirect_to root_path
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| passwords_controller.rb | `app/controllers/user_settings/passwords_controller.rb` | コントローラー | リクエスト処理 |
| new.html.haml | `app/views/user_settings/passwords/new.html.haml` | テンプレート | 新規設定画面 |
| user.rb | `app/models/user.rb` | モデル | ユーザーデータ定義 |
| update_service.rb | `app/services/users/update_service.rb` | サービス | ユーザー更新ロジック |
| user_settings.rb | `config/routes/user_settings.rb` | 設定 | ルーティング定義 |
| minimal.html.haml | `app/views/layouts/minimal.html.haml` | レイアウト | ミニマルレイアウト |
