# 画面設計書 2-パスワードリセット画面

## 概要

本ドキュメントは、GitLabのパスワードリセット画面の設計仕様を記載したものです。パスワードを忘れたユーザーがリセット手続きを開始するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：パスワードリセット画面は、パスワードを忘れたユーザーがアカウントへのアクセスを回復するための重要なセキュリティ機能を提供します。メールアドレスを入力することで、パスワードリセット用のリンクが記載されたメールが送信されます。この機能により、管理者の介入なしにユーザー自身でパスワードを再設定できます。また、reCAPTCHAによるボット対策や、リクエスト頻度の制限により、悪意のある大量リクエストを防止しています。

**画面へのアクセス方法**：
- ログイン画面の「Forgot your password?」リンクをクリック
- 直接 `/users/password/new` URLにアクセス
- メール確認画面からのリンク

**主要な操作・処理内容**：
1. 登録済みメールアドレスの入力
2. reCAPTCHAの完了（設定時）
3. パスワードリセットメールの送信要求
4. 送信完了メッセージの表示

**画面遷移**：
- 遷移元：ログイン画面、パスワード変更画面（トークン期限切れ時）
- 遷移先：ログイン画面（リセットメール送信後）

**権限による表示制御**：
- 未認証ユーザーのみがアクセス可能
- パスワード認証が無効化されている場合はエラーメッセージを表示
- 認証済みユーザーがアクセスした場合はダッシュボードにリダイレクト

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 78 | パスワード管理 | 主機能 | パスワードリセット要求の送信処理 |
| 137 | メール通知 | 補助機能 | パスワードリセットメールの送信 |

## 画面種別

入力フォーム

## URL/ルーティング

| HTTPメソッド | URL | アクション |
|-------------|-----|----------|
| GET | `/users/password/new` | パスワードリセット画面表示 |
| POST | `/users/password` | パスワードリセットメール送信 |

## 入出力項目

### 入力項目

| 項目名 | 物理名 | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| メールアドレス | user[email] | string | Yes | 255 | プライマリまたは認証済みセカンダリメールアドレス |
| reCAPTCHA | - | token | 条件付き | - | reCAPTCHA有効時に必要 |

## 表示項目

| 項目名 | 説明 | 条件 |
|--------|------|------|
| メール入力フォーム | メールアドレス入力欄 | 常時表示 |
| 説明テキスト | プライマリまたは認証済みメールが必要な旨の説明 | 常時表示 |
| reCAPTCHA | ボット対策用ウィジェット | reCAPTCHA設定時 |
| Reset passwordボタン | リセット要求送信ボタン | 常時表示 |
| Sign inリンク | ログイン画面へのリンク | 常時表示 |
| エラーメッセージ | 入力エラー表示領域 | エラー発生時 |

## イベント仕様

### 1-Reset passwordボタン押下

**トリガー**: 「Reset password」ボタンクリック

**処理フロー**:
1. フォームバリデーション（クライアントサイド）
2. reCAPTCHA検証（設定時）
3. メールアドレスでユーザー検索
4. パスワード認証の有効性確認
5. リセット頻度チェック（最近送信済みかどうか）
6. リセットトークン生成
7. パスワードリセットメール送信
8. ログイン画面にリダイレクト

**成功時**: ログイン画面にリダイレクトし、メール送信完了メッセージを表示
**失敗時**: エラーメッセージを表示してフォームに戻る

### 2-Sign inリンククリック

**トリガー**: 「Sign in」リンククリック

**処理**: ログイン画面（`/users/sign_in`）にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| リセット要求送信 | users | UPDATE | リセットトークン設定 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | reset_password_token | ハッシュ化されたトークン | Devise token generator使用 |
| UPDATE | reset_password_sent_at | 現在時刻 | 頻度制限チェックに使用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|----------|
| MSG001 | 情報 | If your email address exists in our database, you will receive a password recovery link at your email address in a few minutes. | リセット要求成功時（パラノイドモード） |
| MSG002 | エラー | Email can't be blank | メールアドレス未入力時 |
| MSG003 | エラー | Email is invalid | メールアドレス形式不正時 |
| MSG004 | エラー | There was an error with the reCAPTCHA | reCAPTCHA検証失敗時 |
| MSG005 | エラー | Password authentication is unavailable | パスワード認証無効時 |
| MSG006 | 説明 | Requires your primary or verified secondary GitLab email address. | フォーム説明文 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| メールアドレス未登録 | セキュリティ上、成功時と同じメッセージを表示（ユーザー列挙攻撃防止） |
| パスワード認証無効 | エラーメッセージを表示してリダイレクト |
| リセット頻度超過 | 成功時と同じメッセージを表示（スロットリング） |
| reCAPTCHA失敗 | エラーメッセージを表示してフォームに戻る |
| メール送信失敗 | システムエラーとしてログに記録、ユーザーには成功メッセージを表示 |

## 備考

- セキュリティ上、メールアドレスの存在有無に関わらず同じメッセージを表示する（パラノイドモード）
- リセットトークンの有効期限はDevise設定で定義（デフォルト6時間）
- 最近リセット要求を送信したユーザーには再度の送信をブロック（頻度制限）
- reCAPTCHAは管理者設定で有効化される
- プライマリメールアドレスまたは認証済みセカンダリメールアドレスのみ受け付ける

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パスワードリセットに関連するユーザーモデルの属性を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | Deviseの`:recoverable`モジュール、reset_password_token属性 |

**読解のコツ**: `devise :recoverable` によりパスワードリセット機能が有効化される。

#### Step 2: エントリーポイントを理解する

コントローラーの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | passwords_controller.rb | `app/controllers/passwords_controller.rb` | new/createアクション、before_actionフィルター |

**主要処理フロー**:
1. **9行目**: `check_recaptcha` - reCAPTCHA検証
2. **10行目**: `load_recaptcha` - reCAPTCHA設定読み込み
3. **11行目**: `resource_from_email` - メールアドレスからユーザー検索
4. **12行目**: `check_password_authentication_available` - パスワード認証有効性確認
5. **13行目**: `throttle_reset` - リセット頻度制限

#### Step 3: ビューテンプレートを理解する

画面の構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/devise/passwords/new.html.haml` | フォーム構成、バリデーション |

**主要処理フロー**:
- **1行目**: `gitlab_ui_form_for` でフォーム生成
- **5-8行目**: メールアドレス入力フィールドと説明テキスト
- **10-12行目**: reCAPTCHAタグ（条件付き）
- **14-15行目**: 送信ボタン

#### Step 4: Concernとヘルパーを理解する

GitLab固有のreCAPTCHA処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | gitlab_recaptcha.rb | `app/controllers/concerns/gitlab_recaptcha.rb` | reCAPTCHA検証ロジック |

### プログラム呼び出し階層図

```
PasswordsController#create
    │
    ├─ check_recaptcha (prepend_before_action)
    │      └─ verify_recaptcha
    │
    ├─ resource_from_email (before_action)
    │      └─ User.find_by_email
    │
    ├─ check_password_authentication_available (before_action)
    │      └─ Gitlab::CurrentSettings.password_authentication_enabled?
    │
    ├─ throttle_reset (before_action)
    │      └─ resource.recently_sent_password_reset?
    │
    └─ Devise::PasswordsController#create (super)
           ├─ User.send_reset_password_instructions
           │      ├─ generate_reset_password_token!
           │      └─ DeviseMailer.reset_password_instructions
           │
           └─ redirect_to after_sending_reset_password_instructions_path
```

### データフロー図

```
[入力]                    [処理]                              [出力]

user[email]      ───▶ PasswordsController#create ───▶ リダイレクト
                        │
                        ├─ User.find_by_email ───▶ users テーブル SELECT
                        │
                        ├─ generate_reset_password_token! ───▶ users テーブル UPDATE
                        │      (reset_password_token, reset_password_sent_at)
                        │
                        └─ DeviseMailer.reset_password_instructions ───▶ メール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| passwords_controller.rb | `app/controllers/passwords_controller.rb` | コントローラー | パスワードリセット処理の制御 |
| user.rb | `app/models/user.rb` | モデル | ユーザーデータと認証ロジック |
| new.html.haml | `app/views/devise/passwords/new.html.haml` | ビュー | パスワードリセット画面テンプレート |
| gitlab_recaptcha.rb | `app/controllers/concerns/gitlab_recaptcha.rb` | Concern | reCAPTCHA検証処理 |
| _sign_in_link.html.haml | `app/views/devise/shared/_sign_in_link.html.haml` | ビュー | ログインリンクパーシャル |
| _error_messages.html.haml | `app/views/devise/shared/_error_messages.html.haml` | ビュー | エラーメッセージ表示パーシャル |
| devise_mailer.rb | `app/mailers/devise_mailer.rb` | メーラー | Deviseメール送信処理 |
