# 画面設計書 202-アカウント設定

## 概要

本ドキュメントは、GitLabユーザーのアカウント設定画面について定義する。セキュリティ設定、外部認証プロバイダ連携、ユーザー名変更、アカウント削除などの重要なアカウント管理機能を提供する。

### 本画面の処理概要

本画面は、ユーザーアカウントに関する重要な設定を一元的に管理する画面である。2要素認証の状態確認、サポートPIN生成、外部サービス連携、ユーザー名変更、パイプラインスケジュールの確認、アカウント削除などの機能を提供する。

**業務上の目的・背景**：企業セキュリティポリシーへの準拠やアカウントのライフサイクル管理を行うために、ユーザー自身がセキュリティ設定やアカウント情報を管理できる必要がある。本画面は、アカウントセキュリティの強化（2FA設定）、トラブルシューティング支援（サポートPIN）、シングルサインオン設定（外部プロバイダ連携）、アカウント管理（ユーザー名変更・削除）を統合的に提供する。

**画面へのアクセス方法**：
1. 右上のユーザーアバターをクリック → 「Edit profile」を選択
2. 左側メニューから「Account」を選択
3. 直接URL: `/-/profile/account`

**主要な操作・処理内容**：
1. 2要素認証の有効化・管理画面への遷移
2. サポートPINの生成・表示
3. 外部認証プロバイダとの連携・解除
4. ユーザー名の変更
5. 所有するパイプラインスケジュールの確認
6. アカウントの削除

**画面遷移**：
- 遷移元：プロフィール編集画面、ヘッダーメニュー
- 遷移先：2要素認証設定画面、各パイプラインスケジュール画面、パスワードリセット画面
- 外部連携：OAuth認証プロバイダ画面

**権限による表示制御**：
- LDAPユーザー：一部オプションが利用不可（警告表示）
- グループ/組織の唯一のオーナー：アカウント削除不可
- 管理者設定によるアカウント削除禁止の場合：削除セクション無効化

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 77 | ユーザープロファイル | 主機能 | アカウント設定の管理 |
| 79 | 2要素認証 | 補助機能 | 2FA設定画面への遷移 |
| 88 | OAuth2プロバイダ | 補助機能 | 外部認証プロバイダ連携 |
| 49 | パイプラインスケジュール | 補助機能 | 所有スケジュールの表示 |

## 画面種別

設定（詳細・編集複合）

## URL/ルーティング

- **URL**: `/-/profile/account`
- **HTTPメソッド**: GET（表示）、POST（サポートPIN生成）、DELETE（プロバイダ連携解除）
- **ルーティング**: `profiles/accounts#show`、`profiles/accounts#generate_support_pin`、`profiles/accounts#unlink`

## 入出力項目

### サポートPIN生成

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| なし | - | - | - | POSTリクエストのみ |

### ユーザー名変更

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| username | フォーム入力 | String | 必須 | 新しいユーザー名 |

### プロバイダ連携解除

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| provider | URLパラメータ | String | 必須 | 解除するプロバイダ識別子 |

## 表示項目

| 項目名 | 表示内容 | データソース |
|--------|----------|--------------|
| 2FAステータス | Enabled/Disabled | current_user.two_factor_enabled? |
| サポートPIN | 6桁のPIN（存在時） | current_user.support_pin |
| PIN有効期限 | 有効期限日時 | current_user.support_pin_expires_at |
| 連携プロバイダ一覧 | OAuth連携済みプロバイダ | button_based_providers、group_saml_identities |
| 現在のユーザー名 | ユーザー名 | current_user.username |
| パイプラインスケジュール一覧 | 所有するアクティブスケジュール | current_user.pipeline_schedules.active |
| 削除制限情報 | 唯一のオーナーのグループ/組織 | current_user.solo_owned_groups、current_user.solo_owned_organizations |

## イベント仕様

### 1-2FA管理ボタン押下

**処理内容**：
1. `profile_two_factor_auth_path`へ遷移
2. 2要素認証設定画面を表示

### 2-サポートPIN生成ボタン押下

**処理内容**：
1. POSTリクエストを`generate_support_pin_profile_account_path`に送信
2. `Users::SupportPin::UpdateService`を実行
3. 成功時：「New Support PIN generated successfully.」を表示
4. 失敗時：「Failed to generate new Support PIN.」を表示
5. アカウント設定画面にリダイレクト

### 3-プロバイダ連携解除ボタン押下

**処理内容**：
1. DELETEリクエストを送信（provider指定）
2. 対象Identityを検索
3. プライマリログインプロバイダでない場合：Identity削除
4. プライマリログインプロバイダの場合：エラーメッセージ表示
5. アカウント設定画面にリダイレクト

### 4-ユーザー名変更

**処理内容**：
1. JavaScriptコンポーネント（#update-username）で処理
2. JSONフォーマットで`update_username_profile_path`にリクエスト
3. バリデーション成功時：ユーザー名更新
4. 失敗時：エラーメッセージ表示

### 5-アカウント削除ボタン押下

**処理内容**：
1. 削除確認モーダルを表示
2. 確認後、ユーザー削除処理を実行

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| サポートPIN生成 | users | UPDATE | support_pin、support_pin_expires_at更新 |
| プロバイダ連携解除 | identities | DELETE | 連携Identity削除 |
| ユーザー名変更 | users | UPDATE | username更新 |
| アカウント削除 | users等 | DELETE | ユーザー関連データ削除 |

### テーブル別更新項目詳細

#### users（サポートPIN生成）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | support_pin | 新規生成されたPIN | 6桁 |
| UPDATE | support_pin_expires_at | 現在時刻 + 有効期間 | |

#### identities（プロバイダ連携解除）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | provider = 指定プロバイダ | Identity全体を削除 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 通知 | Some options are unavailable for LDAP accounts | LDAPユーザーの場合 |
| 成功 | New Support PIN generated successfully. | PIN生成成功時 |
| エラー | Failed to generate new Support PIN. | PIN生成失敗時 |
| エラー | You are not allowed to unlink your primary login account | プライマリログインプロバイダ解除試行時 |
| 警告 | You must transfer ownership or delete these before you can delete your account. | 唯一のオーナーでアカウント削除不可時 |
| 情報 | Account deletion is not allowed by your administrator. | 管理者設定で削除禁止時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| プロバイダ未検出 | 404エラー返却 |
| 権限不足（アカウント削除） | 削除ボタン無効化、警告メッセージ表示 |
| パスワード未設定（削除時） | パスワードリセットリンク表示 |

## 備考

- passkeys機能フラグ有効時は「Manage authentication」セクションが表示される
- ユーザー名変更は副作用があるため、ヘルプリンクで注意喚起
- パイプラインスケジュールは最大500件まで表示
- EE版では追加機能（designated_beneficiaries等）が表示される場合がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アカウント設定に関連するユーザーモデルの属性を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | support_pin、two_factor_enabled?、solo_owned_groups等の属性 |
| 1-2 | identity.rb | `app/models/identity.rb` | 外部認証プロバイダとの連携データ構造 |
| 1-3 | pipeline_schedule.rb | `app/models/ci/pipeline_schedule.rb` | パイプラインスケジュールの構造 |

**読解のコツ**: Userモデルは非常に大きいため、関連メソッドをgrepで検索するとよい。

#### Step 2: エントリーポイントを理解する

コントローラーの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | accounts_controller.rb | `app/controllers/profiles/accounts_controller.rb` | show、unlink、generate_support_pinアクション |

**主要処理フロー**:
1. **10-12行目**: show - 表示処理
2. **14-27行目**: unlink - プロバイダ連携解除
3. **29-38行目**: generate_support_pin - サポートPIN生成
4. **46-50行目**: find_identity - Identity検索ロジック

#### Step 3: ビューレイヤーを理解する

画面表示のセクション構成を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/profiles/accounts/show.html.haml` | 各セクションの表示条件と構成 |
| 3-2 | _providers.html.haml | `app/views/profiles/accounts/_providers.html.haml` | 外部プロバイダ連携部分 |
| 3-3 | _two_factor_enabled_alert.html.haml | `app/views/profiles/accounts/_two_factor_enabled_alert.html.haml` | 2FA有効化アラート |

**主要処理フロー**:
- **14-36行目**: 2要素認証セクション（passkeysフラグ分岐あり）
- **38-57行目**: サポートPINセクション
- **59-64行目**: 外部プロバイダ連携セクション
- **66-74行目**: ユーザー名変更セクション
- **78-93行目**: パイプラインスケジュールセクション
- **94-146行目**: アカウント削除セクション

#### Step 4: サービスレイヤーを理解する

ビジネスロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | update_service.rb | `app/services/users/support_pin/update_service.rb` | サポートPIN生成ロジック |

### プログラム呼び出し階層図

```
AccountsController#show
    │
    ├─ show_view_variables（ローカル変数設定）
    │
    └─ render show.html.haml
           │
           ├─ _two_factor_enabled_alert.html.haml
           │
           ├─ _providers.html.haml
           │      └─ button_based_providers
           │
           └─ Layouts::SettingsSectionComponent
                  └─ 各セクション表示

AccountsController#generate_support_pin
    │
    └─ Users::SupportPin::UpdateService#execute
           └─ User#update (support_pin, support_pin_expires_at)

AccountsController#unlink
    │
    ├─ find_identity
    │      ├─ atlassian_identity（Atlassian用）
    │      └─ identities.find_by（その他）
    │
    └─ identity.destroy
```

### データフロー図

```
[入力]                    [処理]                           [出力]

GET /profile/account ──▶ AccountsController#show ──▶ show.html.haml
                              │                           │
                              ▼                           ▼
                         current_user ──────────▶ 各セクション表示

POST generate_support_pin
         │
         ▼
  UpdateService#execute ──▶ User.update ──▶ リダイレクト
                                              （成功/失敗メッセージ）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| accounts_controller.rb | `app/controllers/profiles/accounts_controller.rb` | コントローラー | アカウント設定の処理制御 |
| show.html.haml | `app/views/profiles/accounts/show.html.haml` | ビュー | アカウント設定画面のレンダリング |
| _providers.html.haml | `app/views/profiles/accounts/_providers.html.haml` | パーシャル | 外部プロバイダ連携セクション |
| _two_factor_enabled_alert.html.haml | `app/views/profiles/accounts/_two_factor_enabled_alert.html.haml` | パーシャル | 2FA有効化アラート |
| update_service.rb | `app/services/users/support_pin/update_service.rb` | サービス | サポートPIN生成ロジック |
| user.rb | `app/models/user.rb` | モデル | ユーザーデータの永続化 |
| identity.rb | `app/models/identity.rb` | モデル | 外部認証連携データ |
| profile.rb | `config/routes/profile.rb` | ルーティング | URLルーティング定義 |
