# 画面設計書 203-表示設定

## 概要

本ドキュメントは、GitLabのユーザー表示設定（Preferences）画面について定義する。UIテーマ、カラーモード、シンタックスハイライト、差分表示色、動作設定、言語・時間設定などの個人設定を管理する。

### 本画面の処理概要

本画面は、GitLabのユーザーインターフェースを個人の好みに合わせてカスタマイズするための設定画面である。視覚的な設定（テーマ、カラーモード、シンタックスハイライト）から動作設定（キーボードショートカット、レイアウト、デフォルトエディタ）、地域化設定（言語、時間形式）まで、広範なUIカスタマイズを提供する。

**業務上の目的・背景**：開発者はコードを長時間閲覧するため、目に優しい配色やワークフローに適した表示設定が生産性に直結する。本画面では、ダークモード/ライトモードの切り替え、シンタックスハイライトのカスタマイズ、差分表示の色調整など、開発者体験を向上させる設定を提供する。また、多言語対応やタイムゾーン設定により、グローバルチームでの協業を支援する。

**画面へのアクセス方法**：
1. 右上のユーザーアバターをクリック → 「Preferences」を選択
2. または「Edit profile」→ 左側メニューから「Preferences」を選択
3. 直接URL: `/-/profile/preferences`

**主要な操作・処理内容**：
1. カラーモード（Light/Dark/System）の選択
2. アプリケーションテーマ（ナビゲーションテーマ）の選択
3. シンタックスハイライトの配色選択（ライト/ダーク別）
4. 差分表示色（追加/削除行）のカスタマイズ
5. レイアウト幅（固定/流動）の設定
6. デフォルトテキストエディタの選択
7. ホームページ表示コンテンツの設定
8. キーボードショートカットの有効化/無効化
9. 言語・週の開始日・時間表示形式の設定
10. フォロー機能の有効化/無効化

**画面遷移**：
- 遷移元：プロフィール編集画面、ヘッダーメニュー、各種設定画面
- 遷移先：設定はAjaxで保存されるため画面遷移なし

**権限による表示制御**：
- ログインユーザーのみアクセス可能
- EE版では追加設定項目（Code Suggestions等）が表示される場合がある

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 77 | ユーザープロファイル | 主機能 | 表示・言語設定の管理 |

## 画面種別

設定（編集）

## URL/ルーティング

- **URL**: `/-/profile/preferences`
- **HTTPメソッド**: GET（表示）、PUT（更新）
- **ルーティング**: `profiles/preferences#show`、`profiles/preferences#update`

## 入出力項目

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| color_mode_id | フォーム | Integer | - | カラーモード（1: Light, 2: Dark, 3: System） |
| theme_id | フォーム | Integer | - | アプリケーションテーマID |
| color_scheme_id | フォーム | Integer | - | ライトモード用シンタックスハイライトスキームID |
| dark_color_scheme_id | フォーム | Integer | - | ダークモード用シンタックスハイライトスキームID |
| diffs_deletion_color | フォーム | String | - | 差分削除行の背景色（HEX） |
| diffs_addition_color | フォーム | String | - | 差分追加行の背景色（HEX） |
| keyboard_shortcuts_enabled | フォーム | Boolean | - | キーボードショートカット有効化 |
| layout | フォーム | String | - | レイアウト幅（fixed/fluid） |
| default_text_editor_enabled | フォーム | Boolean | - | デフォルトエディタ設定有効化 |
| text_editor | フォーム | String | - | デフォルトエディタ（rich_text_editor/plain_text_editor） |
| dashboard | フォーム | String | - | ホームページ表示コンテンツ |
| project_view | フォーム | String | - | プロジェクト概要ページのデフォルト表示 |
| project_shortcut_buttons | フォーム | Boolean | - | プロジェクト概要にショートカットボタン表示 |
| render_whitespace_in_code | フォーム | Boolean | - | Web IDEで空白文字表示 |
| show_whitespace_in_diffs | フォーム | Boolean | - | 差分で空白変更を表示 |
| view_diffs_file_by_file | フォーム | Boolean | - | 差分をファイル単位で表示 |
| markdown_surround_selection | フォーム | Boolean | - | 選択テキストを囲む記号入力 |
| markdown_automatic_lists | フォーム | Boolean | - | リスト自動追加 |
| markdown_maintain_indentation | フォーム | Boolean | - | インデント維持 |
| tab_width | フォーム | Integer | - | タブ幅（1-12） |
| preferred_language | フォーム | String | - | 表示言語 |
| first_day_of_week | フォーム | Integer | - | 週の開始日 |
| time_display_relative | フォーム | Boolean | - | 相対時間表示 |
| time_display_format | フォーム | String | - | 時間表示形式 |
| enabled_following | フォーム | Boolean | - | フォロー機能有効化 |

## 表示項目

| 項目名 | 表示内容 | データソース |
|--------|----------|--------------|
| カラーモード一覧 | Light/Dark/System | Gitlab::ColorModes.available_modes |
| テーマ一覧 | テーマ名とプレビュー | Gitlab::Themes.each |
| カラースキーム一覧 | スキーム名とプレビュー画像 | Gitlab::ColorSchemes.each |
| ダッシュボード選択肢 | ホームページコンテンツ一覧 | dashboard_choices |
| プロジェクトビュー選択肢 | 概要表示コンテンツ一覧 | project_view_choices |
| 言語一覧 | 利用可能な言語 | language_choices |
| 週開始日選択肢 | 曜日一覧 | first_day_of_week_choices_with_default |
| 時間形式選択肢 | 12時間/24時間等 | time_display_format_choices |

## イベント仕様

### 1-設定変更時

**処理内容**：
1. フォーム内の各設定項目が変更されると、自動的にAjaxリクエストを送信
2. PUTリクエストを`/-/profile/preferences`に送信
3. `Users::UpdateService`で設定を保存
4. 成功時：「Preferences saved.」メッセージをJSON形式で返却
5. 失敗時：「Failed to save preferences.」メッセージを返却
6. バリデーションエラー時：詳細エラーメッセージを返却

### 2-差分色カスタマイズ

**処理内容**：
1. Vue.jsコンポーネント（#js-profile-preferences-diffs-colors-app）で処理
2. カラーピッカーで色を選択
3. 選択した色をフォームに反映
4. 保存時に他の設定と一緒に送信

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定変更 | users | UPDATE | ユーザー設定カラムの更新 |
| 設定変更 | user_preferences | UPDATE | 追加設定の更新（存在する場合） |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | color_scheme_id | 選択されたスキームID | |
| UPDATE | color_mode_id | 選択されたモードID | |
| UPDATE | dark_color_scheme_id | 選択されたスキームID | |
| UPDATE | theme_id | 選択されたテーマID | |
| UPDATE | preferred_language | 選択された言語コード | |
| UPDATE | first_day_of_week | 選択された曜日番号 | |
| UPDATE | その他多数 | 各設定値 | preferences_param_namesで定義 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 成功 | Preferences saved. | 設定保存成功時 |
| エラー | Failed to save preferences. | 設定保存失敗時 |
| エラー | Failed to save preferences (%{error_message}). | バリデーションエラー時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| ArgumentError（dashboard無効値） | エラーメッセージと400ステータスを返却 |
| バリデーションエラー | エラーメッセージと400ステータスを返却 |

## 備考

- 設定変更は即座にAjaxで保存される（ページリロード不要）
- 一部の設定（テーマ、カラーモード）は保存後にページ全体のスタイルが即座に反映される
- タブ幅は1から12の範囲で設定可能
- 言語設定は実験的機能であり、翻訳が不完全な場合がある
- EE版ではCode Suggestions等の追加設定が表示される
- project_studio_enabled?フラグでテーマセクションの表示が変わる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

設定項目とユーザーモデルの関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | themes.rb | `lib/gitlab/themes.rb` | テーマ定義、available_themes |
| 1-2 | color_modes.rb | `lib/gitlab/color_modes.rb` | カラーモード定義 |
| 1-3 | color_schemes.rb | `lib/gitlab/color_schemes.rb` | シンタックスハイライトスキーム定義 |

**読解のコツ**: Themesクラスはユーザーごとのテーマ取得メソッド（for_user）を提供している。

#### Step 2: エントリーポイントを理解する

コントローラーの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | preferences_controller.rb | `app/controllers/profiles/preferences_controller.rb` | show、updateアクション |

**主要処理フロー**:
1. **13行目**: show - 単純な表示処理
2. **15-28行目**: update - 設定更新処理、JSON応答
3. **36-72行目**: preferences_param_names - 許可パラメータ定義

#### Step 3: ビューレイヤーを理解する

画面の各セクションを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/profiles/preferences/show.html.haml` | 各設定セクションの構成 |

**主要処理フロー**:
- **1-18行目**: 変数初期化、データ属性設定
- **20-31行目**: カラーモードセクション
- **32-59行目**: テーマセクション（project_studio_enabled?で分岐）
- **61-86行目**: シンタックスハイライトセクション
- **88-94行目**: 差分色セクション
- **98-176行目**: 動作設定セクション（多数のチェックボックス）
- **177-194行目**: 言語・地域設定セクション
- **196-214行目**: 時間設定セクション
- **215-226行目**: フォロー機能セクション
- **227行目**: Vue.jsアプリケーションマウントポイント

### プログラム呼び出し階層図

```
PreferencesController#show
    │
    └─ render show.html.haml
           │
           ├─ Gitlab::ColorModes.each
           │
           ├─ Gitlab::Themes.each
           │
           ├─ Gitlab::ColorSchemes.each
           │
           └─ #js-profile-preferences-app
                  └─ Vue.jsコンポーネント

PreferencesController#update
    │
    ├─ preferences_params（Strong Parameters）
    │
    └─ Users::UpdateService#execute
           │
           └─ User#update
                  └─ 各設定カラム更新
```

### データフロー図

```
[入力]                       [処理]                           [出力]

フォーム入力 ──────▶ PreferencesController#update ──────▶ JSON応答
(Ajax PUT)                    │                                │
                              ▼                                ▼
                   Users::UpdateService          {type: 'notice/alert',
                              │                   message: '...'}
                              ▼
                        User.update
                              │
                              ▼
                        usersテーブル更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| preferences_controller.rb | `app/controllers/profiles/preferences_controller.rb` | コントローラー | 表示設定の処理制御 |
| show.html.haml | `app/views/profiles/preferences/show.html.haml` | ビュー | 設定画面のレンダリング |
| themes.rb | `lib/gitlab/themes.rb` | ライブラリ | テーマ定義 |
| color_modes.rb | `lib/gitlab/color_modes.rb` | ライブラリ | カラーモード定義 |
| color_schemes.rb | `lib/gitlab/color_schemes.rb` | ライブラリ | シンタックスハイライト定義 |
| update_service.rb | `app/services/users/update_service.rb` | サービス | ユーザー設定更新 |
| preferences.scss | `app/assets/stylesheets/page_bundles/profiles/preferences.scss` | スタイル | 画面固有スタイル |
| profile.rb | `config/routes/profile.rb` | ルーティング | URLルーティング定義 |
