# 画面設計書 205-2要素認証設定

## 概要

本ドキュメントは、GitLabの2要素認証（2FA）設定画面について定義する。OTP（Time-based One-Time Password）、WebAuthnセキュリティキー、Passkey、リカバリーコードの登録・管理を行う。

### 本画面の処理概要

本画面は、ユーザーアカウントのセキュリティを強化するための2要素認証設定を管理する画面である。TOTP認証アプリの登録、WebAuthnセキュリティキーの登録、Passkeyの管理、リカバリーコードの再生成など、複数の2FA手段を統合的に管理する。

**業務上の目的・背景**：パスワード漏洩やフィッシング攻撃に対する防御として、2要素認証は必須のセキュリティ対策である。本画面では、Google Authenticator等のTOTPアプリ、YubiKey等のセキュリティキー（WebAuthn）、デバイス組み込みのPasskey（生体認証等）など、ユーザーの環境に応じた認証手段を選択・登録できる。また、組織のセキュリティポリシーで2FA必須の場合、本画面でのセットアップが必要となる。

**画面へのアクセス方法**：
1. 右上のユーザーアバターをクリック → 「Edit profile」を選択 → 「Account」→ 「Manage two-factor authentication」
2. または直接URL: `/-/profile/two_factor_auth`
3. 2FA必須環境ではログイン後自動的に本画面にリダイレクト

**主要な操作・処理内容**：
1. TOTP認証アプリの登録（QRコードスキャンまたは手動入力）
2. PINコード入力による認証アプリの検証
3. WebAuthnセキュリティキーの登録
4. Passkeyの登録・管理（passkeysフラグ有効時）
5. デフォルト2FA方式の選択
6. リカバリーコードの表示・再生成
7. 各認証方式の削除
8. 2FA全体の無効化

**画面遷移**：
- 遷移元：アカウント設定画面、ログイン画面（2FA必須時）
- 遷移先：リカバリーコード表示画面（2FA有効化完了時）、アカウント設定画面
- 2FA必須時のスキップ：猶予期間内であればルートURLへ遷移可能

**権限による表示制御**：
- ログインユーザーのみアクセス可能
- プライマリメール未確認時は2FA設定不可（メール設定画面へリダイレクト）
- 2FA必須グループ所属時は警告メッセージ表示
- 現在のパスワード入力が必要な操作あり（設定による）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 79 | 2要素認証 | 主機能 | 2要素認証の設定 |
| 76 | ユーザー登録 | 補助機能 | メール確認状態の検証 |

## 画面種別

設定（登録・管理）

## URL/ルーティング

- **URL**: `/-/profile/two_factor_auth`
- **HTTPメソッド**: GET（表示）、POST（OTP登録、WebAuthn登録）、DELETE（削除）
- **ルーティング**:
  - `profiles/two_factor_auths#show`
  - `profiles/two_factor_auths#create`（OTP登録）
  - `profiles/two_factor_auths#create_webauthn`（WebAuthn登録）
  - `profiles/two_factor_auths#codes`（リカバリーコード再生成）
  - `profiles/two_factor_auths#destroy`（2FA全体無効化）
  - `profiles/two_factor_auths#destroy_otp`（OTP削除）
  - `profiles/two_factor_auths#destroy_webauthn`（WebAuthn削除）

## 入出力項目

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| pin_code | フォーム | String | 必須 | 6桁のOTPコード |
| current_password | フォーム | String | 条件付き | 現在のパスワード（設定による） |
| device_registration[name] | フォーム | String | 必須 | WebAuthnデバイス名 |
| device_registration[device_response] | フォーム | String | 必須 | WebAuthn認証レスポンス（JSON） |

## 表示項目

| 項目名 | 表示内容 | データソース |
|--------|----------|--------------|
| 2FAステータス | Enabled/Disabled | current_user.two_factor_enabled? |
| QRコード | OTP登録用QRコード（SVG） | build_qr_code |
| アカウント文字列 | TOTP登録用文字列 | account_string |
| OTPシークレット | 手動入力用シークレットキー | current_user.otp_secret（未表示推奨） |
| WebAuthn登録一覧 | 登録済みセキュリティキー | @registrations |
| Passkey一覧 | 登録済みPasskey | @passkeys |
| デフォルト2FA方式 | 現在のデフォルト認証方式 | current_user.default_two_factor_type |
| 猶予期間 | 2FA設定猶予期限 | otp_grace_period_started_at + two_factor_grace_period |

## イベント仕様

### 1-OTP登録（PINコード入力）

**処理内容**：
1. POSTリクエストでpin_codeを送信
2. `Users::ValidateManualOtpService`でPINを検証
3. 検証成功時：
   - 他セッションを終了（destroy_all_but_current_user_session!）
   - otp_required_for_loginをtrueに更新
   - リカバリーコードが未生成の場合：コード生成して完了画面表示
   - 既にコードがある場合：成功メッセージと共に画面リダイレクト
4. 検証失敗時：エラーメッセージ表示、画面再表示
5. 通知メール送信（notification_service.enabled_two_factor）

### 2-WebAuthn登録

**処理内容**：
1. JavaScriptでWebAuthn APIを呼び出し
2. セキュリティキーで認証
3. device_responseをサーバーに送信
4. `Webauthn::RegisterService`で登録処理
5. 成功時：メッセージ表示、リカバリーコード生成（必要時）
6. 失敗時：エラーメッセージ表示

### 3-リカバリーコード再生成

**処理内容**：
1. 現在のパスワード入力（必要時）
2. POSTリクエストを`/profile/two_factor_auth/codes`に送信
3. `user.generate_otp_backup_codes!`でコード再生成
4. リカバリーコード表示画面へ遷移

### 4-2FA無効化

**処理内容**：
1. 確認モーダル表示
2. 現在のパスワード入力（必要時）
3. DELETEリクエストを`/profile/two_factor_auth`に送信
4. `TwoFactor::DestroyService`で2FA無効化
5. 成功時：メッセージ表示、画面リダイレクト
6. 失敗時：エラーメッセージ表示

### 5-OTP削除

**処理内容**：
1. 現在のパスワード入力（必要時）
2. DELETEリクエストを送信
3. `TwoFactor::DestroyOtpService`でOTP設定削除
4. メッセージ表示、画面リダイレクト

### 6-WebAuthn削除

**処理内容**：
1. 削除対象のセキュリティキーIDを指定
2. 現在のパスワード入力（必要時）
3. DELETEリクエストを送信
4. `Webauthn::DestroyService`でWebAuthn登録削除
5. メッセージ表示、画面リダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| OTP登録 | users | UPDATE | otp_required_for_login、otp_backup_codes更新 |
| WebAuthn登録 | webauthn_registrations | INSERT | セキュリティキー登録 |
| リカバリーコード再生成 | users | UPDATE | otp_backup_codes更新 |
| 2FA無効化 | users、webauthn_registrations | UPDATE/DELETE | 2FA関連データ削除 |
| OTP削除 | users | UPDATE | OTP関連カラムクリア |
| WebAuthn削除 | webauthn_registrations | DELETE | セキュリティキー登録削除 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | otp_required_for_login | true | OTP有効化時 |
| UPDATE | otp_backup_codes | 暗号化されたコード配列 | リカバリーコード |
| UPDATE | encrypted_otp_secret | null | OTP削除時 |

#### webauthn_registrations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | user_id | current_user.id | |
| INSERT | name | フォーム入力値 | デバイス名 |
| INSERT | credential_xid | WebAuthnレスポンスから | |
| INSERT | public_key | WebAuthnレスポンスから | |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 成功 | Your Time-based OTP device was registered! | OTP登録成功時（既存コードあり） |
| 成功 | Successfully deleted WebAuthn device. | WebAuthn削除成功時 |
| 成功 | One-time password authenticator has been deleted! | OTP削除成功時 |
| 成功 | Two-factor authentication has been disabled successfully! | 2FA無効化成功時 |
| エラー | Invalid pin code. | OTP検証失敗時 |
| エラー | You must provide a valid current password. | パスワード検証失敗時 |
| 警告 | The global settings require you to enable Two-Factor Authentication for your account. | グローバル2FA必須時 |
| 警告 | Administrator users are required to enable Two-Factor Authentication for their account. | 管理者2FA必須時 |
| 警告 | The group settings for %{group_links} require you to enable Two-Factor Authentication for your account. | グループ2FA必須時 |
| 通知 | You need to verify your primary email first before enabling Two-Factor Authentication. | プライマリメール未確認時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| プライマリメール未確認 | メール設定画面へリダイレクト |
| パスワード検証失敗 | failed_attempts増加、エラー表示 |
| WebAuthn登録失敗 | エラーメッセージ表示、画面再表示 |
| 2FA必須でスキップ不可 | 設定画面にリダイレクト、警告表示 |

## 備考

- passkeysフラグ有効時はPasskeyセクションが表示される
- OTPシークレットはshow時に自動更新される（needs_new_otp_secret?）
- リカバリーコードは10個生成、各コード1回使用可能
- WebAuthnはauthenticator_selectionでuser_verification: 'discouraged'設定
- 2FA有効化時は他のアクティブセッションを強制終了
- email_based_mfaフラグ有効時はメールOTPセクションが表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

2FAに関連するモデルとテーブル構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | webauthn_registration.rb | `app/models/webauthn_registration.rb` | WebAuthn登録データ構造 |
| 1-2 | user.rb（2FA関連） | `app/models/user.rb` | two_factor_enabled?、otp_backup_codes等 |

**読解のコツ**: UserモデルにはDevise OTPモジュールが含まれ、OTP関連のメソッドが追加されている。

#### Step 2: エントリーポイントを理解する

コントローラーの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | two_factor_auths_controller.rb | `app/controllers/profiles/two_factor_auths_controller.rb` | 各アクションの処理フロー |

**主要処理フロー**:
1. **20-22行目**: show - 画面表示準備
2. **24-52行目**: create - OTP登録処理
3. **55-89行目**: create_webauthn - WebAuthn登録処理
4. **91-97行目**: codes - リカバリーコード再生成
5. **99-109行目**: destroy - 2FA全体無効化
6. **111-121行目**: destroy_otp - OTP削除
7. **123-131行目**: destroy_webauthn - WebAuthn削除
8. **273-295行目**: setup_show_page - 表示データ準備

#### Step 3: ビューレイヤーを理解する

画面の各セクションを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/profiles/two_factor_auths/show.html.haml` | メイン画面構成 |
| 3-2 | _otp_registration.html.haml | `app/views/profiles/two_factor_auths/_otp_registration.html.haml` | OTP登録セクション |
| 3-3 | _webauthn_registration.html.haml | `app/views/profiles/two_factor_auths/_webauthn_registration.html.haml` | WebAuthn登録セクション |
| 3-4 | _passkeys.html.haml | `app/views/profiles/two_factor_auths/_passkeys.html.haml` | Passkey管理セクション |
| 3-5 | _recovery_codes.html.haml | `app/views/profiles/two_factor_auths/_recovery_codes.html.haml` | リカバリーコードセクション |

**主要処理フロー**:
- **18-28行目**: Passkeyセクション（passkeysフラグ時）
- **30-52行目**: 2FAセクション
- **54-60行目**: Email OTPセクション（email_based_mfaフラグ時）

#### Step 4: サービスレイヤーを理解する

ビジネスロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | validate_manual_otp_service.rb | `app/services/users/validate_manual_otp_service.rb` | OTP検証ロジック |
| 4-2 | register_service.rb | `app/services/webauthn/register_service.rb` | WebAuthn登録ロジック |
| 4-3 | destroy_service.rb | `app/services/two_factor/destroy_service.rb` | 2FA無効化ロジック |

### プログラム呼び出し階層図

```
TwoFactorAuthsController#show
    │
    ├─ ensure_verified_primary_email（before_action）
    │
    ├─ update_current_user_otp!
    │      └─ User#update_otp_secret!
    │
    └─ setup_show_page
           ├─ build_qr_code
           ├─ setup_webauthn_registration
           │      └─ WebAuthn::Credential.options_for_create
           └─ get_passkeys

TwoFactorAuthsController#create
    │
    ├─ validate_current_password（before_action、条件付き）
    │
    ├─ Users::ValidateManualOtpService#execute
    │
    ├─ destroy_all_but_current_user_session!
    │
    ├─ Users::UpdateService#execute!
    │      └─ otp_required_for_login = true
    │
    └─ user.generate_otp_backup_codes!（必要時）
```

### データフロー図

```
[入力]                       [処理]                           [出力]

QRコードスキャン
         │
         ▼
PIN入力 ──────▶ ValidateManualOtpService ──────▶ OTP検証
                        │
                        ▼
                 Users::UpdateService
                        │
                        ▼
                usersテーブル更新
                        │
                        ▼
            generate_otp_backup_codes! ──────▶ リカバリーコード画面
                                                     or
                                              成功メッセージ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| two_factor_auths_controller.rb | `app/controllers/profiles/two_factor_auths_controller.rb` | コントローラー | 2FA設定の処理制御 |
| show.html.haml | `app/views/profiles/two_factor_auths/show.html.haml` | ビュー | 2FA設定画面のレンダリング |
| _otp_registration.html.haml | `app/views/profiles/two_factor_auths/_otp_registration.html.haml` | パーシャル | OTP登録セクション |
| _webauthn_registration.html.haml | `app/views/profiles/two_factor_auths/_webauthn_registration.html.haml` | パーシャル | WebAuthn登録セクション |
| validate_manual_otp_service.rb | `app/services/users/validate_manual_otp_service.rb` | サービス | OTP検証 |
| register_service.rb | `app/services/webauthn/register_service.rb` | サービス | WebAuthn登録 |
| destroy_service.rb | `app/services/two_factor/destroy_service.rb` | サービス | 2FA無効化 |
| webauthn_registration.rb | `app/models/webauthn_registration.rb` | モデル | WebAuthn登録データ |
| profile.rb | `config/routes/profile.rb` | ルーティング | URLルーティング定義 |
