# 画面設計書 206-リカバリーコード表示

## 概要

本ドキュメントは、2要素認証のリカバリーコード（バックアップコード）を表示する画面について定義する。リカバリーコードの再生成後にコードを安全に保存するための画面である。

### 本画面の処理概要

本画面は、2要素認証が有効な状態でリカバリーコードを再生成した際に、新しいコードを表示する画面である。リカバリーコードは、認証アプリやセキュリティキーが利用できない緊急時のバックアップ認証手段として使用される。

**業務上の目的・背景**：スマートフォンの紛失、機種変更、セキュリティキーの故障など、通常の2FA手段が利用できなくなった場合に、アカウントへのアクセスを維持するためのバックアップ認証手段が必要である。リカバリーコードは各コード1回限り使用可能で、使用後は無効になる。本画面で表示されるコードを安全な場所に保管することで、緊急時のアカウント復旧が可能になる。

**画面へのアクセス方法**：
1. 2要素認証設定画面でリカバリーコード再生成を実行
2. POSTリクエスト成功後に本画面にリダイレクト
3. 直接URL: `/-/profile/two_factor_auth/codes`（GET）

**主要な操作・処理内容**：
1. 生成されたリカバリーコード（10個）の表示
2. コードのコピー（クリップボードへ）
3. コードの印刷
4. コードのダウンロード（テキストファイル）
5. 2要素認証設定画面への遷移

**画面遷移**：
- 遷移元：2要素認証設定画面（リカバリーコード再生成後）
- 遷移先：2要素認証設定画面

**権限による表示制御**：
- ログインユーザーのみアクセス可能
- リカバリーコードが存在する場合のみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 79 | 2要素認証 | 主機能 | 2FAリカバリーコードの表示 |

## 画面種別

表示（詳細）

## URL/ルーティング

- **URL**: `/-/profile/two_factor_auth/codes`
- **HTTPメソッド**: GET（表示）、POST（再生成後リダイレクト）
- **ルーティング**: `profiles/two_factor_auths#codes`

## 入出力項目

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| current_password | フォーム | String | 条件付き | 現在のパスワード（再生成時、設定による） |

## 表示項目

| 項目名 | 表示内容 | データソース |
|--------|----------|--------------|
| リカバリーコード一覧 | 10個のリカバリーコード | @codes |
| 成功メッセージ | 2FA有効化成功メッセージ | flash（show_success_alert時） |

## イベント仕様

### 1-コードコピーボタン押下

**処理内容**：
1. JavaScriptでクリップボードAPIを呼び出し
2. 全リカバリーコードをテキストとしてコピー
3. コピー成功通知を表示

### 2-印刷ボタン押下

**処理内容**：
1. ブラウザの印刷ダイアログを表示
2. リカバリーコード部分を印刷用フォーマットで出力

### 3-ダウンロードボタン押下

**処理内容**：
1. リカバリーコードをテキストファイルとして生成
2. ファイルをダウンロード（gitlab-recovery-codes.txt等）

### 4-「Proceed」ボタン押下

**処理内容**：
1. 2要素認証設定画面（`/-/profile/two_factor_auth`）へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

本画面は表示専用であり、データベース更新は発生しない。
（コード再生成はTwoFactorAuthsController#codesアクションで事前に実行済み）

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし（表示のみ） | - | - | - |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 成功 | You have set up 2FA for your account! | 2FA有効化完了時（show_success_alert: true） |
| 警告 | 各コードは1回のみ使用可能 | 常時表示（UIテキスト） |
| 情報 | 安全な場所にコードを保管してください | 常時表示（UIテキスト） |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| @codesが空 | コード表示部分が空になる |
| 未認証アクセス | ログイン画面へリダイレクト |

## 備考

- リカバリーコードは10個生成され、各コード1回のみ使用可能
- コードは8文字のランダム英数字で構成
- 使用済みコードはデータベースから削除される
- ページ離脱後はコードを再表示できない（再生成が必要）
- セキュリティ上、コードは画面に表示後はサーバー側で参照不可
- _codes.html.hamlパーシャルで実際のコード表示を行う

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リカバリーコードの構造とユーザーとの関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb（otp関連） | `app/models/user.rb` | generate_otp_backup_codes!メソッド |

**読解のコツ**: リカバリーコードはUserモデルのotp_backup_codesカラムに暗号化して保存される。

#### Step 2: エントリーポイントを理解する

コントローラーの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | two_factor_auths_controller.rb | `app/controllers/profiles/two_factor_auths_controller.rb` | codesアクション |

**主要処理フロー**:
1. **91-97行目**: codes - リカバリーコード再生成
2. **92-96行目**: UpdateService内でgenerate_otp_backup_codes!実行
3. @codesにコード配列を格納

#### Step 3: ビューレイヤーを理解する

画面の構成を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | codes.html.haml | `app/views/profiles/two_factor_auths/codes.html.haml` | リカバリーコード表示画面 |
| 3-2 | _codes.html.haml | `app/views/profiles/two_factor_auths/_codes.html.haml` | コード表示パーシャル |

**主要処理フロー**:
- **1行目**: ページタイトル設定
- **5行目**: _codesパーシャルのレンダリング

### プログラム呼び出し階層図

```
TwoFactorAuthsController#codes
    │
    ├─ validate_current_password（before_action、条件付き）
    │
    └─ Users::UpdateService#execute!
           │
           └─ user.generate_otp_backup_codes!
                  │
                  ├─ 10個のランダムコード生成
                  │
                  └─ @codesに格納
                         │
                         ▼
                   codes.html.haml
                         │
                         └─ _codes.html.haml
```

### データフロー図

```
[入力]                       [処理]                           [出力]

POST /profile/two_factor_auth/codes
         │
         ▼
  validate_current_password
         │
         ▼
  Users::UpdateService
         │
         ▼
  generate_otp_backup_codes!
         │
         ├─ ランダムコード10個生成
         │
         ├─ usersテーブル更新（暗号化して保存）
         │
         └─ @codesに平文コードを格納
                   │
                   ▼
            codes.html.haml ──────▶ リカバリーコード表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| two_factor_auths_controller.rb | `app/controllers/profiles/two_factor_auths_controller.rb` | コントローラー | コード再生成の処理制御 |
| codes.html.haml | `app/views/profiles/two_factor_auths/codes.html.haml` | ビュー | リカバリーコード表示画面 |
| _codes.html.haml | `app/views/profiles/two_factor_auths/_codes.html.haml` | パーシャル | コード表示部分 |
| profile_two_factor_auth.scss | `app/assets/stylesheets/page_bundles/profile_two_factor_auth.scss` | スタイル | 画面固有スタイル |
| profile.rb | `config/routes/profile.rb` | ルーティング | URLルーティング定義 |
