# 画面設計書 208-メール管理

## 概要

本ドキュメントは、ユーザーのメールアドレスを管理する画面について定義する。プライマリメールとセカンダリメールの追加・削除・確認メール再送信を行う。

### 本画面の処理概要

本画面は、GitLabアカウントに紐づくメールアドレスの管理を行う。プライマリメール（アカウント登録時のメール）に加えて、セカンダリメール（追加メール）を登録でき、それぞれをコミットメール、公開メール、通知メールとして使い分けることができる。

**業務上の目的・背景**：GitLabユーザーは、プライベート用と業務用など複数のメールアドレスを使い分けるケースが多い。本画面により、目的に応じて異なるメールアドレスを登録し、GitLabの各機能（通知、コミット署名、公開プロフィール等）で適切なメールを使用できる。未確認のセカンダリメールは3日後に自動削除される。

**画面へのアクセス方法**：
1. サイドメニューから「Emails」を選択
2. 直接URL: `/-/profile/emails`

**主要な操作・処理内容**：
1. 登録済みメールアドレス一覧の表示
2. 新規メールアドレスの追加
3. セカンダリメールの削除
4. 確認メールの再送信

**画面遷移**：
- 遷移元：各種プロフィール設定画面
- 遷移先：本画面内での操作（追加・削除後リロード）

**権限による表示制御**：
- ログインユーザーのみアクセス可能
- プライマリメールは削除不可

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|-------------------|
| 82 | メール管理 | 主機能 | メールアドレスの管理 |

## 画面種別

一覧＋入力（CRUD）

## URL/ルーティング

- **URL**: `/-/profile/emails`
- **HTTPメソッド**: GET（一覧表示）、POST（追加）、DELETE（削除）、PUT（確認メール再送信）
- **ルーティング**: `profiles/emails#index`, `profiles/emails#create`, `profiles/emails#destroy`, `profiles/emails#resend_confirmation_instructions`

## 入出力項目

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| email | フォーム | String | 必須 | 追加するメールアドレス |

## 表示項目

| 項目名 | 表示内容 | データソース |
|--------|----------|--------------|
| プライマリメール | 登録時のメールアドレス | @primary_email |
| セカンダリメール一覧 | 追加されたメールアドレス | @emails |
| 確認状態バッジ | Verified/Unverified | email.confirmed? |
| 用途表示 | Commit email/Public email/Notification email | current_user各属性 |
| 未確認メール警告 | 3日後削除警告 | @show_unconfirmed_emails_alert |

## イベント仕様

### 1-「Add new email」トグル押下

**処理内容**：
1. メールアドレス入力フォームを展開表示

### 2-「Add email address」ボタン押下

**処理内容**：
1. Emails::CreateServiceを呼び出し
2. メールアドレスをemailsテーブルに登録
3. 確認メールを送信
4. profile_emails_urlにリダイレクト

**バリデーション**：
- メールアドレス形式チェック
- 重複チェック
- レートリミット（profile_add_new_email）

### 3-「Resend confirmation email」ボタン押下

**処理内容**：
1. Emails::ConfirmServiceを呼び出し
2. 確認メールを再送信
3. 成功/失敗メッセージを表示

**レートリミット**：profile_resend_email_confirmation

### 4-削除アイコン押下

**処理内容**：
1. 確認ダイアログを表示
2. Emails::DestroyServiceを呼び出し
3. メールアドレスをemailsテーブルから削除
4. profile_emails_urlにリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| メール追加 | emails | INSERT | 新規メールアドレス登録 |
| メール削除 | emails | DELETE | セカンダリメール削除 |
| 確認メール再送 | emails | UPDATE | confirmation_sent_at更新 |

### テーブル別詳細

#### emails

| カラム | 操作 | 値 |
|-------|------|-----|
| email | INSERT | 入力値 |
| user_id | INSERT | current_user.id |
| confirmation_token | INSERT | 自動生成 |
| confirmed_at | INSERT | NULL |
| confirmation_sent_at | INSERT/UPDATE | 現在時刻 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 警告 | Unverified secondary email addresses are automatically deleted after three days | 未確認メールが存在する場合 |
| 成功 | Confirmation email sent to {email} | 確認メール再送成功時 |
| エラー | There was a problem sending the confirmation email | 確認メール再送失敗時 |
| エラー | バリデーションエラーメッセージ | メール追加失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| レートリミット超過 | エラーメッセージ表示、前の画面にリダイレクト |
| メールが見つからない | 404エラー |
| 未認証アクセス | ログイン画面へリダイレクト |

## 備考

- プライマリメールはプロフィール設定画面で変更する
- 未確認メールは3日後に自動削除される
- コミットメール、公開メール、通知メールの設定は各設定画面で行う
- SettingsSectionComponentとCrudComponentを使用したUI構成
- メールはorder_id_descでソート（新しいものが上）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メールアドレスの格納構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | email.rb | `app/models/email.rb` | Emailモデルの構造 |

**読解のコツ**: EmailモデルはUserに属し、Confirmableモジュールで確認メール機能を持つ。

#### Step 2: エントリーポイントを理解する

コントローラーの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | emails_controller.rb | `app/controllers/profiles/emails_controller.rb` | 各アクションの処理 |

**主要処理フロー**:
1. **15-19行目**: index - メール一覧取得
2. **25-30行目**: create - メール追加
3. **32-39行目**: destroy - メール削除
4. **41-49行目**: resend_confirmation_instructions - 確認メール再送

#### Step 3: ビューレイヤーを理解する

画面の構成を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/profiles/emails/index.html.haml` | メール管理画面 |

**主要処理フロー**:
- **8-11行目**: SettingsSectionComponentでセクション構成
- **12-16行目**: 未確認メール警告の条件付き表示
- **17-32行目**: CrudComponentでメール追加フォーム
- **33-86行目**: メール一覧表示

### プログラム呼び出し階層図

```
Profiles::EmailsController
    │
    ├─ index
    │      │
    │      ├─ @primary_email = current_user.email
    │      │
    │      ├─ @emails = current_user.emails.order_id_desc
    │      │
    │      └─ @show_unconfirmed_emails_alert
    │
    ├─ create
    │      │
    │      ├─ check_rate_limit!(:profile_add_new_email)
    │      │
    │      └─ Emails::CreateService#execute
    │             │
    │             ├─ Email.create
    │             │
    │             └─ 確認メール送信
    │
    ├─ destroy
    │      │
    │      └─ Emails::DestroyService#execute
    │             │
    │             └─ Email.destroy
    │
    └─ resend_confirmation_instructions
           │
           ├─ check_rate_limit!(:profile_resend_email_confirmation)
           │
           └─ Emails::ConfirmService#execute
                  │
                  └─ 確認メール再送信
```

### データフロー図

```
[入力]                       [処理]                           [出力]

GET /profile/emails
         │
         ▼
  EmailsController#index
         │
         ├─ current_user.email → @primary_email
         │
         ├─ current_user.emails → @emails
         │
         └─ 未確認チェック → @show_unconfirmed_emails_alert
                   │
                   ▼
            index.html.haml ──────▶ メール一覧表示

POST /profile/emails
(email)
         │
         ├─ rate_limit_check
         │
         └─ Emails::CreateService
                   │
                   ├─ emailsテーブルINSERT
                   │
                   └─ 確認メール送信
                            │
                            ▼
                   redirect_to profile_emails_url

DELETE /profile/emails/:id
         │
         └─ Emails::DestroyService
                   │
                   └─ emailsテーブルDELETE
                            │
                            ▼
                   redirect_to profile_emails_url
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| emails_controller.rb | `app/controllers/profiles/emails_controller.rb` | コントローラー | メール管理CRUD処理 |
| index.html.haml | `app/views/profiles/emails/index.html.haml` | ビュー | メール管理画面 |
| email.rb | `app/models/email.rb` | モデル | メールアドレスデータ |
| create_service.rb | `app/services/emails/create_service.rb` | サービス | メール追加処理 |
| destroy_service.rb | `app/services/emails/destroy_service.rb` | サービス | メール削除処理 |
| confirm_service.rb | `app/services/emails/confirm_service.rb` | サービス | 確認メール送信処理 |
| _email_with_badge.html.haml | `app/views/shared/_email_with_badge.html.haml` | パーシャル | メール表示バッジ |
| profile.rb | `config/routes/profile.rb` | ルーティング | URLルーティング定義 |
