# 画面設計書 209-チャット名管理

## 概要

本ドキュメントは、SlackやMattermost等の外部チャットサービスとの連携アカウントを管理する画面について定義する。連携済みのチャット名（アカウントニックネーム）の一覧表示と削除を行う。

### 本画面の処理概要

本画面は、GitLabと連携しているSlackやMattermostのアカウント情報を一覧表示し、不要になった連携を解除する機能を提供する。GitLab for Slack appやMattermost slash commandsを使用するために、ユーザーはチャットサービス側からGitLabアカウントを認可する必要があり、その認可情報がここに表示される。

**業務上の目的・背景**：GitLabはSlackやMattermostと統合し、チャット上からIssueの作成、デプロイの実行、ChatOpsジョブの実行などを可能にしている。本画面では、これらの連携に使用されるアカウント情報を管理する。複数のワークスペースやチームドメインからの連携がある場合、それぞれを個別に管理できる。

**画面へのアクセス方法**：
1. サイドメニューから「Integration accounts」を選択
2. 直接URL: `/-/user_settings/integration_accounts`

**主要な操作・処理内容**：
1. 連携済みチャットアカウント一覧の表示
2. チャット連携の削除

**画面遷移**：
- 遷移元：各種プロフィール設定画面、チャット名追加画面
- 遷移先：本画面内での操作（削除後リロード）

**権限による表示制御**：
- ログインユーザーのみアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|-------------------|
| 95 | Slack連携 | 主機能 | チャット連携名の管理 |

## 画面種別

一覧

## URL/ルーティング

- **URL**: `/-/user_settings/integration_accounts`
- **HTTPメソッド**: GET（一覧表示）、DELETE（削除）
- **ルーティング**: `profiles/chat_names#index`, `profiles/chat_names#destroy`

## 入出力項目

本画面は一覧表示画面であり、入力項目はない。

## 表示項目

| 項目名 | 表示内容 | データソース |
|--------|----------|--------------|
| チャット名一覧 | 連携済みアカウント | @chat_names |
| Team domain | チームドメイン名 | chat_name.team_domain |
| Nickname | ニックネーム | chat_name.chat_name |
| Last used | 最終使用日時 | chat_name.last_used_at |
| 空メッセージ | 連携なしメッセージ | @chat_names.blank? |

## イベント仕様

### 1-削除アイコン押下

**処理内容**：
1. ChatNameモデルのdestroyを実行
2. 成功/失敗メッセージをflashに設定
3. user_settings_integration_accounts_pathにリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| チャット名削除 | chat_names | DELETE | チャット連携情報の削除 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 情報 | You do not have any connected integration accounts. | @chat_names.blank? |
| 成功 | Deleted account nickname: {chat_name}! | 削除成功時 |
| エラー | Could not delete account nickname {chat_name}. | 削除失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| チャット名が見つからない | 404エラー |
| 未認証アクセス | ログイン画面へリダイレクト |

## 備考

- チャット名はSlackまたはMattermostから認可フローを経て登録される
- team_idがTで始まりchat_idがU/Wで始まる場合はSlack、それ以外はMattermost
- 連携アカウントはテーブル形式で表示
- SettingsSectionComponentとCrudComponentを使用したUI構成
- @chat_namesコレクションはパーシャルでレンダリング

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

チャット名の格納構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | chat_name.rb | `app/models/chat_name.rb` | ChatNameモデルの構造 |

**読解のコツ**: ChatNameはUserに属し、team_id、team_domain、chat_id、chat_name等の情報を持つ。暗号化カラムも存在する。

#### Step 2: エントリーポイントを理解する

コントローラーの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | chat_names_controller.rb | `app/controllers/profiles/chat_names_controller.rb` | 各アクションの処理 |

**主要処理フロー**:
1. **11-13行目**: index - チャット名一覧取得
2. **41-51行目**: destroy - チャット名削除

#### Step 3: ビューレイヤーを理解する

画面の構成を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/profiles/chat_names/index.html.haml` | チャット名管理画面 |
| 3-2 | _chat_name.html.haml | `app/views/profiles/chat_names/_chat_name.html.haml` | チャット名行パーシャル |

**主要処理フロー**:
- **5-8行目**: SettingsSectionComponentでセクション構成
- **9-11行目**: CrudComponentで一覧表示
- **13-25行目**: テーブル形式での一覧表示
- **23行目**: @chat_namesコレクションをパーシャルでレンダリング

### プログラム呼び出し階層図

```
Profiles::ChatNamesController
    │
    ├─ index
    │      │
    │      └─ @chat_names = current_user.chat_names
    │                │
    │                ▼
    │          index.html.haml
    │                │
    │                └─ render @chat_names
    │                         │
    │                         └─ _chat_name.html.haml（各行）
    │
    └─ destroy
           │
           ├─ @chat_name = chat_names.find(params[:id])
           │
           └─ @chat_name.destroy
                  │
                  ├─ [成功] flash[:notice]
                  │
                  └─ [失敗] flash[:alert]
                           │
                           ▼
                  redirect_to user_settings_integration_accounts_path
```

### データフロー図

```
[入力]                       [処理]                           [出力]

GET /user_settings/integration_accounts
         │
         ▼
  ChatNamesController#index
         │
         └─ current_user.chat_names → @chat_names
                   │
                   ▼
            index.html.haml
                   │
                   ├─ @chat_names.present?
                   │        │
                   │        ├─ [true] テーブル表示
                   │        │          │
                   │        │          └─ render @chat_names
                   │        │
                   │        └─ [false] 空メッセージ
                   │
                   ▼
            チャット名一覧表示

DELETE /user_settings/integration_accounts/:id
         │
         └─ ChatNamesController#destroy
                   │
                   ├─ chat_names.find(params[:id])
                   │
                   └─ chat_name.destroy
                            │
                            ▼
                   redirect_to user_settings_integration_accounts_path
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| chat_names_controller.rb | `app/controllers/profiles/chat_names_controller.rb` | コントローラー | チャット名管理処理 |
| index.html.haml | `app/views/profiles/chat_names/index.html.haml` | ビュー | チャット名一覧画面 |
| _chat_name.html.haml | `app/views/profiles/chat_names/_chat_name.html.haml` | パーシャル | チャット名行表示 |
| chat_name.rb | `app/models/chat_name.rb` | モデル | チャット名データ |
| profile.rb | `config/routes/profile.rb` | ルーティング | URLルーティング定義 |
