# 画面設計書 210-チャット名追加

## 概要

本ドキュメントは、SlackやMattermost等の外部チャットサービスからGitLabアカウントを認可する画面について定義する。チャットサービス側から認可フローを開始した際に表示される。

### 本画面の処理概要

本画面は、SlackやMattermostなどのチャットサービスからGitLab連携を開始した際に、GitLab側でユーザーの認可を求める画面である。ユーザーがチャットサービス側でGitLabコマンドを初めて使用した際にリダイレクトされ、認可または拒否を選択する。

**業務上の目的・背景**：GitLab for Slack appやMattermost slash commandsを使用すると、チャット上からIssue作成、デプロイ実行、ChatOpsジョブなどのGitLab操作が可能になる。セキュリティ上、これらの操作にはGitLabアカウントとの紐付けが必要であり、本画面でユーザーの明示的な同意を得る。認可後は、チャットサービス上のユーザーIDとGitLabアカウントが紐付けられる。

**画面へのアクセス方法**：
1. Slack/MattermostでGitLabコマンドを初めて実行
2. チャットサービスからGitLabにリダイレクト
3. URL: `/-/user_settings/integration_accounts/new?token={token}`

**主要な操作・処理内容**：
1. 認可要求の内容確認
2. 「Authorize」ボタンで認可
3. 「Deny」ボタンで拒否

**画面遷移**：
- 遷移元：Slack/Mattermostからのリダイレクト
- 遷移先：チャット名管理画面（認可/拒否後）

**権限による表示制御**：
- ログインユーザーのみアクセス可能
- 有効なトークンが必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|-------------------|
| 95 | Slack連携 | 主機能 | チャット連携名の追加 |

## 画面種別

入力（認可）

## URL/ルーティング

- **URL**: `/-/user_settings/integration_accounts/new`
- **HTTPメソッド**: GET（認可画面表示）、POST（認可）、DELETE（拒否）
- **ルーティング**: `profiles/chat_names#new`, `profiles/chat_names#create`, `profiles/chat_names#deny`

## 入出力項目

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| token | Hidden | String | 必須 | 認可トークン（URLパラメータ→hidden field） |

## 表示項目

| 項目名 | 表示内容 | データソース |
|--------|----------|--------------|
| インテグレーション名 | GitLab for Slack app / Mattermost slash commands | @integration_name |
| ユーザー名 | チャット側ユーザー名 | @chat_name_params[:chat_name] |
| 権限説明 | 付与される権限の一覧 | 固定テキスト |

## イベント仕様

### 1-「Authorize」ボタン押下

**処理内容**：
1. chat_name_paramsからChatNameを作成
2. current_user.chat_names.create
3. chat_name_tokenを削除
4. user_settings_integration_accounts_pathにリダイレクト

**成功時**：
- flash[:notice]に「Authorized {chat_name}」を設定

**失敗時**：
- flash[:alert]に「Could not authorize integration account nickname. Try again!」を設定

### 2-「Deny」ボタン押下

**処理内容**：
1. chat_name_tokenを削除
2. flash[:notice]に「Denied authorization of account nickname {user_name}.」を設定
3. user_settings_integration_accounts_pathにリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Authorize | chat_names | INSERT | チャット連携情報の登録 |
| Deny | - | - | データベース更新なし |

### テーブル別詳細

#### chat_names（Authorize時）

| カラム | 操作 | 値 |
|-------|------|-----|
| user_id | INSERT | current_user.id |
| team_id | INSERT | chat_name_params[:team_id] |
| team_domain | INSERT | chat_name_params[:team_domain] |
| chat_id | INSERT | chat_name_params[:chat_id] |
| chat_name | INSERT | chat_name_params[:chat_name] |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 情報 | Authorize {integration_name} ({user}) to use your account? | 常時表示（タイトル） |
| 情報 | An application called {integration_name} is requesting access to your GitLab account. | 常時表示（説明） |
| 情報 | Create and read issue data and comments. | 常時表示（権限リスト） |
| 情報 | Perform deployments. | 常時表示（権限リスト） |
| 情報 | Run ChatOps jobs. | 常時表示（権限リスト） |
| 情報 | You don't have to reauthorize this application if the permission scope changes in future releases. | 常時表示（補足） |
| 成功 | Authorized {chat_name} | 認可成功時 |
| 成功 | Denied authorization of account nickname {user_name}. | 拒否時 |
| エラー | Could not authorize integration account nickname. Try again! | 認可失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| トークンが無効/期限切れ | 404エラー |
| トークンパラメータなし | 404エラー |
| 未認証アクセス | ログイン画面へリダイレクト |

## 備考

- トークンはGitlab::ChatNameTokenで管理される一時トークン
- team_idがTで始まりchat_idがU/Wで始まる場合はSlack、それ以外はMattermost
- インテグレーション名は動的に「GitLab for Slack app」または「Mattermost slash commands」
- CardComponentを使用したUI構成
- 認可完了後、チャットサービス側でGitLabコマンドが使用可能になる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

トークンとチャット名パラメータの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | chat_name_token.rb | `lib/gitlab/chat_name_token.rb` | トークン管理クラス |
| 1-2 | chat_name.rb | `app/models/chat_name.rb` | ChatNameモデルの構造 |

**読解のコツ**: ChatNameTokenはRedisベースの一時トークンで、チャットサービスからのパラメータを保持する。

#### Step 2: エントリーポイントを理解する

コントローラーの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | chat_names_controller.rb | `app/controllers/profiles/chat_names_controller.rb` | new/create/denyアクション |

**主要処理フロー**:
1. **15-17行目**: new - 認可画面表示
2. **19-30行目**: create - 認可処理
3. **32-39行目**: deny - 拒否処理
4. **73-77行目**: integration_name - インテグレーション名判定
5. **79-82行目**: slack_app_params? - Slack/Mattermost判定

#### Step 3: ビューレイヤーを理解する

画面の構成を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/profiles/chat_names/new.html.haml` | 認可画面 |

**主要処理フロー**:
- **5-7行目**: CardComponentのヘッダー（タイトル）
- **8-18行目**: CardComponentのボディ（説明・権限リスト）
- **19-28行目**: CardComponentのフッター（ボタン）
- **21-24行目**: Authorizeフォーム（POST）
- **25-28行目**: Denyフォーム（DELETE）

### プログラム呼び出し階層図

```
Profiles::ChatNamesController
    │
    ├─ before_action :chat_name_token
    │      │
    │      └─ Gitlab::ChatNameToken.new(params[:token])
    │
    ├─ before_action :chat_name_params
    │      │
    │      └─ @chat_name_token.get || render_404
    │
    ├─ new
    │      │
    │      └─ @integration_name = integration_name
    │             │
    │             └─ slack_app_params? → Slack or Mattermost
    │
    ├─ create
    │      │
    │      ├─ current_user.chat_names.new(chat_name_params)
    │      │
    │      ├─ new_chat_name.save
    │      │      │
    │      │      ├─ [成功] flash[:notice]
    │      │      │
    │      │      └─ [失敗] flash[:alert]
    │      │
    │      ├─ delete_chat_name_token
    │      │
    │      └─ redirect_to user_settings_integration_accounts_path
    │
    └─ deny
           │
           ├─ delete_chat_name_token
           │
           ├─ flash[:notice]
           │
           └─ redirect_to user_settings_integration_accounts_path
```

### データフロー図

```
[入力]                       [処理]                           [出力]

Slack/Mattermost
         │
         └─ GitLabコマンド実行
                   │
                   ▼
            Gitlab::ChatNameToken生成
                   │
                   └─ パラメータ保存（Redis）
                            │
                            ▼
GET /user_settings/integration_accounts/new?token=xxx
         │
         ▼
  ChatNamesController#new
         │
         ├─ chat_name_token → トークン検証
         │
         ├─ chat_name_params → パラメータ取得
         │
         └─ integration_name → Slack/Mattermost判定
                   │
                   ▼
            new.html.haml ──────▶ 認可画面表示

POST /user_settings/integration_accounts
         │
         ├─ chat_names.create(chat_name_params)
         │        │
         │        └─ chat_namesテーブルINSERT
         │
         └─ delete_chat_name_token
                   │
                   ▼
            redirect_to index ──────▶ チャット名一覧

DELETE /user_settings/integration_accounts/deny
         │
         └─ delete_chat_name_token
                   │
                   ▼
            redirect_to index ──────▶ チャット名一覧
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| chat_names_controller.rb | `app/controllers/profiles/chat_names_controller.rb` | コントローラー | 認可フロー制御 |
| new.html.haml | `app/views/profiles/chat_names/new.html.haml` | ビュー | 認可画面 |
| chat_name.rb | `app/models/chat_name.rb` | モデル | チャット名データ |
| chat_name_token.rb | `lib/gitlab/chat_name_token.rb` | ライブラリ | トークン管理 |
| profile.rb | `config/routes/profile.rb` | ルーティング | URLルーティング定義 |
