# 画面設計書 211-コメントテンプレート

## 概要

本ドキュメントは、GitLabのコメントテンプレート管理画面の設計仕様を記載したものです。

### 本画面の処理概要

コメントテンプレート管理画面は、ユーザーがイシュー、マージリクエスト、エピック等へのコメント作成時に再利用可能なテンプレートを管理するための画面です。

**業務上の目的・背景**：開発チームでは頻繁に同様のコメント（レビューコメント、承認コメント、定型的な質問等）を記述する必要があります。この画面を使用することで、ユーザーは定型的なコメントをテンプレートとして保存し、再利用することができます。これにより、コメント作成の効率化と品質の均一化を実現します。

**画面へのアクセス方法**：ユーザーアバターのドロップダウンメニューから「設定」を選択し、左サイドバーの「コメントテンプレート」をクリックしてアクセスします。URLは `/-/profile/comment_templates` です。

**主要な操作・処理内容**：
1. コメントテンプレート一覧の表示：登録済みのテンプレートを一覧表示
2. 新規テンプレートの作成：名前と内容を指定してテンプレートを作成
3. テンプレートの編集：既存テンプレートの名前・内容の変更
4. テンプレートの削除：不要なテンプレートの削除

**画面遷移**：この画面はプロフィール設定画面群の一部として位置付けられています。左サイドバーから他の設定画面（プロフィール編集、アカウント設定、通知設定など）へ遷移できます。

**権限による表示制御**：ログインユーザーのみがアクセス可能です。各ユーザーは自分のテンプレートのみ管理でき、他のユーザーのテンプレートは参照・編集できません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 149 | イシュー/MRテンプレート | 主機能 | コメントテンプレートの管理 |

## 画面種別

一覧・編集画面（Vue.jsによるSPA）

## URL/ルーティング

| メソッド | パス | アクション |
|----------|------|-----------|
| GET | /-/profile/comment_templates | index |
| GET | /-/profile/comment_templates/:id | index（同一画面で処理） |

```ruby
# config/routes/profile.rb (line 46)
resources :comment_templates, only: [:index, :show], action: :index
```

## 入出力項目

### 入力項目（テンプレート作成・編集）

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| テンプレート名 | name | string | ○ | 255 | テンプレートの識別名 |
| 内容 | content | text | ○ | 10000 | テンプレートの本文（Markdown対応） |

## 表示項目

### テンプレート一覧

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| テンプレート名 | saved_replies.name | テンプレートの名前 |
| 内容プレビュー | saved_replies.content | テンプレート内容の先頭部分 |
| 作成日時 | saved_replies.created_at | テンプレート作成日時 |
| 更新日時 | saved_replies.updated_at | テンプレート最終更新日時 |

## イベント仕様

### 1-新規作成ボタン押下

「新規作成」ボタンを押下すると、テンプレート作成フォームがモーダルまたはインライン形式で表示されます。名前と内容を入力後、「保存」ボタンで保存処理が実行されます。

### 2-編集ボタン押下

各テンプレートの「編集」ボタンを押下すると、編集フォームが表示されます。名前と内容を変更後、「更新」ボタンで更新処理が実行されます。

### 3-削除ボタン押下

各テンプレートの「削除」ボタンを押下すると、確認ダイアログが表示されます。「削除」を確定すると、テンプレートが削除されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | saved_replies | INSERT | 新規テンプレートレコードの作成 |
| 編集保存 | saved_replies | UPDATE | テンプレートレコードの更新 |
| 削除 | saved_replies | DELETE | テンプレートレコードの削除 |

### テーブル別更新項目詳細

#### saved_replies

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | user_id | current_user.id | 作成者のユーザーID |
| INSERT | name | 入力値 | テンプレート名 |
| INSERT | content | 入力値 | テンプレート内容 |
| INSERT | created_at | 現在時刻 | 作成日時 |
| INSERT | updated_at | 現在時刻 | 更新日時 |
| UPDATE | name | 入力値 | 変更後のテンプレート名 |
| UPDATE | content | 入力値 | 変更後のテンプレート内容 |
| UPDATE | updated_at | 現在時刻 | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG001 | 成功 | コメントテンプレートを作成しました | テンプレート作成成功時 |
| MSG002 | 成功 | コメントテンプレートを更新しました | テンプレート更新成功時 |
| MSG003 | 成功 | コメントテンプレートを削除しました | テンプレート削除成功時 |
| MSG004 | エラー | テンプレート名を入力してください | 名前が空の場合 |
| MSG005 | エラー | 内容を入力してください | 内容が空の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | ログイン画面へリダイレクト |
| テンプレートが見つからない（編集・削除時） | 404エラー表示 |
| 権限不足（他ユーザーのテンプレート操作時） | 404エラー表示 |
| バリデーションエラー | エラーメッセージ表示 |

## 備考

- テンプレートの実際の利用は、イシュー・MR・エピックのコメント入力欄で行います
- GraphQL APIを通じてCRUD操作が行われます（Vue.jsフロントエンド）
- 保存されたテンプレートは `Users::SavedReply` モデルとして管理されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コメントテンプレートのデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | saved_reply.rb | `app/models/users/saved_reply.rb` | SavedReplyモデルの定義、バリデーション、アソシエーション |
| 1-2 | saved_reply_concern.rb | `app/models/concerns/saved_reply_concern.rb` | 共通の振る舞い定義 |

**読解のコツ**: `Users::SavedReply` は個人用コメントテンプレートを管理するモデルです。`user_id`を外部キーとしてユーザーに紐付きます。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | comment_templates_controller.rb | `app/controllers/profiles/comment_templates_controller.rb` | コントローラーの構造、アクション |

**主要処理フロー**:
1. **行4-5**: feature_category :user_profile の設定
2. **行7-9**: before_action で検索設定を非表示に

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/profiles/comment_templates/index.html.haml` | ビューのエントリーポイント |
| 3-2 | _page.html.haml | `app/views/shared/comment_templates/_page.html.haml` | 共有パーシャル、Vue.jsコンポーネントのマウントポイント |

**主要処理フロー**:
- **行1**: shared/comment_templates/page パーシャルをレンダリング
- パーシャルでは `#js-comment-templates-root` にVue.jsアプリケーションをマウント

#### Step 4: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | profile.rb | `config/routes/profile.rb` | ルーティング定義 |

**主要処理フロー**:
- **行46**: `resources :comment_templates, only: [:index, :show], action: :index`

### プログラム呼び出し階層図

```
HTTP Request: GET /-/profile/comment_templates
    |
    +-- Profiles::CommentTemplatesController#index
           |
           +-- before_action: @hide_search_settings = true
           |
           +-- render "shared/comment_templates/page"
                  |
                  +-- Vue.js Application Mount
                         |
                         +-- GraphQL API Calls
                                |
                                +-- Users::SavedReply Model
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー操作 ───▶ Vue.jsコンポーネント ───▶ 画面表示更新
                       |
                       ▼
                 GraphQL API
                       |
                       ▼
              Users::SavedReply
                       |
                       ▼
                saved_replies テーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| comment_templates_controller.rb | `app/controllers/profiles/comment_templates_controller.rb` | コントローラー | リクエスト処理 |
| index.html.haml | `app/views/profiles/comment_templates/index.html.haml` | テンプレート | ビューのエントリーポイント |
| _page.html.haml | `app/views/shared/comment_templates/_page.html.haml` | テンプレート | 共有パーシャル |
| saved_reply.rb | `app/models/users/saved_reply.rb` | モデル | データモデル定義 |
| profile.rb | `config/routes/profile.rb` | ルーティング | URL定義 |
