# 画面設計書 212-Passkey追加

## 概要

本ドキュメントは、GitLabのPasskey追加画面の設計仕様を記載したものです。

### 本画面の処理概要

Passkey追加画面は、ユーザーがパスワードレス認証のためのPasskey（WebAuthn資格情報）を登録するための画面です。

**業務上の目的・背景**：従来のパスワード認証に加え、より安全で便利な認証方法としてPasskeyが注目されています。Passkeyは生体認証やデバイスのPINを使用してパスワードなしでログインできる技術です。この画面を通じて、ユーザーは自分のアカウントにPasskeyを追加し、パスワードレス認証を有効化できます。これによりフィッシング攻撃への耐性向上とユーザー体験の向上を実現します。

**画面へのアクセス方法**：ユーザー設定 > アカウント > 2要素認証の画面から「Passkeyを追加」ボタンをクリックしてアクセスします。URLは `/-/profile/passkeys/new` です。

**主要な操作・処理内容**：
1. Passkey登録フォームの表示：ブラウザのWebAuthn APIと連携
2. 現在のパスワード入力（必要な場合）：パスワード認証を有効にしているユーザーは現在のパスワードを入力
3. Passkey名の設定：登録するPasskeyの識別名を入力
4. ブラウザの認証画面との連携：指紋認証、顔認証、PINなどのデバイス認証
5. 登録完了処理：WebAuthn資格情報のサーバー保存

**画面遷移**：2要素認証設定画面（`/-/profile/two_factor_auth`）から遷移してきます。登録完了後は2要素認証設定画面にリダイレクトされます。

**権限による表示制御**：ログインユーザーのみがアクセス可能です。また、Passkeyフィーチャーフラグが有効になっている必要があります。パスワードが自動設定されていないユーザーは、現在のパスワード入力が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 79 | 2要素認証 | 主機能 | Passkeyの追加 |

## 画面種別

登録画面

## URL/ルーティング

| メソッド | パス | アクション |
|----------|------|-----------|
| GET | /-/profile/passkeys/new | new |
| POST | /-/profile/passkeys | create |
| DELETE | /-/profile/passkeys/:id | destroy |

```ruby
# config/routes/profile.rb (line 72)
resources :passkeys, only: [:new, :create, :destroy]
```

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 現在のパスワード | current_password | string | △ | パスワード認証有効時のみ必須 |
| Passkey名 | name | string | ○ | 登録するPasskeyの識別名 |
| デバイスレスポンス | device_response | JSON | ○ | WebAuthn APIからの認証レスポンス（自動取得） |

### 出力項目（画面表示）

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| 画面タイトル | 固定値 | "Add passkey" |
| 説明文 | 固定値 | ブラウザの指示に従ってPasskeyを追加する旨の説明 |
| ヘルプリンク | help_page_path | Passkeyのヘルプドキュメントへのリンク |
| エラーメッセージ | @webauthn_error | パスワード検証エラー等 |

## イベント仕様

### 1-画面読み込み時

画面読み込み時に以下の処理が実行されます：
1. Passkeyフィーチャーフラグの確認
2. 現在のパスワード入力が必要かの判定
3. WebAuthn登録オプションの生成
4. セッションにチャレンジを保存
5. Vue.jsコンポーネントへのデータ受け渡し

### 2-登録ボタン押下

Vue.jsコンポーネントで登録ボタンが押下されると：
1. 現在のパスワードの検証（必要な場合）
2. ブラウザのWebAuthn APIを呼び出し
3. デバイス認証（指紋、顔、PINなど）の実行
4. サーバーへの認証情報送信
5. 登録成功時は2要素認証設定画面へリダイレクト

### 3-キャンセル

キャンセル時は2要素認証設定画面へ戻ります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 登録実行 | webauthn_registrations | INSERT | Passkey認証情報の登録 |
| 登録実行 | user_details | UPDATE | webauthn_xid の設定（初回のみ） |

### テーブル別更新項目詳細

#### webauthn_registrations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | user_id | current_user.id | ユーザーID |
| INSERT | credential_xid | WebAuthn レスポンスから取得 | 認証情報ID |
| INSERT | public_key | WebAuthn レスポンスから取得 | 公開鍵 |
| INSERT | counter | 0 | 認証カウンター |
| INSERT | name | 入力値 | Passkey名 |
| INSERT | authentication_mode | 1 (passwordless) | Passkeyモード |
| INSERT | passkey_eligible | true | Passkey対象フラグ |

#### user_details

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | webauthn_xid | WebAuthn.generate_user_id | 初回登録時のみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG001 | 成功 | Passkeyが登録されました | 登録成功時 |
| MSG002 | エラー | 現在のパスワードが正しくありません | パスワード検証失敗時 |
| MSG003 | エラー | Passkey登録に失敗しました | WebAuthn登録失敗時 |
| MSG004 | 情報 | ブラウザの指示に従ってPasskeyを追加してください | 画面説明 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | ログイン画面へリダイレクト |
| Passkeyフィーチャー無効 | 404エラー表示 |
| パスワード検証失敗 | エラーメッセージ表示、失敗回数カウントアップ |
| WebAuthn登録失敗 | エラーメッセージ表示 |
| ブラウザ非対応 | エラーメッセージ表示 |

## 備考

- Passkeyは `Feature.enabled?(:passkeys, current_user)` で有効化されている必要があります
- WebAuthn仕様に準拠した実装となっています
- 登録時は `resident_key: 'required'`、`user_verification: 'required'` が設定されます
- 登録後、他のセッションは無効化されません（destroyアクションでは無効化される）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Passkeyの認証情報を管理するデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | webauthn_registration.rb | `app/models/webauthn_registration.rb` | WebAuthnRegistrationモデル、認証モードの定義 |

**読解のコツ**: `authentication_mode` enumで `passwordless: 1` がPasskeyモード、`second_factor: 2` が従来の2FA用WebAuthnです。`passkey` スコープで `passwordless` モードのものを取得します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | passkeys_controller.rb | `app/controllers/profiles/passkeys_controller.rb` | コントローラーの全体構造 |

**主要処理フロー**:
1. **行8**: `check_passkeys_available!` でフィーチャーフラグ確認
2. **行10-12**: パスワード検証の条件付き実行
3. **行18-27**: `new` アクション - 登録ページ表示とイベントトラッキング
4. **行29-56**: `create` アクション - Passkey登録処理
5. **行59-68**: `destroy` アクション - Passkey削除処理
6. **行95-107**: `setup_passkey_registration_page` - WebAuthnオプション生成

#### Step 3: ビューとヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/profiles/passkeys/new.html.haml` | ビューテンプレート |
| 3-2 | device_registration_helper.rb | `app/helpers/device_registration_helper.rb` | Vue.jsコンポーネントへのデータ受け渡し |

**主要処理フロー**:
- **行14**: `#js-passkey-registration` にVue.jsコンポーネントをマウント
- `device_registration_data` ヘルパーで必要なデータをJSONとして渡す

#### Step 4: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | register_service.rb | `app/services/authn/passkey/register_service.rb` | 登録サービス（推定パス） |
| 4-2 | destroy_service.rb | `app/services/authn/passkey/destroy_service.rb` | 削除サービス（推定パス） |

### プログラム呼び出し階層図

```
HTTP Request: GET /-/profile/passkeys/new
    |
    +-- Profiles::PasskeysController#new
           |
           +-- check_passkeys_available!
           |       +-- Feature.enabled?(:passkeys, current_user)
           |
           +-- track_passkey_internal_event
           |
           +-- setup_passkey_registration_page
                  |
                  +-- WebauthnRegistration.passkey.new
                  |
                  +-- user.user_detail.update!(webauthn_xid: ...)
                  |
                  +-- WebAuthn::Credential.options_for_create
                  |
                  +-- session[:challenge] = options.challenge
                  |
                  +-- gon.push(webauthn: { options: options })

HTTP Request: POST /-/profile/passkeys
    |
    +-- Profiles::PasskeysController#create
           |
           +-- validate_current_password (条件付き)
           |
           +-- Authn::Passkey::RegisterService.new(...).execute
                  |
                  +-- WebAuthn検証
                  |
                  +-- WebauthnRegistration INSERT
                  |
                  +-- redirect_to profile_two_factor_auth_path
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ブラウザ ───▶ WebAuthn API ───▶ 認証レスポンス
                                      |
                                      ▼
                           PasskeysController#create
                                      |
                                      ▼
                           RegisterService.execute
                                      |
                                      ▼
                           webauthn_registrations INSERT
                                      |
                                      ▼
                           リダイレクト ───▶ 2FA設定画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| passkeys_controller.rb | `app/controllers/profiles/passkeys_controller.rb` | コントローラー | リクエスト処理 |
| new.html.haml | `app/views/profiles/passkeys/new.html.haml` | テンプレート | ビュー表示 |
| device_registration_helper.rb | `app/helpers/device_registration_helper.rb` | ヘルパー | データ変換 |
| webauthn_registration.rb | `app/models/webauthn_registration.rb` | モデル | データモデル |
| profile.rb | `config/routes/profile.rb` | ルーティング | URL定義 |
| register_service.rb | `app/services/authn/passkey/register_service.rb` | サービス | 登録ロジック |
| destroy_service.rb | `app/services/authn/passkey/destroy_service.rb` | サービス | 削除ロジック |
