# 画面設計書 213-Slack連携編集

## 概要

本ドキュメントは、GitLabのSlack連携編集画面の設計仕様を記載したものです。

### 本画面の処理概要

Slack連携編集画面は、ユーザーがGitLab for Slackアプリケーションとの連携を管理するための画面です。Slack連携が無効になっているプロジェクトを確認し、Slackとの連携を有効化するためのリンクを取得できます。

**業務上の目的・背景**：チーム間のコミュニケーション効率化のため、GitLabとSlackの連携は重要な機能です。この画面を通じて、ユーザーは自分が管理権限を持つプロジェクトについて、Slack連携の状態を確認し、必要に応じて連携を有効化するためのリンクを取得できます。これにより、GitLabのイベント（MRの作成、CI/CDの完了など）をSlackチャンネルに通知できるようになります。

**画面へのアクセス方法**：ユーザー設定からSlack連携設定へ直接アクセス、またはSlack連携通知からのリダイレクトでアクセスします。URLは `/-/profile/slack/edit` です。

**主要な操作・処理内容**：
1. Slack連携が無効なプロジェクト一覧の表示：ユーザーがMAINTAINER以上の権限を持つプロジェクト
2. プロジェクト選択：連携を有効化したいプロジェクトを選択
3. Slackへの追加リンク取得：選択したプロジェクトに対する「Add to Slack」リンクを生成

**画面遷移**：プロフィール設定画面から遷移してきます。「Add to Slack」リンクをクリックすると、Slackの認可画面（外部）へ遷移します。

**権限による表示制御**：未ログインでもアクセス可能ですが、ログイン時のみプロジェクト一覧が表示されます。プロジェクトはMAINTAINER以上の権限を持つものに限定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 95 | Slack連携 | 主機能 | Slack連携設定の編集 |

## 画面種別

編集画面（Vue.jsによるSPA）

## URL/ルーティング

| メソッド | パス | アクション |
|----------|------|-----------|
| GET | /-/profile/slack/edit | edit |
| GET | /-/profile/slack/slack_link | slack_link（AJAX） |

```ruby
# config/routes/profile.rb (lines 38-42)
resource :slack, only: [:edit] do
  member do
    get :slack_link
  end
end
```

## 入出力項目

### 入力項目（AJAX）

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| プロジェクトID | project_id | integer | ○ | 連携を有効化するプロジェクトのID |

### 出力項目

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| プロジェクト一覧 | disabled_projects | Slack連携が無効なプロジェクト |
| プロジェクト名 | project.name | プロジェクト名 |
| プロジェクトパス | project.name_with_namespace | フルパス表示 |
| アバター | project.avatar_url | プロジェクトアバター |
| サインインパス | new_session_path | 未ログイン時のサインインリンク |
| Slackリンク | add_to_slack_link | Slack連携追加リンク |

## イベント仕様

### 1-画面読み込み時

画面読み込み時に以下の処理が実行されます：
1. ユーザーがログインしているか確認
2. ログイン時：Slack連携が無効かつMAINTAINER以上のプロジェクトを取得
3. Vue.jsコンポーネントへデータを渡す

### 2-プロジェクト選択時

プロジェクトを選択すると：
1. `/profile/slack/slack_link` エンドポイントにAJAXリクエスト
2. 選択されたプロジェクト用の「Add to Slack」リンクを生成
3. レスポンスとしてリンクURLを返却

### 3-Add to Slack クリック

「Add to Slack」ボタンをクリックすると：
1. 外部のSlack認可画面へリダイレクト
2. ユーザーがSlackワークスペースを選択し認可
3. GitLabにコールバック

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | projects | SELECT | Slack連携無効プロジェクトの取得 |
| 画面表示 | project_members | SELECT | 権限確認のためのメンバー情報取得 |

### テーブル別更新項目詳細

この画面での直接的なデータベース更新はありません。Slack連携の実際の有効化は、Slackからのコールバック時に別の処理で行われます。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG001 | 情報 | GitLab for Slack | 画面タイトル |
| MSG002 | 情報 | サインインしてください | 未ログイン時 |
| MSG003 | 情報 | 連携可能なプロジェクトがありません | プロジェクトがない場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | サインインリンクを表示 |
| プロジェクトが見つからない | エラーレスポンス |
| Slack App ID未設定 | リンク生成不可 |

## 備考

- 未ログインでも画面表示は可能（サインインへの誘導）
- Slack App IDは `Gitlab::CurrentSettings.slack_app_id` から取得
- 連携対象はSlackアプリケーション連携が無効なプロジェクトのみ
- プロジェクトの絞り込みには `with_slack_application_disabled` スコープを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | slacks_controller.rb | `app/controllers/profiles/slacks_controller.rb` | コントローラーの全体構造 |

**主要処理フロー**:
1. **行7**: `skip_before_action :authenticate_user!` - 認証スキップ
2. **行13-15**: `edit` アクション - Slack連携無効プロジェクトの取得
3. **行17-21**: `slack_link` アクション - Add to Slackリンクの生成
4. **行26-29**: `disabled_projects` - MAINTAINER権限 + Slack無効プロジェクト取得

#### Step 2: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | edit.html.haml | `app/views/profiles/slacks/edit.html.haml` | ビューテンプレート |

**主要処理フロー**:
- **行4**: ページタイトル設定
- **行6**: Vue.jsコンポーネントのマウント

#### Step 3: ヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | integrations_helper.rb | `app/helpers/integrations_helper.rb` | `gitlab_slack_application_data` ヘルパー |

**主要処理フロー**:
- **行246-255**: `gitlab_slack_application_data` - Vue.jsに渡すデータの生成

### プログラム呼び出し階層図

```
HTTP Request: GET /-/profile/slack/edit
    |
    +-- Profiles::SlacksController#edit
           |
           +-- (skip authenticate_user!)
           |
           +-- disabled_projects
           |       |
           |       +-- current_user.authorized_projects(MAINTAINER)
           |       |
           |       +-- with_slack_application_disabled
           |
           +-- render edit.html.haml
                  |
                  +-- gitlab_slack_application_data(@projects)
                         |
                         +-- Vue.js Application Mount

HTTP Request: GET /-/profile/slack/slack_link?project_id=xxx
    |
    +-- Profiles::SlacksController#slack_link
           |
           +-- disabled_projects.find(params[:project_id])
           |
           +-- add_to_slack_link(project, slack_app_id)
           |
           +-- render json: { add_to_slack_link: link }
```

### データフロー図

```
[入力]               [処理]                    [出力]

画面アクセス ───▶ SlacksController#edit ───▶ Vue.js表示
                       |
                       ▼
              disabled_projects 取得
                       |
                       ▼
              gitlab_slack_application_data
                       |
                       ▼
              プロジェクト一覧表示 ───▶ Slack連携リンク
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| slacks_controller.rb | `app/controllers/profiles/slacks_controller.rb` | コントローラー | リクエスト処理 |
| edit.html.haml | `app/views/profiles/slacks/edit.html.haml` | テンプレート | ビュー表示 |
| integrations_helper.rb | `app/helpers/integrations_helper.rb` | ヘルパー | データ生成 |
| profile.rb | `config/routes/profile.rb` | ルーティング | URL定義 |
