# 画面設計書 214-使用量クォータ

## 概要

本ドキュメントは、GitLabの個人使用量クォータ画面の設計仕様を記載したものです。

### 本画面の処理概要

使用量クォータ画面は、ユーザーの個人名前空間におけるリソース使用状況を表示するための画面です。ストレージ使用量、CI/CDパイプラインの使用状況などを確認できます。

**業務上の目的・背景**：GitLabではユーザーやグループ単位でリソース使用量を管理しています。この画面を通じて、ユーザーは自分の個人名前空間（`~username`）のストレージ使用量やCI/CD分数の消費状況を確認できます。使用量制限が設定されている環境では、制限に近づいた際の計画立案に役立ちます。

**画面へのアクセス方法**：ユーザーアバターのドロップダウンメニューから「設定」を選択し、左サイドバーの「使用量クォータ」をクリックしてアクセスします。URLは `/-/profile/usage_quotas` です。

**主要な操作・処理内容**：
1. ストレージ使用量の表示：プロジェクト別のストレージ使用量
2. CI/CD分数の使用状況表示（有料プランの場合）
3. Pagesの使用状況表示（有料プランの場合）
4. 使用量詳細の展開・折りたたみ

**画面遷移**：この画面はプロフィール設定画面群の一部として位置付けられています。他の設定画面へはサイドバーから遷移できます。

**権限による表示制御**：ログインユーザーのみがアクセス可能です。各ユーザーは自分の個人名前空間の使用量のみ確認できます。有料機能のタブ（CI/CD分数、Pagesなど）は環境や契約状況により表示が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | プロジェクト統計 | 主機能 | 個人使用量の表示 |

## 画面種別

一覧画面（Vue.jsによるSPA）

## URL/ルーティング

| メソッド | パス | アクション |
|----------|------|-----------|
| GET | /-/profile/usage_quotas | index |

```ruby
# config/routes/profile.rb (line 74)
resources :usage_quotas, only: [:index]
```

## 入出力項目

### 入力項目

この画面には入力項目はありません（表示専用）。

### 出力項目

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| 名前空間ID | @namespace.id | ユーザー名前空間のID |
| 名前空間パス | @namespace.full_path | ユーザー名前空間のフルパス |
| ユーザー名前空間フラグ | @namespace.user_namespace? | ユーザー名前空間かどうか |
| ストレージ使用量 | storage_usage_app_data | ストレージ使用量データ |

## 表示項目

### ストレージタブ

| 項目名 | 説明 |
|--------|------|
| 総ストレージ使用量 | 名前空間全体のストレージ使用量 |
| プロジェクト別使用量 | 各プロジェクトのストレージ使用量内訳 |
| リポジトリサイズ | Gitリポジトリのサイズ |
| LFSオブジェクト | Git LFSオブジェクトのサイズ |
| アーティファクト | CI/CDアーティファクトのサイズ |
| パッケージ | パッケージレジストリのサイズ |
| Wiki | Wikiのサイズ |

### CI/CDタブ（有料機能）

| 項目名 | 説明 |
|--------|------|
| 使用分数 | 消費したCI/CD分数 |
| 残り分数 | 残りのCI/CD分数 |
| 制限 | CI/CD分数の制限値 |

## イベント仕様

### 1-画面読み込み時

画面読み込み時に以下の処理が実行されます：
1. 現在のユーザーの名前空間を取得
2. 検索設定を非表示に
3. Vue.jsアプリケーションをマウント
4. 使用量データを非同期で取得

### 2-タブ切り替え

タブをクリックすると：
1. 選択されたタブのコンテンツを表示
2. 必要に応じてAPIからデータを取得

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | namespaces | SELECT | 名前空間情報の取得 |
| 画面表示 | projects | SELECT | プロジェクト一覧の取得 |
| 画面表示 | project_statistics | SELECT | プロジェクト統計の取得 |

### テーブル別更新項目詳細

この画面での直接的なデータベース更新はありません（読み取り専用画面）。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG001 | 情報 | Usage quotas | 画面タイトル |
| MSG002 | 情報 | Usage of resources across your projects | サブタイトル |
| MSG003 | 情報 | Loading Usage quotas tabs | タブロード中 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | ログイン画面へリダイレクト |
| 名前空間が見つからない | 404エラー表示 |
| API取得エラー | エラーメッセージ表示 |

## 備考

- EE（Enterprise Edition）では追加のタブ（CI/CD分数、Pages）が表示されます
- `render_if_exists` を使用してEE固有の機能を条件付きでレンダリング
- `storage_usage_app_data` ヘルパーでVue.jsコンポーネントにデータを渡します
- 使用量の更新はバックグラウンドで定期的に行われます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | usage_quotas_controller.rb | `app/controllers/profiles/usage_quotas_controller.rb` | コントローラーの全体構造 |

**主要処理フロー**:
1. **行5**: `include OneTrustCSP` - CSPポリシーの設定
2. **行7**: `feature_category :consumables_cost_management`
3. **行8**: `urgency :low`
4. **行10-13**: `index` アクション - 名前空間の取得と設定

#### Step 2: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html.haml | `app/views/profiles/usage_quotas/index.html.haml` | 使用量クォータ画面のビュー |
| 2-2 | _index.html.haml | `app/views/shared/usage_quotas/_index.html.haml` | 共有パーシャル |

**主要処理フロー**:
- **行9**: `storage_usage_app_data(@namespace)` でVue.jsにデータを渡す
- **行12**: `shared/usage_quotas/index` パーシャルをレンダリング

#### Step 3: ヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | namespaces_helper.rb | `app/helpers/namespaces_helper.rb` | `storage_usage_app_data` ヘルパー |

**主要処理フロー**:
- **行95-102**: `storage_usage_app_data` - Vue.jsに渡すデータの生成

### プログラム呼び出し階層図

```
HTTP Request: GET /-/profile/usage_quotas
    |
    +-- Profiles::UsageQuotasController#index
           |
           +-- @hide_search_settings = true
           |
           +-- @namespace = current_user.namespace
           |
           +-- render index.html.haml
                  |
                  +-- content_for :usage_quotas_subtitle
                  |
                  +-- content_for :usage_quotas_alerts
                  |       +-- render_if_exists (EE)
                  |
                  +-- content_for :usage_quotas_tabs
                  |       |
                  |       +-- render_if_exists (EE: pipelines)
                  |       |
                  |       +-- #js-storage-usage-app
                  |       |       +-- storage_usage_app_data
                  |       |
                  |       +-- render_if_exists (EE: pages)
                  |
                  +-- render shared/usage_quotas/_index
```

### データフロー図

```
[入力]               [処理]                    [出力]

画面アクセス ───▶ UsageQuotasController ───▶ Vue.js表示
                       |
                       ▼
              current_user.namespace
                       |
                       ▼
              storage_usage_app_data
                       |
                       ▼
              ストレージ使用量表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| usage_quotas_controller.rb | `app/controllers/profiles/usage_quotas_controller.rb` | コントローラー | リクエスト処理 |
| index.html.haml | `app/views/profiles/usage_quotas/index.html.haml` | テンプレート | ビュー表示 |
| _index.html.haml | `app/views/shared/usage_quotas/_index.html.haml` | テンプレート | 共有パーシャル |
| namespaces_helper.rb | `app/helpers/namespaces_helper.rb` | ヘルパー | データ生成 |
| profile.rb | `config/routes/profile.rb` | ルーティング | URL定義 |
