# 画面設計書 216-利用規約

## 概要

本ドキュメントは、GitLabの利用規約承認画面の設計仕様を記載したものです。

### 本画面の処理概要

利用規約画面は、GitLabインスタンスの利用規約をユーザーに表示し、承認または拒否を求めるための画面です。

**業務上の目的・背景**：企業やサービス提供者は、法的要件やコンプライアンス上の理由から、ユーザーに利用規約への同意を求める必要があります。GitLabでは、管理者が利用規約を設定でき、ユーザーはサービスを利用する前に規約に同意する必要があります。この画面を通じて、ユーザーは利用規約の内容を確認し、承認または拒否の意思表示ができます。

**画面へのアクセス方法**：利用規約が設定されているインスタンスでログイン後、規約に未同意の場合に自動的にリダイレクトされます。URLは `/-/users/terms` です。

**主要な操作・処理内容**：
1. 利用規約の表示：Markdown形式で記述された利用規約を表示
2. 承認：利用規約に同意し、サービスの利用を継続
3. 拒否：利用規約に同意せず、サインアウト

**画面遷移**：ログイン後、利用規約への同意が必要な場合にリダイレクトされます。承認後は元のページ（またはダッシュボード）へリダイレクトされます。拒否時はサインアウトされ、トップページへ遷移します。

**権限による表示制御**：未ログイン状態でも表示可能ですが、承認・拒否のアクションはログインユーザーのみが実行できます。既に同意済みの場合は、その旨のメッセージが表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 76 | ユーザー登録 | 主機能 | 利用規約の承認 |

## 画面種別

確認・同意画面（Vue.jsによるSPA）

## URL/ルーティング

| メソッド | パス | アクション |
|----------|------|-----------|
| GET | /-/users/terms | index |
| POST | /-/users/terms/:id/accept | accept |
| POST | /-/users/terms/:id/decline | decline |

```ruby
# config/routes/user.rb (lines 81-86)
scope '-/users', module: :users do
  resources :terms, only: [:index] do
    post :accept, on: :member
    post :decline, on: :member
  end
end
```

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 利用規約ID | id | integer | ○ | 承認/拒否時に指定する規約ID |
| リダイレクト先 | redirect | string | - | 承認後のリダイレクト先URL |

### 出力項目

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| 利用規約本文 | @term.terms | Markdown形式の利用規約 |
| 承認可否 | can?(:accept_terms) | 承認ボタンの表示可否 |
| 拒否可否 | can?(:decline_terms) | 拒否ボタンの表示可否 |
| 承認パス | accept_term_path | 承認アクションのURL |
| 拒否パス | decline_term_path | 拒否アクションのURL |

## イベント仕様

### 1-画面読み込み時

画面読み込み時に以下の処理が実行されます：
1. 最新の利用規約を取得
2. 規約が存在しない場合はリダイレクト
3. ユーザーが既に同意済みかチェック
4. 同意済みの場合はフラッシュメッセージを表示
5. Vue.jsコンポーネントへデータを渡す

### 2-承認ボタン押下

承認ボタンを押下すると：
1. `Users::RespondToTermsService` で同意を記録
2. 成功時は指定されたリダイレクト先へ遷移
3. 失敗時はエラーメッセージを表示して画面に戻る

### 3-拒否ボタン押下

拒否ボタンを押下すると：
1. `Users::RespondToTermsService` で拒否を記録
2. 成功時はサインアウトしてトップページへ遷移
3. 失敗時はエラーメッセージを表示して画面に戻る

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 承認 | term_agreements | INSERT | 同意記録の作成 |
| 承認 | users | UPDATE | accepted_term_id の更新 |
| 拒否 | term_agreements | INSERT | 拒否記録の作成 |

### テーブル別更新項目詳細

#### term_agreements

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | user_id | current_user.id | ユーザーID |
| INSERT | term_id | @term.id | 利用規約ID |
| INSERT | accepted | true/false | 承認/拒否 |
| INSERT | created_at | 現在時刻 | 作成日時 |

#### users（承認時のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | accepted_term_id | @term.id | 承認した規約ID |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG001 | 情報 | You have already accepted the Terms of Service as @username | 同意済みの場合 |
| MSG002 | エラー | {バリデーションエラー} | 同意記録の保存失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 利用規約が未設定 | リダイレクト先へ遷移 |
| 規約IDが見つからない | 404エラー |
| 同意記録の保存失敗 | エラーメッセージ表示 |

## 備考

- 複数の`skip_before_action`で通常のチェックをバイパス
  - `enforce_terms!`: 規約強制チェックをスキップ
  - `check_password_expiration`: パスワード期限チェックをスキップ
  - `check_two_factor_requirement`: 2FA要求チェックをスキップ
  - `require_email`: メール確認要求をスキップ
- レイアウトは専用の `terms` レイアウトを使用
- OneTrust CSPとの連携対応
- プロジェクトボットは自動的に承認済みとして扱われる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | term.rb | `app/models/application_setting/term.rb` | Termモデルの構造 |

**読解のコツ**: `ApplicationSetting::Term` は利用規約を管理するモデルです。`cache_markdown_field :terms` でMarkdownのキャッシュを行います。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | terms_controller.rb | `app/controllers/users/terms_controller.rb` | コントローラーの全体構造 |

**主要処理フロー**:
1. **行8-13**: 複数の `skip_before_action` で通常チェックをバイパス
2. **行14**: `before_action :terms` で最新規約を取得
3. **行20-26**: `index` アクション - 規約表示
4. **行28-38**: `accept` アクション - 承認処理
5. **行40-51**: `decline` アクション - 拒否処理
6. **行59-61**: `terms` メソッド - 最新規約取得

#### Step 3: ビューとヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/users/terms/index.html.haml` | ビューテンプレート |
| 3-2 | terms_helper.rb | `app/helpers/terms_helper.rb` | ヘルパーメソッド |

**主要処理フロー**:
- **行7**: `#js-terms-of-service` にVue.jsコンポーネントをマウント
- `terms_data` ヘルパーで規約データとパスをJSONで渡す

#### Step 4: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | respond_to_terms_service.rb | `app/services/users/respond_to_terms_service.rb` | 承認/拒否サービス |

### プログラム呼び出し階層図

```
HTTP Request: GET /-/users/terms
    |
    +-- Users::TermsController#index
           |
           +-- skip_before_action (複数)
           |
           +-- before_action :terms
           |       +-- Gitlab::CurrentSettings.latest_terms
           |
           +-- @term.accepted_by_user?(current_user)
           |
           +-- render index.html.haml
                  |
                  +-- terms_data(@term, @redirect)
                         |
                         +-- Vue.js Application Mount

HTTP Request: POST /-/users/terms/:id/accept
    |
    +-- Users::TermsController#accept
           |
           +-- Users::RespondToTermsService.new(...).execute(accepted: true)
           |       |
           |       +-- term_agreements INSERT
           |       |
           |       +-- users UPDATE (accepted_term_id)
           |
           +-- redirect_to redirect_path
```

### データフロー図

```
[入力]               [処理]                    [出力]

画面アクセス ───▶ TermsController#index ───▶ Vue.js表示
                       |
                       ▼
              latest_terms 取得
                       |
                       ▼
              accepted_by_user? チェック
                       |
                       ▼
              terms_data 生成 ───▶ 規約表示

承認/拒否 ───▶ RespondToTermsService ───▶ リダイレクト
                       |
                       ▼
              term_agreements INSERT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| terms_controller.rb | `app/controllers/users/terms_controller.rb` | コントローラー | リクエスト処理 |
| index.html.haml | `app/views/users/terms/index.html.haml` | テンプレート | ビュー表示 |
| terms_helper.rb | `app/helpers/terms_helper.rb` | ヘルパー | データ生成 |
| term.rb | `app/models/application_setting/term.rb` | モデル | データモデル |
| user.rb | `config/routes/user.rb` | ルーティング | URL定義 |
| respond_to_terms_service.rb | `app/services/users/respond_to_terms_service.rb` | サービス | 承認/拒否ロジック |
