# 画面設計書 217-通知停止

## 概要

本ドキュメントは、GitLabのメール通知停止確認画面の設計仕様を記載したものです。

### 本画面の処理概要

通知停止画面は、管理者からのメール通知を停止するための確認画面です。ユーザーがメール内のリンクをクリックすることでアクセスし、通知の購読解除を行います。

**業務上の目的・背景**：管理者は全ユーザーに対してメール通知を送信できますが、ユーザーによってはこれらの通知が不要な場合があります。この画面を通じて、ユーザーは管理者からのメール通知を停止できます。これは GDPR などのプライバシー規制への対応およびユーザー体験向上のために提供される機能です。

**画面へのアクセス方法**：管理者から送信されたメール内の「購読解除」リンクをクリックしてアクセスします。URLは `/unsubscribes/:email`（Base64エンコード済み）の形式です。

**主要な操作・処理内容**：
1. 解除対象メールアドレスの表示：どのメールアドレスの通知を停止するかを確認
2. 購読解除の実行：「Unsubscribe」ボタンで通知停止を実行

**画面遷移**：メール内のリンクから遷移します。購読解除完了後はログイン画面へリダイレクトされ、完了メッセージが表示されます。

**権限による表示制御**：認証不要でアクセス可能です。メールアドレスがURLパラメータ（Base64エンコード）として含まれており、そのアドレスに対して処理が行われます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 83 | 通知設定 | 主機能 | メール通知の停止確認 |

## 画面種別

確認画面

## URL/ルーティング

| メソッド | パス | アクション |
|----------|------|-----------|
| GET | /unsubscribes/:email | show |
| POST | /unsubscribes/:email | create |

```ruby
# config/routes/user.rb (lines 3-4)
get  'unsubscribes/:email', to: 'users/unsubscribes#show', as: :unsubscribe
post 'unsubscribes/:email', to: 'users/unsubscribes#create'
```

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| メールアドレス | email | string | ○ | Base64 URLセーフエンコードされたメールアドレス |

### 出力項目

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| 解除対象メールアドレス | @email | デコードされたメールアドレス |
| 確認メッセージ | 固定値 | 購読解除の確認文 |

## イベント仕様

### 1-画面読み込み時

画面読み込み時に以下の処理が実行されます：
1. URLパラメータからメールアドレスを取得（Base64デコード）
2. 該当メールアドレスのユーザーを検索
3. 確認画面を表示

### 2-Unsubscribeボタン押下

Unsubscribeボタンを押下すると：
1. ユーザーの `admin_email_unsubscribed_at` を更新
2. 購読解除完了通知メールを送信
3. ログイン画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 購読解除 | users | UPDATE | admin_email_unsubscribed_at の更新 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | admin_email_unsubscribed_at | 現在時刻 | 購読解除日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG001 | 情報 | Unsubscribe from Admin notifications | ページタイトル |
| MSG002 | 情報 | Yes, I want to unsubscribe {email} from any further admin emails. | 確認文 |
| MSG003 | 成功 | You have been unsubscribed | 購読解除完了時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| メールアドレスが見つからない | ユーザーが見つからなくても正常完了として扱う |
| Base64デコードエラー | エラーページ表示 |

## 備考

- 認証不要でアクセス可能（`skip_before_action :authenticate_user!`）
- メールアドレスは URL セーフな Base64 でエンコード
- ユーザーが見つからない場合でもリダイレクトは正常に行われる（セキュリティ上、存在確認を漏らさない）
- 完了通知メールは `Notify.send_unsubscribed_notification` で非同期送信

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | unsubscribes_controller.rb | `app/controllers/users/unsubscribes_controller.rb` | コントローラーの全体構造 |

**主要処理フロー**:
1. **行5**: `skip_before_action :authenticate_user!` - 認証スキップ
2. **行9-11**: `show` アクション - 確認画面表示
3. **行13-21**: `create` アクション - 購読解除処理
4. **行27-30**: `get_user` - メールからユーザー検索

#### Step 2: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | show.html.haml | `app/views/users/unsubscribes/show.html.haml` | ビューテンプレート |

**主要処理フロー**:
- **行1**: ページタイトル設定
- **行4**: フォーム送信（メールアドレスをBase64エンコードして送信）
- **行6-7**: 確認文とメールアドレス表示
- **行9**: Unsubscribeボタン

### プログラム呼び出し階層図

```
HTTP Request: GET /unsubscribes/:email
    |
    +-- Users::UnsubscribesController#show
           |
           +-- skip_before_action :authenticate_user!
           |
           +-- get_user
           |       |
           |       +-- Base64.urlsafe_decode64(params[:email])
           |       |
           |       +-- User.find_by(email: @email)
           |
           +-- render show.html.haml

HTTP Request: POST /unsubscribes/:email
    |
    +-- Users::UnsubscribesController#create
           |
           +-- get_user
           |
           +-- @user.admin_unsubscribe! (if @user)
           |
           +-- Notify.send_unsubscribed_notification(@user.id).deliver_later
           |
           +-- redirect_to new_user_session_path
```

### データフロー図

```
[入力]               [処理]                    [出力]

メールリンク ───▶ UnsubscribesController ───▶ 確認画面
(Base64 email)         |
                       ▼
              Base64.urlsafe_decode64
                       |
                       ▼
              User.find_by(email:)
                       |
               ┌───────┴───────┐
               ▼               ▼
          ユーザーあり    ユーザーなし
               |               |
               ▼               ▼
       admin_unsubscribe!   (スキップ)
               |               |
               └───────┬───────┘
                       ▼
              redirect_to login ───▶ 完了メッセージ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| unsubscribes_controller.rb | `app/controllers/users/unsubscribes_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/users/unsubscribes/show.html.haml` | テンプレート | ビュー表示 |
| user.rb | `config/routes/user.rb` | ルーティング | URL定義 |
| notify.rb | `app/mailers/notify.rb` | メーラー | 完了通知メール送信 |
