# 画面設計書 218-カレンダー活動

## 概要

本ドキュメントは、GitLabのカレンダー活動詳細画面の設計仕様を記載したものです。

### 本画面の処理概要

カレンダー活動画面は、ユーザープロフィールの貢献カレンダーから特定の日付をクリックした際に、その日の活動詳細を表示するための画面です。

**業務上の目的・背景**：ユーザープロフィールには貢献カレンダー（コントリビューショングラフ）が表示され、各日のコミット数やイベント数が視覚的に確認できます。この画面は、特定の日付の詳細な活動内容（どのプロジェクトに何をしたか）を確認するために提供されます。開発者のアクティビティ追跡やチームの活動状況の把握に活用されます。

**画面へのアクセス方法**：ユーザープロフィールページの貢献カレンダーで特定の日付をクリックするとAjaxで読み込まれます。URLは `/users/:username/calendar_activities?date=YYYY-MM-DD` の形式です。

**主要な操作・処理内容**：
1. 指定日付の活動イベント一覧を表示
2. 各イベントの種類（コミット、イシュー、マージリクエストなど）に応じた詳細表示

**画面遷移**：ユーザープロフィールの貢献カレンダーからAjax経由でインライン表示されます。レイアウトなしで部分的なHTMLとして返却されます。

**権限による表示制御**：認証不要でアクセス可能ですが、プライベートな活動はプライバシー設定に基づいて表示制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 78 | ユーザー情報 | 主機能 | ユーザー活動の表示 |

## 画面種別

部分画面（レイアウトなし）

## URL/ルーティング

| メソッド | パス | アクション |
|----------|------|-----------|
| GET | /users/:username/calendar_activities | calendar_activities |

```ruby
# config/routes/user.rb (lines 96-98)
scope(path: 'users/:username', as: :user, controller: :users) do
  get :calendar
  get :calendar_activities
end
```

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ユーザー名 | username | string | ○ | 対象ユーザーのユーザー名（URLパラメータ） |
| 日付 | date | string | - | 表示する日付（YYYY-MM-DD形式、省略時は当日） |

### 出力項目

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| 貢献日付 | @calendar_date | 表示対象の日付 |
| イベント一覧 | @events | その日の活動イベントリスト |

## イベント仕様

### 1-画面読み込み時

画面読み込み時に以下の処理が実行されます：
1. URLパラメータから日付を取得（パースエラー時は当日）
2. `contributions_calendar.events_by_date` で該当日のイベントを取得
3. `Events::RenderService` でイベントをレンダリング可能な形式に変換
4. レイアウトなしでテンプレートをレンダリング

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| （なし） | - | - | 参照のみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG001 | 情報 | Contributions for {date} | 見出し |
| MSG002 | 情報 | No contributions were found | イベントが0件の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 日付のパースエラー | 当日（Date.today）を使用 |
| ユーザーが見つからない | 404エラー（親コントローラーで処理） |

## 備考

- 認証不要でアクセス可能（`skip_before_action :authenticate_user!`）
- `layout: false` でレイアウトなしのHTMLを返却
- イベントは作成日時でソートされて表示
- ユーザーのタイムゾーン設定が時刻表示に反映される
- プライベートコントリビューションの表示はプロフィール設定に依存

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | users_controller.rb | `app/controllers/users_controller.rb` | calendar_activitiesアクション |

**主要処理フロー**:
1. **行203-204**: 日付パラメータの取得とパースエラー処理
2. **行210**: `contributions_calendar.events_by_date` でイベント取得
3. **行211**: `Events::RenderService` でレンダリング準備
4. **行213**: `layout: false` でテンプレートレンダリング

#### Step 2: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | calendar_activities.html.haml | `app/views/users/calendar_activities.html.haml` | 活動一覧表示 |

**主要処理フロー**:
- **行1-2**: 日付見出しの表示
- **行4-5**: イベント一覧をパーシャルでレンダリング
- **行7-8**: イベントなしの場合のメッセージ

#### Step 3: イベント表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | _event.html.haml | `app/views/events/_event.html.haml` | イベント表示パーシャル |

**主要処理フロー**:
- 各イベントタイプに応じた表示分岐
- タイムゾーン対応の時刻表示
- プライベートコントリビューションの表示制御

### プログラム呼び出し階層図

```
HTTP Request: GET /users/:username/calendar_activities?date=2024-01-15
    |
    +-- UsersController#calendar_activities
           |
           +-- Date.parse(params[:date]) rescue Date.today
           |
           +-- contributions_calendar.events_by_date(@calendar_date)
           |       |
           |       +-- Event.where(author: @user, ...)
           |
           +-- Events::RenderService.new(current_user).execute(@events)
           |       |
           |       +-- event.present (EventPresenter)
           |
           +-- render 'calendar_activities', layout: false
                  |
                  +-- events/_event partial (for each event)
                         |
                         +-- events/event/wiki, push, note, etc.
```

### データフロー図

```
[入力]               [処理]                    [出力]

カレンダークリック ───▶ UsersController ───▶ HTML Fragment
(date parameter)          |
                          ▼
                   Date.parse(date)
                          |
                          ▼
               contributions_calendar
                          |
                          ▼
               events_by_date(date)
                          |
                          ▼
               Events::RenderService
                          |
                          ▼
               _event.html.haml ───▶ イベント一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| users_controller.rb | `app/controllers/users_controller.rb` | コントローラー | リクエスト処理 |
| calendar_activities.html.haml | `app/views/users/calendar_activities.html.haml` | テンプレート | ビュー表示 |
| _event.html.haml | `app/views/events/_event.html.haml` | パーシャル | イベント表示 |
| user.rb | `config/routes/user.rb` | ルーティング | URL定義 |
| render_service.rb | `app/services/events/render_service.rb` | サービス | イベントレンダリング |
| contributions_calendar.rb | `lib/gitlab/contributions_calendar.rb` | ライブラリ | 貢献カレンダーロジック |
