# 画面設計書 219-ダッシュボード

## 概要

本ドキュメントは、GitLabの管理者ダッシュボード画面の設計仕様を記載したものです。

### 本画面の処理概要

管理者ダッシュボード画面は、GitLabインスタンスの全体概要を管理者に提供する画面です。プロジェクト、ユーザー、グループの統計情報や、各種コンポーネントのバージョン情報、機能の有効/無効状態を一覧表示します。

**業務上の目的・背景**：GitLabインスタンスの管理者は、システムの状態を素早く把握する必要があります。このダッシュボードは、最新のプロジェクト・ユーザー・グループ、システムコンポーネントのバージョン、有効な機能などを一箇所で確認できる管理ハブとして機能します。

**画面へのアクセス方法**：管理者権限を持つユーザーがサイドバーの「Admin Area」をクリック、またはURL `/admin` に直接アクセスします。

**主要な操作・処理内容**：
1. インスタンス概要の表示：プロジェクト数、ユーザー数、グループ数
2. 最新エンティティの表示：最新10件のプロジェクト、ユーザー、グループ
3. 機能状態の表示：Sign up、LDAP、OmniAuthなどの有効/無効状態
4. コンポーネントバージョンの表示：GitLab、Shell、Workhorse、Ruby、Railsなど

**画面遷移**：管理エリアのルートページです。各セクションから詳細管理画面へ遷移できます。

**権限による表示制御**：管理者権限（`can_admin_all_resources?`）が必要です。一般ユーザーはアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 82 | 管理者機能 | 主機能 | システム全体の管理 |

## 画面種別

一覧・概要画面

## URL/ルーティング

| メソッド | パス | アクション |
|----------|------|-----------|
| GET | /admin | index |
| GET | /admin/dashboard/stats | stats |

```ruby
# config/routes/admin.rb (lines 245, 247)
get '/dashboard/stats', to: 'dashboard#stats'
root to: 'dashboard#index'
```

## 入出力項目

### 入力項目

なし（パラメータ不要）

### 出力項目

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| プロジェクト数 | @counts[Project] | 概算プロジェクト総数 |
| ユーザー数 | @counts[User] | 概算ユーザー総数 |
| グループ数 | @counts[Group] | 概算グループ総数 |
| 最新プロジェクト | @projects | 最新10件のプロジェクト |
| 最新ユーザー | @users | 最新10件のユーザー |
| 最新グループ | @groups | 最新グループ |
| システム通知 | @notices | データベースチェッカーの通知 |
| KASサーバー情報 | @kas_server_info | GitLab KASのバージョン情報 |
| Redisバージョン | @redis_versions | 接続中のRedisバージョン |

## イベント仕様

### 1-画面読み込み時

画面読み込み時に以下の処理が実行されます：
1. `Gitlab::Database::Count.approximate_counts` で概算カウント取得
2. 最新プロジェクト10件を取得（削除済み除外）
3. 最新ユーザー10件を取得
4. 最新グループ10件を取得
5. 外部データベースチェッカーの通知を取得
6. KAS有効時はサーバー情報を取得
7. Redisバージョンを取得

### 2-New project ボタン押下

新規プロジェクト作成画面へ遷移します。

### 3-New user ボタン押下

新規ユーザー作成画面（`/admin/users/new`）へ遷移します。

### 4-New group ボタン押下

新規グループ作成画面（`/admin/groups/new`）へ遷移します。

### 5-View latest projects ボタン押下

プロジェクト管理画面（`/admin/projects?sort=created_desc`）へ遷移します。

### 6-Users statistics ボタン押下

ユーザー統計画面（`/admin/dashboard/stats`）へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| （なし） | - | - | 参照のみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG001 | 情報 | Dashboard | ページタイトル |
| MSG002 | 情報 | Instance overview | セクション見出し |
| MSG003 | 情報 | Projects | プロジェクトセクション |
| MSG004 | 情報 | Total Users | ユーザーセクション |
| MSG005 | 情報 | Groups | グループセクション |
| MSG006 | 情報 | Features | 機能セクション |
| MSG007 | 情報 | Components | コンポーネントセクション |
| MSG008 | 警告 | @notices (動的) | システム通知 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 管理者権限なし | 403 Forbidden |
| KAS情報取得失敗 | 「Unknown」と表示、ツールチップでエラー説明 |

## 備考

- `authorize! :access_admin_area` で管理者権限をチェック
- `feature_category :not_owned` （オーナー未定義）
- `Gitlab::Database::Count.approximate_counts` で大規模インスタンスでも高速に概算カウント
- ライセンス情報（EE版）の表示に対応
- イベントトラッキング（`view_admin_dashboard_pageload`）が設定されている
- JiHu（中国版GitLab）への移行バナー表示に対応

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | dashboard_controller.rb | `app/controllers/admin/dashboard_controller.rb` | コントローラーの全体構造 |

**主要処理フロー**:
1. **行8**: `COUNTED_ITEMS` で集計対象を定義
2. **行12**: `authorize! :access_admin_area` で権限チェック
3. **行14-22**: `index` アクション
   - **行15**: 概算カウント取得
   - **行16**: 最新プロジェクト取得
   - **行17**: 最新ユーザー取得
   - **行18**: 最新グループ取得
   - **行19**: データベース通知取得
   - **行20**: KAS情報取得（有効時）
   - **行21**: Redisバージョン取得

#### Step 2: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html.haml | `app/views/admin/dashboard/index.html.haml` | ビューテンプレート |

**主要処理フロー**:
- **行1-2**: パンくず・ページタイトル設定
- **行4-9**: EE版バナー・コールアウト表示
- **行15-19**: システム通知表示
- **行28-30**: インスタンス概要見出し
- **行31-81**: プロジェクト・ユーザー・グループカード
- **行84-119**: 機能状態カード
- **行120-184**: コンポーネントバージョンカード

#### Step 3: ヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | components_helper.rb | `app/helpers/admin/components_helper.rb` | feature_entryヘルパー |

### プログラム呼び出し階層図

```
HTTP Request: GET /admin
    |
    +-- Admin::DashboardController#index
           |
           +-- authorize! :access_admin_area
           |
           +-- Gitlab::Database::Count.approximate_counts(COUNTED_ITEMS)
           |       |
           |       +-- 概算カウント（Project, User, Group）
           |
           +-- Project.order_id_desc.without_deleted.with_route.limit(10)
           |
           +-- User.order_id_desc.limit(10)
           |
           +-- Group.order_id_desc.with_route.limit(10)
           |
           +-- Gitlab::ConfigChecker::ExternalDatabaseChecker.check
           |
           +-- Gitlab::Kas::ServerInfo.new.present (if KAS enabled)
           |
           +-- Gitlab::Redis::ALL_CLASSES.map(&:version).uniq
           |
           +-- render index.html.haml
                  |
                  +-- Layouts::CrudComponent (Projects)
                  +-- Layouts::CrudComponent (Users)
                  +-- Layouts::CrudComponent (Groups)
                  +-- Layouts::CrudComponent (Features)
                  +-- Layouts::CrudComponent (Components)
```

### データフロー図

```
[入力]               [処理]                    [出力]

管理者アクセス ───▶ DashboardController ───▶ ダッシュボード表示
                          |
                          ▼
              approximate_counts
                          |
            ┌─────────────┼─────────────┐
            ▼             ▼             ▼
        Project         User         Group
      .limit(10)     .limit(10)    .limit(10)
            |             |             |
            └─────────────┼─────────────┘
                          ▼
              ExternalDatabaseChecker
                          |
                          ▼
              KAS ServerInfo (optional)
                          |
                          ▼
              Redis versions
                          |
                          ▼
              index.html.haml ───▶ 統計・一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dashboard_controller.rb | `app/controllers/admin/dashboard_controller.rb` | コントローラー | リクエスト処理 |
| index.html.haml | `app/views/admin/dashboard/index.html.haml` | テンプレート | ビュー表示 |
| components_helper.rb | `app/helpers/admin/components_helper.rb` | ヘルパー | feature_entryなど |
| count_helper.rb | `app/helpers/count_helper.rb` | ヘルパー | approximate_count_with_delimiters |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義 |
| crud_component.rb | `app/components/layouts/crud_component.rb` | コンポーネント | カードレイアウト |
