# 画面設計書 220-システム情報

## 概要

本ドキュメントは、GitLabのシステム情報画面の設計仕様を記載したものです。

### 本画面の処理概要

システム情報画面は、GitLabが稼働しているサーバーのハードウェアリソース情報を表示する管理者向け画面です。CPU、メモリ、ディスク使用量、システム起動時刻などの情報を提供します。

**業務上の目的・背景**：GitLabインスタンスの管理者は、システムのリソース状況を監視し、パフォーマンス問題やキャパシティ不足を早期に発見する必要があります。この画面は、サーバーの健全性をリアルタイムで確認するためのインターフェースを提供します。

**画面へのアクセス方法**：管理者権限を持つユーザーが管理エリアから「Admin Area」>「Monitoring」>「System Info」を選択、またはURL `/admin/system_info` に直接アクセスします。

**主要な操作・処理内容**：
1. CPU情報の表示：コア数
2. メモリ使用量の表示：使用中/総メモリとプログレスバー
3. システム起動時刻の表示：Railsアプリケーションの起動時刻
4. ディスク使用量の表示：各マウントポイントの使用量/総容量

**画面遷移**：管理エリアのMonitoringセクションから遷移します。参照専用画面のため、他画面への遷移機能はありません。

**権限による表示制御**：管理者権限（`read_admin_system_information`）が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 82 | 管理者機能 | 主機能 | システム監視 |

## 画面種別

情報表示画面

## URL/ルーティング

| メソッド | パス | アクション |
|----------|------|-----------|
| GET | /admin/system_info | show |

```ruby
# config/routes/admin.rb (line 133)
resource :system_info, controller: 'system_info', only: [:show]
```

## 入出力項目

### 入力項目

なし（パラメータ不要）

### 出力項目

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| CPUコア数 | @cpus.length | システムのCPUコア数 |
| メモリ使用量 | @memory.active_bytes | アクティブメモリ量 |
| メモリ総量 | @memory.total_bytes | 総メモリ量 |
| システム起動時刻 | Rails.application.config.booted_at | アプリケーション起動時刻 |
| ディスク一覧 | @disks | マウントポイントごとのディスク情報 |

## イベント仕様

### 1-画面読み込み時

画面読み込み時に以下の処理が実行されます：
1. `Vmstat.cpu` でCPU情報を取得（エラー時はnil）
2. `Vmstat.memory` でメモリ情報を取得（エラー時はnil）
3. `Sys::Filesystem.mounts` でマウントポイント一覧を取得
4. 各マウントポイントについて：
   - 除外オプション（nobrowse, read-only, ro）をチェック
   - 除外マウントタイプ（tmpfs, procなど）をチェック
   - `Sys::Filesystem.stat` でディスク使用量を取得
5. カード形式で情報を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| （なし） | - | - | 参照のみ（システム情報の読み取り） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG001 | 情報 | System information | ページタイトル |
| MSG002 | 情報 | CPU | CPUセクション |
| MSG003 | 情報 | {n} cores | CPUコア数 |
| MSG004 | 警告 | Unable to collect CPU information | CPU情報取得失敗 |
| MSG005 | 情報 | Memory usage | メモリセクション |
| MSG006 | 警告 | Unable to collect memory information | メモリ情報取得失敗 |
| MSG007 | 情報 | System started | 起動時刻セクション |
| MSG008 | 情報 | Disk usage | ディスクセクション |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| CPU情報取得失敗 | 「Unable to collect CPU information」と「0 cores」を表示 |
| メモリ情報取得失敗 | 「Unable to collect memory information」を表示 |
| ディスク情報取得失敗 | 該当マウントポイントをスキップ |
| 管理者権限なし | 403 Forbidden |

## 備考

- `authorize! :read_admin_system_information` で権限チェック
- `feature_category :not_owned` （オーナー未定義）
- `Vmstat` gemを使用してCPU・メモリ情報を取得
- `Sys::Filesystem` gemを使用してディスク情報を取得
- 除外マウントオプション: `nobrowse`, `read-only`, `ro`
- 除外マウントタイプ: `autofs`, `tmpfs`, `proc`, `sysfs`, `devfs`など多数
- イベントトラッキング（`view_admin_system_info_pageload`）が設定されている
- Pajamas CardComponentとProgressComponentを使用したUI

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | system_info_controller.rb | `app/controllers/admin/system_info_controller.rb` | コントローラーの全体構造 |

**主要処理フロー**:
1. **行4**: `feature_category :not_owned`
2. **行5**: `authorize! :read_admin_system_information`
3. **行7-11**: `EXCLUDED_MOUNT_OPTIONS` 定数定義
4. **行13-38**: `EXCLUDED_MOUNT_TYPES` 定数定義（仮想ファイルシステム等を除外）
5. **行40-71**: `show` アクション
   - **行41-45**: CPU情報取得（エラーハンドリング付き）
   - **行46-50**: メモリ情報取得（エラーハンドリング付き）
   - **行51**: マウントポイント一覧取得
   - **行53-70**: ディスク情報収集ループ

#### Step 2: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | show.html.haml | `app/views/admin/system_info/show.html.haml` | ビューテンプレート |

**主要処理フロー**:
- **行1-2**: ページタイトル設定
- **行4**: イベントトラッキング属性設定
- **行5-16**: CPUカード（コア数表示）
- **行18-30**: メモリカード（使用量とプログレスバー）
- **行32-37**: システム起動時刻カード
- **行39-53**: ディスクカード（各マウントポイント）

### プログラム呼び出し階層図

```
HTTP Request: GET /admin/system_info
    |
    +-- Admin::SystemInfoController#show
           |
           +-- authorize! :read_admin_system_information
           |
           +-- Vmstat.cpu
           |       |
           |       +-- @cpus (CPU情報配列) または nil (エラー時)
           |
           +-- Vmstat.memory
           |       |
           |       +-- @memory (メモリ情報) または nil (エラー時)
           |
           +-- Sys::Filesystem.mounts
           |       |
           |       +-- マウントポイント一覧
           |
           +-- (for each mount)
           |       |
           |       +-- EXCLUDED_MOUNT_OPTIONS チェック
           |       |
           |       +-- EXCLUDED_MOUNT_TYPES チェック
           |       |
           |       +-- Sys::Filesystem.stat(mount.mount_point)
           |               |
           |               +-- @disks への追加
           |
           +-- render show.html.haml
                  |
                  +-- Pajamas::CardComponent (CPU)
                  +-- Pajamas::CardComponent (Memory)
                  +-- Pajamas::ProgressComponent
                  +-- Pajamas::CardComponent (System started)
                  +-- Pajamas::CardComponent (Disk) × N
```

### データフロー図

```
[入力]               [処理]                    [出力]

管理者アクセス ───▶ SystemInfoController ───▶ システム情報表示
                          |
                          ▼
                    ┌─────┴─────┐
                    ▼           ▼
               Vmstat.cpu   Vmstat.memory
                    |           |
                    ▼           ▼
               @cpus       @memory
                    |           |
                    └─────┬─────┘
                          |
                          ▼
              Sys::Filesystem.mounts
                          |
                          ▼
              フィルタリング処理
              (除外オプション/タイプ)
                          |
                          ▼
              Sys::Filesystem.stat
                          |
                          ▼
                      @disks
                          |
                          ▼
              show.html.haml ───▶ カード表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| system_info_controller.rb | `app/controllers/admin/system_info_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/admin/system_info/show.html.haml` | テンプレート | ビュー表示 |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義 |
| card_component.rb | `app/components/pajamas/card_component.rb` | コンポーネント | カードUI |
| progress_component.rb | `app/components/pajamas/progress_component.rb` | コンポーネント | プログレスバーUI |
