# 画面設計書 221-ヘルスチェック画面

## 概要

本ドキュメントは、GitLab管理者エリアにおけるヘルスチェック画面の設計について記述する。

### 本画面の処理概要

本画面はGitLabインスタンスのヘルス状態を監視するための管理者向け画面である。システムの正常性確認、ヘルスチェックエンドポイントのURLとアクセストークンの表示、およびトークンのリセット機能を提供する。

**業務上の目的・背景**：GitLabインスタンスの運用において、システムの健全性を継続的に監視することは重要である。本画面により、管理者はシステムの現在の状態を即座に確認でき、外部監視ツールとの連携に必要なヘルスチェックエンドポイントの情報を取得できる。また、セキュリティ上の理由からアクセストークンのリセットが必要な場合に対応できる。

**画面へのアクセス方法**：管理者としてログイン後、Admin Area > Monitoring > Health checkからアクセスする。URLは`/admin/health_check`となる。

**主要な操作・処理内容**：
1. システムの現在のヘルス状態（Healthy/Unhealthy）の確認
2. ヘルスチェック用アクセストークンの確認
3. 各種ヘルスチェックエンドポイントURL（readiness、liveness、metrics）の確認
4. アクセストークンのリセット処理

**画面遷移**：管理者ダッシュボードからの遷移が主であり、本画面から他画面への直接遷移は基本的にない。ヘルプドキュメントへのリンクが提供されている。

**権限による表示制御**：管理者権限（admin_all_resources）を持つユーザーのみがトークン表示とリセット機能を利用できる。read_admin_health_check権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 143 | ヘルスチェック | 主機能 | ヘルスチェック画面の表示、システム状態の確認 |

## 画面種別

詳細・設定

## URL/ルーティング

| HTTP メソッド | URL | アクション | 説明 |
|--------------|-----|-----------|------|
| GET | /admin/health_check | show | ヘルスチェック画面表示 |
| PUT | /admin/application_settings/reset_health_check_token | reset_health_check_token | トークンリセット |

## 入出力項目

本画面は主に表示のみで、入力フィールドは存在しない。

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|----------|----|----|------|
| アクセストークン | 出力 | 文字列 | - | ヘルスチェックエンドポイントへのアクセスに使用するトークン |
| Readiness URL | 出力 | URL | - | /readiness エンドポイントのフルURL |
| Liveness URL | 出力 | URL | - | /liveness エンドポイントのフルURL |
| Metrics URL | 出力 | URL | - | /metrics エンドポイントのフルURL |
| 現在のステータス | 出力 | 文字列 | - | Healthy または Unhealthy |
| エラー詳細 | 出力 | 文字列 | - | Unhealthy時のエラー内容 |

## 表示項目

| セクション | 項目 | 説明 |
|-----------|------|------|
| アクセストークン | トークン値 | 読み取り専用テキストフィールドで表示 |
| アクセストークン | Reset tokenボタン | トークンリセット用ボタン |
| エンドポイント情報 | Readiness URL | トークン付きreadinessエンドポイントURL |
| エンドポイント情報 | Liveness URL | トークン付きlivenessエンドポイントURL |
| エンドポイント情報 | Metrics URL | トークン付きmetricsエンドポイントURL |
| Current status | ステータスアイコン | チェックマーク（正常）またはワーニング（異常） |
| Current status | ステータステキスト | Healthy または Unhealthy |
| Current status | エラー詳細 | Unhealthy時のみ表示 |

## イベント仕様

### 1-Reset tokenボタン押下

1. 確認ダイアログ「Are you sure you want to reset the health check token?」を表示
2. 確認後、PUTリクエストを`/admin/application_settings/reset_health_check_token`に送信
3. ApplicationSettings の health_check_access_token をリセット
4. 画面をリロードして新しいトークンを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | なし | SELECT | ヘルスチェック処理のみ実行 |
| トークンリセット | application_settings | UPDATE | health_check_access_token を新しい値に更新 |

### テーブル別更新項目詳細

#### application_settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | health_check_access_token | SecureRandom で生成された新しいトークン | トークンリセット時 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 情報 | No health problems detected | システムが正常な場合 |
| 確認 | Are you sure you want to reset the health check token? | トークンリセットボタン押下時 |

## 例外処理

| 状態 | 処理 |
|------|------|
| 権限不足 | 403エラー画面にリダイレクト |
| ヘルスチェック失敗 | Unhealthy状態を表示し、エラー詳細を @errors に格納して表示 |

## 備考

- ヘルスチェックは HealthCheck::Utils.process_checks(['standard']) で実行される
- 外部監視ツール（Prometheus等）との連携に使用されるエンドポイント情報が表示される
- アクセストークンはセキュリティ上重要なため、適切に管理する必要がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ヘルスチェック結果の構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | result.rb | `lib/gitlab/health_checks/result.rb` | ヘルスチェック結果を保持するデータ構造 |
| 1-2 | metric.rb | `lib/gitlab/health_checks/metric.rb` | メトリクス情報の構造 |

**読解のコツ**: HealthChecks::Result はチェック名、成功/失敗、エラーメッセージを保持する単純な構造体である。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | health_check_controller.rb | `app/controllers/admin/health_check_controller.rb` | showアクションでヘルスチェックを実行 |

**主要処理フロー**:
1. **行8-10**: showアクションでHealthCheck::Utils.process_checksを呼び出し
2. **行14-16**: checksメソッドで'standard'チェックを指定

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/admin/health_check/show.html.haml` | 画面レイアウトとトークン表示 |

**主要処理フロー**:
- **行8-14**: admin_all_resources権限チェックとトークン表示
- **行21-25**: 各エンドポイントURLの表示
- **行28-41**: ステータス表示（アイコン・テキスト・エラー詳細）

#### Step 4: ヘルスチェックロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | simple_abstract_check.rb | `lib/gitlab/health_checks/simple_abstract_check.rb` | ヘルスチェックの基本実装 |
| 4-2 | db_check.rb | `lib/gitlab/health_checks/db_check.rb` | データベースチェックの実装例 |
| 4-3 | gitaly_check.rb | `lib/gitlab/health_checks/gitaly_check.rb` | Gitalyチェックの実装例 |

### プログラム呼び出し階層図

```
Admin::HealthCheckController#show
    │
    ├─ HealthCheck::Utils.process_checks(['standard'])
    │      │
    │      └─ 各チェッククラス#readiness
    │             ├─ DbCheck
    │             ├─ GitalyCheck
    │             └─ RedisCheck 等
    │
    └─ view: show.html.haml
           ├─ Gitlab::CurrentSettings.health_check_access_token
           ├─ readiness_url / liveness_url / metrics_url
           └─ @errors（チェック結果）の表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

なし（画面表示） ───▶ HealthCheck::Utils      ───▶ @errors（エラー配列）
                     .process_checks
                           │
                           ▼
                     各チェック実行
                     (DB, Gitaly, Redis等)

ApplicationSettings ───▶ health_check_access_token ───▶ 画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| health_check_controller.rb | `app/controllers/admin/health_check_controller.rb` | コントローラ | リクエスト処理の起点 |
| show.html.haml | `app/views/admin/health_check/show.html.haml` | テンプレート | 画面表示 |
| simple_abstract_check.rb | `lib/gitlab/health_checks/simple_abstract_check.rb` | ライブラリ | チェック基底クラス |
| db_check.rb | `lib/gitlab/health_checks/db_check.rb` | ライブラリ | DBチェック実装 |
| gitaly_check.rb | `lib/gitlab/health_checks/gitaly_check.rb` | ライブラリ | Gitalyチェック実装 |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義（行122） |
