# 画面設計書 222-バックグラウンドジョブ

## 概要

本ドキュメントは、GitLab管理者エリアにおけるバックグラウンドジョブ管理画面の設計について記述する。

### 本画面の処理概要

本画面はGitLabのバックグラウンドジョブ処理エンジンであるSidekiqのダッシュボードを埋め込み表示する管理者向け画面である。Sidekiq Web UIをiframeで表示し、ジョブの監視・管理機能を提供する。

**業務上の目的・背景**：GitLabはバックグラウンドで多数の非同期ジョブを処理している。メール送信、Webhook配信、リポジトリのガベージコレクション、CI/CDパイプラインの処理など、多くの機能がSidekiqワーカーに依存している。管理者がこれらのジョブの状態を監視し、必要に応じて介入できる手段を提供することは運用上不可欠である。

**画面へのアクセス方法**：管理者としてログイン後、Admin Area > Monitoring > Background jobsからアクセスする。URLは`/admin/background_jobs`となる。

**主要な操作・処理内容**：
1. Sidekiqダッシュボードの表示（iframe経由）
2. キュー状態の確認
3. ワーカーの稼働状況確認
4. 失敗したジョブの確認・リトライ
5. スケジュールされたジョブの確認

**画面遷移**：管理者ダッシュボードからの遷移が主であり、本画面自体はSidekiq Web UIを埋め込み表示するラッパーである。

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能。Admin::ApplicationControllerを継承しているため、管理者権限チェックが自動的に適用される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 117 | バックグラウンドジョブ監視 | 主機能 | Sidekiqジョブの管理・監視 |

## 画面種別

ダッシュボード（iframe埋め込み）

## URL/ルーティング

| HTTP メソッド | URL | アクション | 説明 |
|--------------|-----|-----------|------|
| GET | /admin/background_jobs | show | バックグラウンドジョブ画面表示 |

## 入出力項目

本画面はSidekiq Web UIをiframeで埋め込み表示するため、GitLab側での入出力項目は存在しない。

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|----------|----|----|------|
| なし | - | - | - | Sidekiq Web UIに委譲 |

## 表示項目

| セクション | 項目 | 説明 |
|-----------|------|------|
| ヘッダー | ページタイトル | "Background jobs" |
| ヘッダー | 説明文 | SidekiqへのリンクとGitLabの使用説明 |
| メインコンテンツ | Sidekiq iframe | /sidekiq パスを埋め込み、幅100%、高さ970px |

## イベント仕様

### 1-画面読み込み

1. Admin::BackgroundJobsController#show が呼び出される
2. ビューテンプレートがレンダリングされる
3. iframe が /sidekiq パスを読み込む
4. Sidekiq Web UI が表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | なし | なし | GitLab側ではデータベース操作なし |

本画面自体はデータベース操作を行わない。Sidekiq Web UI内での操作（ジョブのリトライ、削除等）はRedisに対して行われる。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 説明 | GitLab uses Sidekiq to process background jobs | ページヘッダー説明文 |

## 例外処理

| 状態 | 処理 |
|------|------|
| 権限不足 | 403エラー画面にリダイレクト（Admin::ApplicationController による） |
| Sidekiqサービス停止 | iframeがエラーページを表示 |

## 備考

- Sidekiq Web UIは別途 `/sidekiq` パスでマウントされている
- iframe内の操作はSidekiq Web UIの仕様に従う
- Sidekiqの詳細な操作方法は [Sidekiq公式ドキュメント](https://sidekiq.org/) を参照
- feature_categoryは `not_owned` に設定されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コントローラを理解する

非常にシンプルなコントローラであることを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | background_jobs_controller.rb | `app/controllers/admin/background_jobs_controller.rb` | 継承関係とfeature_category設定のみ |

**読解のコツ**: このコントローラは実質的に何も処理を行わず、Admin::ApplicationControllerの認証・認可機能のみを利用している。

#### Step 2: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | show.html.haml | `app/views/admin/background_jobs/show.html.haml` | iframeでSidekiq UIを埋め込み |

**主要処理フロー**:
- **行1**: ページタイトル設定
- **行2-3**: Sidekiqへのリンク付き説明文
- **行9**: sidekiq_path を src として iframe を表示

#### Step 3: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | admin.rb | `config/routes/admin.rb` | background_jobsリソース定義 |

**主要処理フロー**:
- **行123**: `resource :background_jobs, controller: 'background_jobs', only: [:show]`

#### Step 4: Sidekiqマウント設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | routes.rb または sidekiq.rb | `config/` | Sidekiq Web UIのマウント設定 |

### プログラム呼び出し階層図

```
Admin::BackgroundJobsController#show
    │
    └─ view: show.html.haml
           │
           └─ iframe src="/sidekiq"
                  │
                  └─ Sidekiq::Web (Rackアプリケーション)
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト ───▶ BackgroundJobsController ───▶ HAMLテンプレート
                         │
                         ▼
                    Admin権限チェック
                         │
                         ▼
                    ビューレンダリング ───▶ iframe (Sidekiq UI)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| background_jobs_controller.rb | `app/controllers/admin/background_jobs_controller.rb` | コントローラ | リクエスト処理の起点 |
| show.html.haml | `app/views/admin/background_jobs/show.html.haml` | テンプレート | 画面表示・iframe埋め込み |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義（行123） |
| application_controller.rb | `app/controllers/admin/application_controller.rb` | コントローラ | 親クラス、認証・認可処理 |
