# 画面設計書 223-データベース診断画面

## 概要

本ドキュメントは、GitLab管理者エリアにおけるデータベース診断画面の設計について記述する。

### 本画面の処理概要

本画面はGitLabインスタンスのデータベースの健全性を診断するための管理者向け画面である。データベースの照合順序（Collation）チェックとスキーマ整合性チェックを実行し、問題を検出・報告する機能を提供する。

**業務上の目的・背景**：GitLabの運用において、データベースの整合性維持は極めて重要である。アップグレード後の問題検出、照合順序の不整合による検索・ソート問題の特定、スキーマの予期しない差異の発見など、データベース関連の問題を早期に発見することで、サービス品質の維持と障害の予防が可能となる。

**画面へのアクセス方法**：管理者としてログイン後、Admin Area > Monitoring > Database diagnosticsからアクセスする。URLは`/admin/database_diagnostics`となる。

**主要な操作・処理内容**：
1. 照合順序（Collation）チェックの実行
2. 照合順序チェック結果の確認
3. スキーマチェックの実行
4. スキーマチェック結果の確認

**画面遷移**：管理者ダッシュボードからの遷移が主であり、チェック実行はAPI経由で非同期処理される。

**権限による表示制御**：read_admin_database_diagnostics権限を持つ管理者のみがアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 143 | ヘルスチェック | 主機能 | データベース診断画面の表示、各種チェック実行 |

## 画面種別

診断・分析

## URL/ルーティング

| HTTP メソッド | URL | アクション | 説明 |
|--------------|-----|-----------|------|
| GET | /admin/database_diagnostics | index | データベース診断画面表示 |
| POST | /admin/database_diagnostics/run_collation_check | run_collation_check | 照合順序チェック開始 |
| GET | /admin/database_diagnostics/collation_check_results | collation_check_results | 照合順序チェック結果取得 |
| POST | /admin/database_diagnostics/run_schema_check | run_schema_check | スキーマチェック開始 |
| GET | /admin/database_diagnostics/schema_check_results | schema_check_results | スキーマチェック結果取得 |

## 入出力項目

本画面はVue.jsコンポーネント（`#js-database-diagnostics`）として実装され、APIを通じてチェックを実行する。

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|----------|----|----|------|
| run_collation_check_url | 出力 | URL | - | 照合順序チェック開始API URL |
| collation_check_results_url | 出力 | URL | - | 照合順序チェック結果取得API URL |
| run_schema_check_url | 出力 | URL | - | スキーマチェック開始API URL |
| schema_check_results_url | 出力 | URL | - | スキーマチェック結果取得API URL |

## 表示項目

| セクション | 項目 | 説明 |
|-----------|------|------|
| ヘッダー | タイトル | "Database diagnostics" |
| ヘッダー | 説明文 | "Detect and resolve database issues." |
| Vue.jsコンポーネント | 照合順序チェック | チェック実行ボタンと結果表示 |
| Vue.jsコンポーネント | スキーマチェック | チェック実行ボタンと結果表示 |

## イベント仕様

### 1-照合順序チェック実行

1. 「Run collation check」ボタンをクリック
2. POSTリクエストを`/admin/database_diagnostics/run_collation_check.json`に送信
3. Database::CollationCheckerWorkerがバックグラウンドジョブとしてスケジュールされる
4. レスポンスで`{ status: 'scheduled', job_id: xxx }`が返される
5. 定期的に`/admin/database_diagnostics/collation_check_results.json`をポーリング
6. 結果がキャッシュに格納されたら表示

### 2-スキーマチェック実行

1. 「Run schema check」ボタンをクリック
2. POSTリクエストを`/admin/database_diagnostics/run_schema_check.json`に送信
3. Database::SchemaCheckerWorkerがバックグラウンドジョブとしてスケジュールされる
4. レスポンスで`{ status: 'scheduled', job_id: xxx }`が返される
5. 定期的に`/admin/database_diagnostics/schema_check_results.json`をポーリング
6. 結果がキャッシュに格納されたら表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | なし | なし | 表示のみ |
| チェック実行 | なし | SELECT | 読み取りのみ（診断目的） |

本画面はデータベースの診断を行うものであり、データベースの更新は行わない。チェック結果はRedisキャッシュに格納される。

### キャッシュ操作詳細

| 操作 | キャッシュキー | 内容 | 備考 |
|-----|--------------|------|------|
| 照合順序チェック結果格納 | COLLATION_CHECK_CACHE_KEY | JSON形式のチェック結果 | CollationCheckerWorkerで設定 |
| スキーマチェック結果格納 | SCHEMA_CHECK_CACHE_KEY | JSON形式のチェック結果 | SchemaCheckerWorkerで設定 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 説明 | Detect and resolve database issues. | ページヘッダー |
| 成功 | { status: 'scheduled', job_id: xxx } | チェックスケジュール成功時（API） |
| エラー | { error: 'Failed to schedule job' } | ジョブスケジュール失敗時（API） |
| エラー | { error: 'No results available yet' } | 結果がまだ利用可能でない時（API） |

## 例外処理

| 状態 | 処理 |
|------|------|
| 権限不足 | 403エラー（read_admin_database_diagnostics権限が必要） |
| ジョブスケジュール失敗 | 500エラー、{ error: 'Failed to schedule job' }を返す |
| 結果未取得 | 404エラー、{ error: 'No results available yet' }を返す |

## 備考

- 診断チェックはバックグラウンドワーカー（Sidekiq）で非同期実行される
- チェック結果はRails.cacheに格納され、フロントエンドからポーリングで取得される
- feature_categoryは`database`に設定されている
- Vue.jsコンポーネントは`#js-database-diagnostics`要素にマウントされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コントローラを理解する

処理の起点となるコントローラを理解。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database_diagnostics_controller.rb | `app/controllers/admin/database_diagnostics_controller.rb` | 5つのアクション定義と権限設定 |

**主要処理フロー**:
- **行6-7**: read_admin_database_diagnostics権限チェック
- **行9-18**: WORKER_CONFIGS定数でワーカーとキャッシュキーを管理
- **行24-25**: run_collation_checkでCollationCheckerWorkerを起動
- **行27-29**: run_schema_checkでSchemaCheckerWorkerを起動
- **行32-38**: collation_check_resultsでキャッシュから結果取得
- **行40-42**: schema_check_resultsでキャッシュから結果取得

**読解のコツ**: run_checkとcheck_resultsはprivateメソッドで共通処理を抽象化している。

#### Step 2: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html.haml | `app/views/admin/database_diagnostics/index.html.haml` | Vue.jsコンポーネントのマウントポイント |

**主要処理フロー**:
- **行1**: ページタイトル設定
- **行10-16**: `#js-database-diagnostics`要素にAPI URLをdata属性で渡す

#### Step 3: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | admin.rb | `config/routes/admin.rb` | database_diagnosticsリソース定義 |

**主要処理フロー**:
- **行124-131**: リソース定義と各アクションのルーティング

#### Step 4: バックグラウンドワーカーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | collation_checker_worker.rb | `app/workers/database/collation_checker_worker.rb` | 照合順序チェックワーカー |
| 4-2 | schema_checker_worker.rb | `app/workers/database/schema_checker_worker.rb` | スキーマチェックワーカー |

### プログラム呼び出し階層図

```
Admin::DatabaseDiagnosticsController#index
    │
    └─ view: index.html.haml
           │
           └─ Vue.js: #js-database-diagnostics
                  │
                  ├─ POST run_collation_check
                  │      └─ Database::CollationCheckerWorker.perform_async
                  │             └─ Rails.cache.write(COLLATION_CHECK_CACHE_KEY)
                  │
                  ├─ GET collation_check_results
                  │      └─ Rails.cache.read(COLLATION_CHECK_CACHE_KEY)
                  │
                  ├─ POST run_schema_check
                  │      └─ Database::SchemaCheckerWorker.perform_async
                  │             └─ Rails.cache.write(SCHEMA_CHECK_CACHE_KEY)
                  │
                  └─ GET schema_check_results
                         └─ Rails.cache.read(SCHEMA_CHECK_CACHE_KEY)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ボタンクリック ───▶ run_*_check API        ───▶ { status: 'scheduled' }
                         │
                         ▼
                   Sidekiqワーカー
                         │
                         ▼
                   診断実行 & キャッシュ保存
                         │
                         ▼
ポーリング ───────▶ *_check_results API    ───▶ 診断結果JSON
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| database_diagnostics_controller.rb | `app/controllers/admin/database_diagnostics_controller.rb` | コントローラ | APIエンドポイント |
| index.html.haml | `app/views/admin/database_diagnostics/index.html.haml` | テンプレート | Vue.jsマウントポイント |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義（行124-131） |
| collation_checker_worker.rb | `app/workers/database/collation_checker_worker.rb` | ワーカー | 照合順序チェック実行 |
| schema_checker_worker.rb | `app/workers/database/schema_checker_worker.rb` | ワーカー | スキーマチェック実行 |
