# 画面設計書 224-ユーザー一覧

## 概要

本ドキュメントは、GitLab管理者エリアにおけるユーザー一覧画面の設計について記述する。

### 本画面の処理概要

本画面はGitLabインスタンスに登録されている全ユーザーを管理するための管理者向け一覧画面である。ユーザーの検索・フィルタリング、一覧表示、新規ユーザー作成への遷移、個別ユーザー詳細への遷移などの機能を提供する。

**業務上の目的・背景**：GitLabインスタンスの運用において、ユーザーアカウントの管理は重要な業務である。管理者は、ユーザーの状態確認、アカウントの承認・ブロック、権限の確認などを効率的に行う必要がある。本画面はこれらの業務を支援するための中心的なインターフェースとなる。

**画面へのアクセス方法**：管理者としてログイン後、Admin Area > Overview > Usersからアクセスする。URLは`/admin/users`となる。

**主要な操作・処理内容**：
1. ユーザー一覧の表示（ページネーション付き）
2. ユーザーの検索（名前、ユーザー名、メールアドレス）
3. フィルタリング（状態別：Active、Blocked、Banned等）
4. ソート（名前、作成日、最終ログイン日等）
5. 新規ユーザー作成画面への遷移
6. 個別ユーザー詳細画面への遷移

**画面遷移**：
- 管理者ダッシュボードからの遷移
- 新規ユーザー作成画面（No.226）への遷移
- ユーザー詳細画面（No.225）への遷移
- コホート分析画面への遷移（タブ）

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能。admin_all_resources権限でメール送信、ユーザーエクスポート等の追加機能が表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 111 | ユーザー管理 | 主機能 | 管理者向けユーザー一覧の表示 |

## 画面種別

一覧

## URL/ルーティング

| HTTP メソッド | URL | アクション | 説明 |
|--------------|-----|-----------|------|
| GET | /admin/users | index | ユーザー一覧画面表示 |
| GET | /admin/users?filter=admins | index | 管理者フィルター |
| GET | /admin/users?filter=blocked | index | ブロック済みフィルター |
| GET | /admin/users?search_query=xxx | index | 検索クエリ適用 |

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|----------|----|----|------|
| search_query | 入力 | 文字列 | いいえ | 検索クエリ（名前、ユーザー名、メール） |
| filter | 入力 | 文字列 | いいえ | フィルター条件 |
| sort | 入力 | 文字列 | いいえ | ソート条件（デフォルト: name_asc） |
| page | 入力 | 整数 | いいえ | ページ番号 |

## 表示項目

| セクション | 項目 | 説明 |
|-----------|------|------|
| ヘッダー | タイトル | "Users" |
| ヘッダー | New userボタン | 新規ユーザー作成画面へのリンク |
| 統計カード | ユーザー統計 | Active、Banned、Blocked等の件数 |
| タブ | Users | ユーザー一覧タブ |
| タブ | Cohorts | コホート分析タブ |
| フィルター | 検索ボックス | ユーザー検索フィールド |
| フィルター | ソート選択 | ソート条件のドロップダウン |
| 一覧 | ユーザーリスト | Vue.jsコンポーネントで表示 |
| ページネーション | ページリンク | ページ切り替え |

## イベント仕様

### 1-検索実行

1. 検索ボックスにクエリを入力
2. Enterキーまたは検索実行
3. 検索クエリをパラメータとしてGETリクエスト送信
4. User.search()メソッドで検索実行
5. 結果を一覧に表示

### 2-フィルター適用

1. フィルター条件を選択
2. filterパラメータ付きでGETリクエスト送信
3. User.filter_items()メソッドでフィルタリング
4. 結果を一覧に表示

### 3-新規ユーザー作成

1. "New user"ボタンをクリック
2. /admin/users/new にリダイレクト

### 4-ユーザー詳細表示

1. 一覧のユーザー行をクリック
2. /admin/users/:id にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | users | SELECT | ユーザー一覧取得 |
| 一覧表示 | identities | SELECT | ユーザーのアイデンティティ取得（関連読み込み） |
| 検索 | users | SELECT | 検索条件でのユーザー取得 |

### テーブル別更新項目詳細

本画面は参照のみで、データベース更新は行わない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 情報 | RegistrationFeatures|send emails to users | 登録機能プロモーション表示時 |

## 例外処理

| 状態 | 処理 |
|------|------|
| 権限不足 | 403エラー画面にリダイレクト |
| ページ番号不正 | 最初のページを表示 |

## 備考

- 大規模インスタンス（ユーザー数1000以上）では、パフォーマンス最適化のためにpaginate_without_count?がtrueになり、総件数表示が省略される
- Vue.jsコンポーネント（#js-admin-users-app、#js-admin-users-filter-app）でインタラクティブな一覧を表示
- feature_categoryは`user_management`に設定されている
- 検索はSelf-managed環境では部分一致メール検索が有効

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | Userモデルのスコープ、検索、フィルター機能 |

**読解のコツ**: User.filter_items()、User.search()メソッドの実装を確認。scope定義を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | users_controller.rb | `app/controllers/admin/users_controller.rb` | indexアクションの処理フロー |

**主要処理フロー**:
1. **行16-17**: cohortタブへのリダイレクト処理
2. **行19**: filter_usersで基本フィルタリング
3. **行21-24**: search_queryによる検索（プライベートメール含む）
4. **行27-28**: ソート処理
5. **行29-30**: ページネーション
6. **行31**: paginate_without_count?による最適化

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/admin/users/index.html.haml` | ページ構成とコンポーネント配置 |
| 3-2 | _tabs.html.haml | `app/views/admin/users/_tabs.html.haml` | タブナビゲーション |
| 3-3 | _users.html.haml | `app/views/admin/users/_users.html.haml` | ユーザー一覧パーシャル |

**主要処理フロー**:
- **index.html.haml 行3-9**: ヘッダーと新規作成ボタン
- **index.html.haml 行11-12**: タブとユーザー一覧パーシャル
- **_users.html.haml 行11**: フィルターVue.jsコンポーネント
- **_users.html.haml 行15**: ユーザー一覧Vue.jsコンポーネント

#### Step 4: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | admin.rb | `config/routes/admin.rb` | usersリソース定義 |

**主要処理フロー**:
- **行4-33**: usersリソースと各種memberアクション

### プログラム呼び出し階層図

```
Admin::UsersController#index
    │
    ├─ User.filter_items(params[:filter])
    │
    ├─ User.search(params[:search_query])
    │      └─ PostgreSQL ILIKE / Elasticsearch
    │
    ├─ @users.sort_by_attribute(@sort)
    │
    ├─ @users.page(params[:page])
    │
    └─ view: index.html.haml
           │
           ├─ partial: _tabs.html.haml
           │
           └─ partial: _users.html.haml
                  │
                  ├─ Vue: #js-admin-users-filter-app
                  │
                  └─ Vue: #js-admin-users-app
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ UsersController#index ───▶ @users（ユーザー配列）
  │                      │
  │ filter               ├─ filter_items
  │ search_query         ├─ search
  │ sort                 ├─ sort_by_attribute
  │ page                 └─ page
                               │
                               ▼
                         HAMLテンプレート
                               │
                               ▼
                         Vue.jsコンポーネント
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| users_controller.rb | `app/controllers/admin/users_controller.rb` | コントローラ | indexアクション（行16-32） |
| index.html.haml | `app/views/admin/users/index.html.haml` | テンプレート | メインビュー |
| _tabs.html.haml | `app/views/admin/users/_tabs.html.haml` | パーシャル | タブナビゲーション |
| _users.html.haml | `app/views/admin/users/_users.html.haml` | パーシャル | ユーザー一覧 |
| user.rb | `app/models/user.rb` | モデル | ユーザーモデル |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義（行4-33） |
