# 画面設計書 225-ユーザー詳細

## 概要

本ドキュメントは、GitLab管理者エリアにおけるユーザー詳細画面の設計について記述する。

### 本画面の処理概要

本画面はGitLabインスタンスに登録されている個別ユーザーの詳細情報を表示し、各種管理操作を提供する管理者向け画面である。ユーザーの基本情報、アカウント情報、セキュリティ設定、権限情報などを表示し、ブロック、アクティベーション、2FA無効化、なりすまし等の管理操作を提供する。

**業務上の目的・背景**：管理者がユーザーアカウントの状態を詳細に確認し、必要に応じてアカウント管理操作を実行するための中心的な画面である。セキュリティインシデント対応、アカウントサポート、権限確認など、様々な運用業務で使用される。

**画面へのアクセス方法**：管理者としてログイン後、Admin Area > Overview > Users > ユーザー名をクリック、またはURLで`/admin/users/:username`に直接アクセスする。

**主要な操作・処理内容**：
1. ユーザー基本情報の表示（名前、ユーザー名、メール、ID等）
2. アカウント状態の表示（2FA、確認状態、サインイン履歴等）
3. ユーザーのブロック/アンブロック
4. ユーザーのバン/アンバン
5. ユーザーのアクティベート/デアクティベート
6. 2要素認証の無効化
7. ユーザーへのなりすまし（Impersonate）
8. メールの強制確認
9. アカウントのロック解除
10. ユーザー編集画面への遷移

**画面遷移**：
- ユーザー一覧画面（No.224）からの遷移
- ユーザー編集画面（No.227）への遷移
- アイデンティティ一覧画面（No.228）への遷移（タブ）
- プロジェクト一覧/グループ一覧への遷移（タブ）

**権限による表示制御**：管理者権限が必要。admin_all_resources権限で追加機能（2FA無効化、なりすまし等）が利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 111 | ユーザー管理 | 主機能 | 管理者向けユーザー詳細の表示・管理 |

## 画面種別

詳細

## URL/ルーティング

| HTTP メソッド | URL | アクション | 説明 |
|--------------|-----|-----------|------|
| GET | /admin/users/:id | show | ユーザー詳細画面表示 |
| PUT | /admin/users/:id/block | block | ユーザーブロック |
| PUT | /admin/users/:id/unblock | unblock | ユーザーアンブロック |
| PUT | /admin/users/:id/ban | ban | ユーザーバン |
| PUT | /admin/users/:id/unban | unban | ユーザーアンバン |
| PUT | /admin/users/:id/activate | activate | ユーザーアクティベート |
| PUT | /admin/users/:id/deactivate | deactivate | ユーザーデアクティベート |
| PUT | /admin/users/:id/unlock | unlock | アカウントロック解除 |
| PUT | /admin/users/:id/confirm | confirm | メール強制確認 |
| POST | /admin/users/:id/impersonate | impersonate | なりすまし開始 |
| PATCH | /admin/users/:id/disable_two_factor | disable_two_factor | 2FA無効化 |
| PUT | /admin/users/:id/trust | trust | ユーザーを信頼 |
| PUT | /admin/users/:id/untrust | untrust | ユーザー信頼解除 |
| PUT | /admin/users/:id/approve | approve | ユーザー承認 |
| DELETE | /admin/users/:id/reject | reject | ユーザー拒否 |

## 入出力項目

本画面は主に表示画面であり、入力フィールドは存在しない。

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|----------|----|----|------|
| id | 入力（URL） | 文字列 | はい | ユーザーID（ユーザー名） |

## 表示項目

| セクション | 項目 | 説明 |
|-----------|------|------|
| ヘッダー | ユーザー名 | ユーザーの表示名 |
| プロフィールカード | アバター | ユーザーアバター画像 |
| プロフィールカード | プロフィールページリンク | ユーザープロフィールへのリンク |
| アカウント情報 | Name | ユーザー名 |
| アカウント情報 | Username | ユーザー名（ログインID） |
| アカウント情報 | Email | メールアドレス（確認状態バッジ付き） |
| アカウント情報 | Secondary email | セカンダリメール一覧 |
| アカウント情報 | ID | ユーザーID |
| アカウント情報 | Namespace ID | 名前空間ID |
| アカウント情報 | Two-factor Authentication | 2FA状態（有効/無効） |
| アカウント情報 | Email OTP | Email OTP状態 |
| アカウント情報 | External User | 外部ユーザーフラグ |
| アカウント情報 | Can create top-level groups | グループ作成権限 |
| アカウント情報 | Private profile | プロフィール公開設定 |
| アカウント情報 | Personal projects limit | プロジェクト数上限 |
| アカウント情報 | Member since | 登録日 |
| アカウント情報 | Confirmed at | 確認日時 |
| サインイン情報 | Current sign-in IP | 現在のサインインIP |
| サインイン情報 | Current sign-in at | 現在のサインイン日時 |
| サインイン情報 | Last sign-in IP | 前回のサインインIP |
| サインイン情報 | Last sign-in at | 前回のサインイン日時 |
| サインイン情報 | Sign-in count | サインイン回数 |
| その他 | Highest role | 最高権限レベル |
| その他 | Support Pin | サポートPIN |
| 管理者メモ | Note | 管理者用メモ |

## イベント仕様

### 1-ユーザーブロック

1. "Block"ボタンをクリック
2. PUTリクエストを`/admin/users/:id/block`に送信
3. Users::BlockServiceを実行
4. 成功時：「Successfully blocked」メッセージを表示
5. ユーザー詳細画面にリダイレクト

### 2-2FA無効化

1. "Disable"ボタンをクリック
2. 確認ダイアログ「Are you sure?」を表示
3. PATCHリクエストを`/admin/users/:id/disable_two_factor`に送信
4. TwoFactor::DestroyServiceを実行
5. 成功時：「Two-factor authentication has been disabled for this user」メッセージを表示

### 3-なりすまし

1. "Impersonate"ボタンをクリック
2. impersonation_in_progress?とcan_impersonate_user権限を確認
3. セッションにimpersonator_idを保存
4. wardenでなりすましユーザーにセット
5. ログに記録
6. ルートページにリダイレクト、「You are now impersonating {username}」メッセージを表示

### 4-メール削除

1. セカンダリメール横の削除アイコンをクリック
2. 確認ダイアログを表示
3. DELETEリクエストを`/admin/users/:id/remove/:email_id`に送信
4. Emails::DestroyServiceを実行
5. 成功時：「Successfully removed email.」メッセージを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | users | SELECT | ユーザー情報取得 |
| 画面表示 | emails | SELECT | セカンダリメール取得 |
| 画面表示 | identities | SELECT | アイデンティティ取得 |
| ブロック | users | UPDATE | state を 'blocked' に更新 |
| アンブロック | users | UPDATE | state を 'active' に更新 |
| バン | users | UPDATE | state を 'banned' に更新 |
| 2FA無効化 | users | UPDATE | otp_required_for_login等をクリア |
| なりすまし | なし | なし | セッション操作のみ |
| メール削除 | emails | DELETE | メールレコード削除 |
| 確認 | users | UPDATE | confirmed_at を設定 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| ブロック | state | 'blocked' | Users::BlockService経由 |
| アンブロック | state | 'active' | Users::UnblockService経由 |
| バン | state | 'banned' | Users::BanService経由 |
| デアクティベート | state | 'deactivated' | Users::DeactivateService経由 |
| 2FA無効化 | otp_required_for_login | false | TwoFactor::DestroyService経由 |
| 確認 | confirmed_at | Time.current | force_confirm経由 |
| ロック解除 | locked_at | NULL | unlock_access!経由 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 成功 | Successfully blocked | ブロック成功時 |
| 成功 | Successfully unblocked | アンブロック成功時 |
| 成功 | Successfully banned | バン成功時 |
| 成功 | Successfully unbanned | アンバン成功時 |
| 成功 | Successfully activated | アクティベート成功時 |
| 成功 | Successfully deactivated | デアクティベート成功時 |
| 成功 | Successfully unlocked | ロック解除成功時 |
| 成功 | Successfully confirmed | 確認成功時 |
| 成功 | Two-factor authentication has been disabled for this user | 2FA無効化成功時 |
| 成功 | Successfully removed email. | メール削除成功時 |
| 情報 | You are now impersonating {username} | なりすまし開始時 |
| エラー | Error occurred. User was not blocked | ブロック失敗時 |
| 確認 | Are you sure? | 2FA無効化確認時 |
| 確認 | Are you sure you want to remove {email}? | メール削除確認時 |

## 例外処理

| 状態 | 処理 |
|------|------|
| 権限不足 | 403エラー画面にリダイレクト |
| ユーザー不存在 | 404エラー画面にリダイレクト |
| LDAPブロックユーザーのアンブロック | エラーメッセージ表示「This user cannot be unlocked manually from GitLab」 |
| なりすまし不可 | エラーメッセージ表示（impersonation_error_text） |

## 備考

- ユーザーの状態に応じて表示される操作ボタンが変化する
- LDAPユーザーは追加のアイデンティティ情報が表示される
- EE版では追加のフィールド（ライセンスシート使用状況等）が表示される
- プレースホルダーユーザーの場合、関連グループ情報が表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | Userモデルの属性、状態管理 |

**読解のコツ**: state属性の状態遷移（active、blocked、banned、deactivated）を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | users_controller.rb | `app/controllers/admin/users_controller.rb` | showアクションと各種管理アクション |

**主要処理フロー**:
- **行34**: showアクションは空（ビューレンダリングのみ）
- **行55-72**: impersonateアクション
- **行116-130**: blockアクション
- **行203-212**: disable_two_factorアクション
- **行357-359**: userヘルパーメソッド

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/admin/users/show.html.haml` | ユーザー詳細表示構造 |

**主要処理フロー**:
- **行1-5**: パンくずリスト、ページタイトル
- **行9-26**: プロフィールカード（左カラム）
- **行26-208**: アカウント情報カード

#### Step 4: サービスクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | block_service.rb | `app/services/users/block_service.rb` | ブロック処理 |
| 4-2 | unblock_service.rb | `app/services/users/unblock_service.rb` | アンブロック処理 |
| 4-3 | destroy_service.rb | `app/services/two_factor/destroy_service.rb` | 2FA無効化処理 |

### プログラム呼び出し階層図

```
Admin::UsersController#show
    │
    └─ view: show.html.haml
           │
           ├─ partial: _head.html.haml（タブナビ）
           ├─ partial: _profile.html.haml
           └─ アカウント情報表示

Admin::UsersController#block
    │
    └─ Users::BlockService#execute
           │
           └─ User#block!（state更新）

Admin::UsersController#impersonate
    │
    ├─ helpers.can_impersonate_user
    ├─ session[:impersonator_id] = current_user.id
    └─ warden.set_user(user)
```

### データフロー図

```
[入力]               [処理]                    [出力]

URL /:id ───────▶ UsersController#show ───▶ @user
                         │
                         └─ find_routable!(User)

操作ボタン ────────▶ 各アクション ───────────▶ サービスクラス
                         │                       │
                         │                       ▼
                         │                  状態更新
                         │                       │
                         └───────────────────────┘
                                  │
                                  ▼
                         リダイレクト + フラッシュ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| users_controller.rb | `app/controllers/admin/users_controller.rb` | コントローラ | 各種アクション定義 |
| show.html.haml | `app/views/admin/users/show.html.haml` | テンプレート | 詳細画面表示 |
| _head.html.haml | `app/views/admin/users/_head.html.haml` | パーシャル | タブナビゲーション |
| _profile.html.haml | `app/views/admin/users/_profile.html.haml` | パーシャル | プロフィールカード |
| user.rb | `app/models/user.rb` | モデル | ユーザーモデル |
| block_service.rb | `app/services/users/block_service.rb` | サービス | ブロック処理 |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義（行4-33） |
