# 画面設計書 226-ユーザー新規作成

## 概要

本ドキュメントは、GitLab管理者エリアにおけるユーザー新規作成画面の設計について記述する。

### 本画面の処理概要

本画面は管理者が新規ユーザーアカウントを作成するための画面である。ユーザーの基本情報、アクセス権限、プロフィール情報などを入力し、アカウントを作成する機能を提供する。

**業務上の目的・背景**：組織へのユーザー追加、サービスアカウントの作成、テスト用アカウントの作成など、管理者がユーザーを直接作成する必要がある場合に使用される。セルフサービス登録が無効な環境や、事前にアカウントを準備する必要がある場合に特に重要となる。

**画面へのアクセス方法**：管理者としてログイン後、Admin Area > Overview > Users > New userボタンをクリック、またはURLで`/admin/users/new`に直接アクセスする。

**主要な操作・処理内容**：
1. ユーザー基本情報の入力（名前、ユーザー名、メールアドレス）
2. アクセスレベルの設定（Regular、Admin等）
3. 外部ユーザーフラグの設定
4. グループ作成権限の設定
5. プロジェクト数制限の設定
6. プロフィール情報の入力（アバター、SNSリンク等）
7. ユーザー作成の実行

**画面遷移**：
- ユーザー一覧画面（No.224）からの遷移
- 作成成功時：ユーザー詳細画面（No.225）へリダイレクト
- キャンセル時：ユーザー一覧画面へ戻る

**権限による表示制御**：管理者権限（admin_all_resources）を持つユーザーのみがアクセス可能。組織フィールドは特定の条件下で表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 111 | ユーザー管理 | 主機能 | 管理者によるユーザー作成 |

## 画面種別

登録

## URL/ルーティング

| HTTP メソッド | URL | アクション | 説明 |
|--------------|-----|-----------|------|
| GET | /admin/users/new | new | ユーザー新規作成画面表示 |
| POST | /admin/users | create | ユーザー作成処理 |

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|----------|----|----|------|
| name | 入力 | 文字列 | はい | ユーザー名（表示名） |
| username | 入力 | 文字列 | はい | ユーザー名（ログインID） |
| email | 入力 | 文字列 | はい | メールアドレス |
| access_level | 入力 | 選択 | はい | アクセスレベル（Regular/Admin） |
| external | 入力 | チェックボックス | いいえ | 外部ユーザーフラグ |
| can_create_group | 入力 | チェックボックス | いいえ | グループ作成権限 |
| projects_limit | 入力 | 数値 | いいえ | プロジェクト数制限 |
| avatar | 入力 | ファイル | いいえ | アバター画像 |
| linkedin | 入力 | 文字列 | いいえ | LinkedInプロフィール |
| twitter | 入力 | 文字列 | いいえ | X（Twitter）プロフィール |
| website_url | 入力 | URL | いいえ | Webサイト |
| note | 入力 | テキスト | いいえ | 管理者メモ |

## 表示項目

| セクション | 項目 | 説明 |
|-----------|------|------|
| ヘッダー | タイトル | "New user" |
| Accountセクション | Name | ユーザー名入力フィールド |
| Accountセクション | Username | ユーザー名（ログインID）入力フィールド |
| Accountセクション | Email | メールアドレス入力フィールド |
| Passwordセクション | 説明 | パスワードリセットリンク送信についての説明 |
| Accessセクション | Access level | アクセスレベル選択 |
| Accessセクション | External user | 外部ユーザーチェックボックス |
| Accessセクション | Can create group | グループ作成権限チェックボックス |
| Accessセクション | Projects limit | プロジェクト数制限入力 |
| Organizationセクション | Organization | 組織選択（条件付き表示） |
| Profileセクション | Avatar | アバターファイル選択 |
| Profileセクション | LinkedIn | LinkedInプロフィール入力 |
| Profileセクション | X (formerly Twitter) | X（Twitter）プロフィール入力 |
| Profileセクション | Website URL | Webサイト入力 |
| Admin notesセクション | Note | 管理者メモ入力 |
| フッター | Create userボタン | 作成実行 |
| フッター | Cancelリンク | キャンセル |

## イベント仕様

### 1-Create userボタン押下

1. フォームをバリデーション
2. POSTリクエストを`/admin/users`に送信
3. Users::CreateServiceを実行
4. reset_password: true、skip_confirmation: trueオプションで作成
5. 成功時：ユーザー詳細画面にリダイレクト、「User was successfully created.」メッセージを表示
6. 失敗時：エラーを表示してフォームを再表示

### 2-Cancelリンク押下

1. ユーザー一覧画面（/admin/users）にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | なし | なし | 新規オブジェクト初期化のみ |
| ユーザー作成 | users | INSERT | 新規ユーザーレコード作成 |
| ユーザー作成 | namespaces | INSERT | ユーザー名前空間作成 |
| ユーザー作成 | emails | INSERT | プライマリメール作成 |
| ユーザー作成 | notification_settings | INSERT | 通知設定作成 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | username | フォーム入力値 | 必須、一意 |
| INSERT | email | フォーム入力値 | 必須、一意 |
| INSERT | admin | access_level == 'admin' | |
| INSERT | external | フォーム入力値 | |
| INSERT | can_create_group | フォーム入力値 | |
| INSERT | projects_limit | フォーム入力値 | |
| INSERT | organization_id | Current.organization.id または入力値 | |
| INSERT | confirmed_at | NULL（skip_confirmation: trueでも確認メール送信） | |
| INSERT | password | ランダム生成（reset_password: true） | |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 情報 | Reset link will be generated and sent to the user. User will be forced to set the password on first sign in. | パスワードセクション説明 |
| 成功 | User was successfully created. | 作成成功時 |
| エラー | バリデーションエラーメッセージ | 入力エラー時 |

## 例外処理

| 状態 | 処理 |
|------|------|
| 権限不足 | 403エラー画面にリダイレクト |
| バリデーションエラー | フォームを再表示し、エラーメッセージを表示 |
| ユーザー名重複 | 「Username has already been taken」エラー |
| メールアドレス重複 | 「Email has already been taken」エラー |

## 備考

- パスワードは自動生成され、ユーザーにパスワードリセットメールが送信される
- skip_confirmation: trueで即座にメール確認済みとなる
- 作成されたユーザーはパスワード設定が必須となる
- organization_idはデフォルトでCurrent.organization.idが使用される
- EE版では追加のフィールド（名前空間プラン、カスタム属性等）が表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | Userモデルのバリデーション、属性 |

**読解のコツ**: バリデーションルール（validates）、デフォルト値（attribute）を確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | users_controller.rb | `app/controllers/admin/users_controller.rb` | newアクション、createアクション |

**主要処理フロー**:
- **行47-49**: newアクションでUser.newを初期化
- **行214-237**: createアクション
  - **行215**: user_paramsにreset_password: true、skip_confirmation: trueを追加
  - **行216**: organization_idのデフォルト設定
  - **行218**: Users::CreateServiceを実行
  - **行221**: 成功時フック呼び出し
  - **行225**: 成功時リダイレクト
  - **行228-231**: 失敗時の処理

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/admin/users/new.html.haml` | フォームのレイアウト |
| 3-2 | _form.html.haml | `app/views/admin/users/_form.html.haml` | フォームフィールド定義 |
| 3-3 | _access.html.haml | `app/views/admin/users/_access.html.haml` | アクセス権限セクション |

**主要処理フロー**:
- **new.html.haml 行1**: ページタイトル設定
- **new.html.haml 行5-9**: 組織セクション（条件付き表示）
- **_form.html.haml 行11-22**: アカウント情報フィールド
- **_form.html.haml 行23-41**: パスワードセクション
- **_form.html.haml 行56-71**: プロフィールセクション
- **_form.html.haml 行77-84**: 送信ボタン

#### Step 4: サービスクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | create_service.rb | `app/services/users/create_service.rb` | ユーザー作成ロジック |

### プログラム呼び出し階層図

```
Admin::UsersController#new
    │
    └─ User.new
           │
           └─ view: new.html.haml
                  │
                  └─ partial: _form.html.haml
                         │
                         └─ partial: _access.html.haml

Admin::UsersController#create
    │
    ├─ user_params（パラメータ取得）
    │
    ├─ reset_password: true, skip_confirmation: true を追加
    │
    └─ Users::CreateService#execute
           │
           ├─ User.create
           │      ├─ users INSERT
           │      ├─ namespaces INSERT
           │      └─ emails INSERT
           │
           └─ パスワードリセットメール送信
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───────▶ UsersController#create ───▶ Users::CreateService
                         │                           │
                         │ user_params               ▼
                         │ reset_password: true   User.create
                         │ skip_confirmation: true   │
                         │                           ▼
                         │                      usersテーブル
                         │                           │
                         └───────────────────────────┘
                                  │
                                  ▼
                         リダイレクト（詳細画面）
                              + フラッシュ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| users_controller.rb | `app/controllers/admin/users_controller.rb` | コントローラ | new/createアクション |
| new.html.haml | `app/views/admin/users/new.html.haml` | テンプレート | 新規作成画面 |
| _form.html.haml | `app/views/admin/users/_form.html.haml` | パーシャル | フォームフィールド |
| _access.html.haml | `app/views/admin/users/_access.html.haml` | パーシャル | アクセス権限セクション |
| user.rb | `app/models/user.rb` | モデル | ユーザーモデル |
| create_service.rb | `app/services/users/create_service.rb` | サービス | 作成ロジック |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義 |
