# 画面設計書 228-アイデンティティ一覧

## 概要

本ドキュメントは、GitLab管理者エリアにおけるユーザーアイデンティティ一覧画面の設計について記述する。

### 本画面の処理概要

本画面は特定ユーザーに関連付けられた外部認証プロバイダのアイデンティティ（LDAP、SAML、OAuth等）を一覧表示する管理者向け画面である。アイデンティティの確認、編集、削除の機能を提供する。

**業務上の目的・背景**：GitLabは複数の外部認証プロバイダと連携することができる。ユーザーがLDAP、SAML、OAuth等で認証する際に、そのプロバイダとの連携情報がアイデンティティとして保存される。管理者がユーザーの認証状態を確認したり、不要なアイデンティティを削除したりする必要がある場合に本画面を使用する。

**画面へのアクセス方法**：管理者としてログイン後、Admin Area > Overview > Users > ユーザー詳細 > Identitiesタブをクリック、またはURLで`/admin/users/:user_id/identities`に直接アクセスする。

**主要な操作・処理内容**：
1. ユーザーのアイデンティティ一覧の表示
2. アイデンティティの詳細確認（プロバイダ、プロバイダID、識別子等）
3. アイデンティティの編集画面への遷移
4. アイデンティティの削除
5. 新規アイデンティティの追加（New identityボタン）

**画面遷移**：
- ユーザー詳細画面（No.225）のタブから遷移
- アイデンティティ編集画面（No.230）への遷移
- アイデンティティ新規作成画面（No.229）への遷移

**権限による表示制御**：管理者権限が必要。なりすまし可否によりImpersonateボタンの表示が制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 111 | ユーザー管理 | 主機能 | ユーザーアイデンティティの管理 |

## 画面種別

一覧

## URL/ルーティング

| HTTP メソッド | URL | アクション | 説明 |
|--------------|-----|-----------|------|
| GET | /admin/users/:user_id/identities | index | アイデンティティ一覧画面表示 |
| DELETE | /admin/users/:user_id/identities/:id | destroy | アイデンティティ削除 |

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|----------|----|----|------|
| user_id | 入力（URL） | 文字列 | はい | ユーザーID（ユーザー名） |

## 表示項目

| セクション | 項目 | 説明 |
|-----------|------|------|
| タブナビゲーション | Identitiesタブ | 現在のタブ（アクティブ） |
| テーブルヘッダー | Provider | プロバイダ名 |
| テーブルヘッダー | Provider ID | プロバイダID（SAML等で使用） |
| テーブルヘッダー | Group | グループ（SAML等で使用） |
| テーブルヘッダー | Identifier | 外部識別子（extern_uid） |
| テーブルヘッダー | Active | アクティブ状態 |
| テーブルヘッダー | Actions | 編集・削除アクション |
| テーブル行 | プロバイダ名 | ldap、saml、oauth等 |
| テーブル行 | プロバイダID | SAMLプロバイダID等 |
| テーブル行 | グループ | 関連グループ |
| テーブル行 | 識別子 | 外部システムでのユーザー識別子 |
| テーブル行 | アクティブ | Yes/No |
| テーブル行 | Editリンク | 編集画面へのリンク |
| テーブル行 | Deleteボタン | 削除ボタン |
| 空状態 | メッセージ | "This user has no identities"（アイデンティティがない場合） |

## イベント仕様

### 1-Edit押下

1. アイデンティティ編集画面（/admin/users/:user_id/identities/:id/edit）にリダイレクト

### 2-Delete押下

1. 確認ダイアログを表示
2. DELETEリクエストを`/admin/users/:user_id/identities/:id`に送信
3. Identity#destroyを実行
4. LDAPブロック状態の修復（Users::RepairLdapBlockedService）を実行
5. 成功時：「User identity was successfully removed.」メッセージを表示
6. 失敗時：「Failed to remove user identity.」メッセージを表示
7. アイデンティティ一覧画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | users | SELECT | ユーザー情報取得 |
| 画面表示 | identities | SELECT | アイデンティティ一覧取得 |
| 削除 | identities | DELETE | アイデンティティレコード削除 |
| 削除 | user_synced_attributes_metadata | DELETE | 同期メタデータ削除（条件付き） |

### テーブル別更新項目詳細

#### identities

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = :id | 対象アイデンティティを削除 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 成功 | User identity was successfully removed. | 削除成功時 |
| エラー | Failed to remove user identity. | 削除失敗時 |
| 情報 | This user has no identities | アイデンティティがない場合（空状態） |

## 例外処理

| 状態 | 処理 |
|------|------|
| 権限不足 | 403エラー画面にリダイレクト |
| ユーザー不存在 | 404エラー画面にリダイレクト |
| アイデンティティ不存在 | 404エラー画面にリダイレクト |

## 備考

- EE版ではSCIMアイデンティティも表示される（scim_identities_collection）
- アイデンティティ削除時、そのプロバイダと同期していた属性メタデータも削除される
- LDAPアイデンティティの場合、ブロック状態の修復処理が実行される
- feature_categoryは`system_access`に設定されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | identity.rb | `app/models/identity.rb` | Identityモデルの構造、バリデーション |

**読解のコツ**:
- provider、extern_uid、user_idの関係を理解
- ldap?メソッドでLDAPプロバイダかどうかを判定
- normalize_uidでLDAPの場合はDN正規化を行う

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | identities_controller.rb | `app/controllers/admin/identities_controller.rb` | indexアクション、destroyアクション |

**主要処理フロー**:
- **行24-33**: indexアクションでアイデンティティ一覧取得
- **行25**: @user.identitiesで関連アイデンティティ取得
- **行26-32**: can_impersonate等のヘルパー設定
- **行47-56**: destroyアクションでアイデンティティ削除
- **行49**: Users::RepairLdapBlockedServiceを実行

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/admin/identities/index.html.haml` | 一覧表示構造 |

**主要処理フロー**:
- **行1-4**: パンくずリスト、ページタイトル
- **行5**: ユーザーヘッダー（_head.html.haml）
- **行6-21**: 条件分岐（アイデンティティ有無）
- **行7-17**: テーブルヘッダーと行表示
- **行19-21**: 空状態（EmptyStateComponent）

#### Step 4: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | admin.rb | `config/routes/admin.rb` | identitiesリソース定義 |

**主要処理フロー**:
- **行6**: `resources :identities, except: [:show]`

### プログラム呼び出し階層図

```
Admin::IdentitiesController#index
    │
    ├─ user（ユーザー取得）
    │
    ├─ @identities = @user.identities
    │
    └─ view: index.html.haml
           │
           ├─ partial: _head.html.haml（タブナビ）
           │
           ├─ render_if_exists: _scim_identity（EE）
           │
           └─ render: @identities（_identity.html.hamlパーシャル）

Admin::IdentitiesController#destroy
    │
    ├─ identity.destroy
    │
    └─ Users::RepairLdapBlockedService#execute
           │
           └─ LDAPブロック状態の修復
```

### データフロー図

```
[入力]               [処理]                    [出力]

URL /:user_id ───▶ IdentitiesController#index ───▶ @user, @identities
                         │
                         └─ view: index.html.haml（一覧表示）

削除ボタン ────────▶ IdentitiesController#destroy ───▶ Identity#destroy
                         │                               │
                         │                               ▼
                         │                    identitiesテーブル DELETE
                         │                               │
                         └───────────────────────────────┘
                                  │
                                  ▼
                         RepairLdapBlockedService
                                  │
                                  ▼
                         リダイレクト + フラッシュ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| identities_controller.rb | `app/controllers/admin/identities_controller.rb` | コントローラ | index/destroyアクション |
| index.html.haml | `app/views/admin/identities/index.html.haml` | テンプレート | 一覧画面 |
| _identity.html.haml | `app/views/admin/identities/_identity.html.haml` | パーシャル | アイデンティティ行 |
| identity.rb | `app/models/identity.rb` | モデル | アイデンティティモデル |
| repair_ldap_blocked_service.rb | `app/services/users/repair_ldap_blocked_service.rb` | サービス | LDAPブロック修復 |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義（行6） |
