# 画面設計書 23-CI/CDカタログ

## 概要

本ドキュメントは、GitLabのCI/CDカタログ画面に関する設計書である。この画面は再利用可能なCI/CDコンポーネント（パイプラインテンプレート、ジョブ定義など）を探索・利用するためのカタログ機能を提供する。

### 本画面の処理概要

CI/CDカタログ画面は、GitLabで公開されている再利用可能なCI/CDコンポーネントを一覧・検索し、プロジェクトのパイプライン構築に活用できるリソースを発見するための機能を提供する。

**業務上の目的・背景**：CI/CDパイプラインの構築において、共通的に使用されるジョブやステップを再利用可能なコンポーネントとして公開・共有することで、開発効率の向上とベストプラクティスの標準化を実現する。CI/CDカタログはこれらのコンポーネントを集中管理し、発見可能にするための中央レジストリとして機能する。

**画面へのアクセス方法**：
- サイドバーの「Explore」メニューから「CI/CD Catalog」を選択
- 直接URL `/explore/catalog` にアクセス

**主要な操作・処理内容**：
1. カタログリソース一覧の表示 - 公開されているCI/CDコンポーネントの一覧表示
2. カタログリソースの検索 - キーワードによるコンポーネントの絞り込み
3. カタログリソース詳細への遷移 - コンポーネントを選択して詳細・使用方法を確認
4. 不正利用の報告 - 不適切なコンテンツの報告

**画面遷移**：
- 遷移元：ダッシュボード、サイドナビゲーション、ダイレクトURL
- 遷移先：カタログリソース詳細画面、不正利用報告画面

**権限による表示制御**：
- 未ログインユーザー：公開カタログリソースの閲覧が可能
- ログインユーザー：公開カタログリソースの閲覧、不正利用報告が可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | パイプライン実行 | 主機能 | CI/CDコンポーネントカタログの表示 |

## 画面種別

一覧

## URL/ルーティング

- URL: `/explore/catalog`
- 詳細URL: `/explore/catalog/*full_path`
- ルーティング: `config/routes/explore.rb`
  - `get '/' => 'catalog#index', as: :catalog_index`
  - `get '/*full_path' => 'catalog#show', as: :catalog`
- コントローラ: `Explore::CatalogController#index`, `Explore::CatalogController#show`

## 入出力項目

| 項目名 | 入力/出力 | 必須 | データ型 | 説明 |
|--------|----------|------|----------|------|
| full_path | 入力 | - | String | カタログリソースのフルパス（詳細表示時） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| リソース名 | String | カタログリソースの名前 |
| 説明 | Text | リソースの説明文 |
| プロジェクトパス | String | リソースが属するプロジェクトのパス |
| バージョン | String | 最新リリースバージョン |
| スター数 | Integer | プロジェクトへのスター数 |

## イベント仕様

### 1-ページ読み込み（index）

1. `Explore::CatalogController#index` が呼び出される
2. Vue.jsアプリケーション `#js-ci-cd-catalog` がマウントされる
3. フロントエンドからGraphQL APIでカタログリソースを取得
4. 一覧を表示

### 2-ページ読み込み（show）

1. `Explore::CatalogController#show` が呼び出される
2. `check_resource_access` でリソースの存在確認
3. `Ci::Catalog::Listing` を使用してカタログリソースを取得
4. リソースが存在しない場合は404を返却

### 3-カタログリソース選択

- 遷移先: `/explore/catalog/:full_path`
- 選択したリソースの詳細画面を表示

### 4-不正利用報告

- 遷移先: 報告フォーム（`add_category_abuse_reports_path`）
- 不適切なコンテンツを報告

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ読み込み | catalog_resources | SELECT | カタログリソース一覧の取得 |
| ページ読み込み | projects | SELECT | 関連プロジェクト情報の取得 |

### テーブル別更新項目詳細

#### catalog_resources

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | state = published | 公開済みリソースのみ |

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 | 表示条件 |
|------|------------|--------------|---------|
| エラー | 404 | Resource not found | リソースが存在しない場合 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| カタログリソースが存在しない場合 | 404エラーページを表示 |
| アクセス権限がない場合 | 404エラーページを表示 |

## 備考

- CI/CDカタログは主にVue.jsフロントエンドアプリケーションとして実装されている
- データ取得はGraphQL APIを通じて行われる
- 内部イベントトラッキング `unique_users_visiting_ci_catalog` が設定されている
- `show_ci_cd_catalog_analytics` フィーチャーフラグで分析機能を制御

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カタログリソースのデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalog_resource.rb | `app/models/ci/catalog/resource.rb` | カタログリソースモデルの構造 |
| 1-2 | listing.rb | `app/models/ci/catalog/listing.rb` | カタログリスティングのロジック |

**読解のコツ**: `Ci::Catalog::Listing#find_resource` メソッドでfull_pathからリソースを取得するロジックを確認する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | catalog_controller.rb | `app/controllers/explore/catalog_controller.rb` | コントローラのindex/showアクション |

**主要処理フロー**:
1. **14行目**: `show` アクションの定義（空のメソッドでビューをレンダリング）
2. **16-17行目**: `index` アクションで `show` ビューをレンダリング
3. **22-24行目**: `check_resource_access` - リソースアクセスの検証
4. **26-28行目**: `catalog_resource` - Listingを使用したリソース取得

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/explore/catalog/show.html.haml` | メインビュー（Vue.jsマウントポイント） |
| 3-2 | _ci_cd_catalog.html.haml | `app/views/explore/catalog/_ci_cd_catalog.html.haml` | Vue.jsアプリケーションのデータ設定 |

**主要処理フロー**:
- **1行目（show.html.haml）**: ページタイトル設定
- **3行目（show.html.haml）**: パーシャルでVue.jsアプリをレンダリング
- **3行目（_ci_cd_catalog.html.haml）**: `#js-ci-cd-catalog` 要素とdata属性の設定

#### Step 4: フロントエンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ci_cd_catalog.js | `app/assets/javascripts/ci/catalog/` | Vue.jsアプリケーション |
| 4-2 | GraphQLクエリ | `app/graphql/types/ci/catalog/` | カタログ関連のGraphQL型定義 |

### プログラム呼び出し階層図

```
Explore::CatalogController#index / #show
    │
    ├─ check_resource_access (show only)
    │      └─ catalog_resource
    │            └─ Ci::Catalog::Listing#find_resource
    │
    └─ render 'show'
           └─ _ci_cd_catalog.html.haml
                  └─ #js-ci-cd-catalog (Vue.js mount point)
                         └─ GraphQL API calls
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ CatalogController ───▶ ビューレンダリング
    │                                        │
    │                                        ▼
    │                               Vue.js アプリケーション
    │                                        │
    │                                        ▼
    │                               GraphQL API
    │                                        │
    └──────────────────────────────────────▶ カタログ一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| catalog_controller.rb | `app/controllers/explore/catalog_controller.rb` | コントローラ | リクエストハンドリング |
| show.html.haml | `app/views/explore/catalog/show.html.haml` | テンプレート | メインビュー |
| _ci_cd_catalog.html.haml | `app/views/explore/catalog/_ci_cd_catalog.html.haml` | パーシャル | Vue.jsマウントポイント |
| listing.rb | `app/models/ci/catalog/listing.rb` | モデル | カタログリスティングロジック |
| catalog_resource.rb | `app/models/ci/catalog/resource.rb` | モデル | カタログリソースモデル |
| explore.rb | `config/routes/explore.rb` | ルーティング | URLルーティング定義 |
| ci_cd_catalog/ | `app/assets/javascripts/ci/catalog/` | フロントエンド | Vue.jsアプリケーション |
