# 画面設計書 231-SSHキー詳細

## 概要

本ドキュメントは、GitLabの管理者向けSSHキー詳細画面の設計仕様を定義する。

### 本画面の処理概要

この画面では、管理者がシステム内の特定ユーザーが登録したSSHキーの詳細情報を確認し、必要に応じて削除することができる。

**業務上の目的・背景**：システム管理者がセキュリティ監査やユーザーサポートの一環として、ユーザーのSSHキー情報を確認する必要がある。期限切れのキーや不正なキーの検出、ユーザーからの問い合わせ対応時のキー情報確認などに利用される。また、不要なキーの削除によるセキュリティリスクの低減を目的とする。

**画面へのアクセス方法**：管理者エリア > ユーザー一覧 > ユーザー詳細 > SSHキー一覧 > 対象キーをクリック、またはURL `/admin/users/:user_id/keys/:id` に直接アクセス。

**主要な操作・処理内容**：
1. SSHキーの基本情報（タイトル、使用タイプ、作成日、最終使用日、有効期限）の確認
2. SSHキーの公開鍵全文の確認とクリップボードへのコピー
3. キーのフィンガープリント（MD5、SHA256）の確認
4. SSHキーの削除操作

**画面遷移**：
- 遷移元：管理者ユーザー詳細画面のSSHキータブ
- 遷移先：削除後は管理者ユーザーSSHキー一覧に戻る

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能。削除ボタンはキーが削除可能な状態の場合のみ表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 80 | SSHキー管理 | 主機能 | ユーザーSSHキー詳細の表示・削除 |
| 111 | ユーザー管理 | 補助機能 | 管理者によるユーザー情報管理 |

## 画面種別

詳細

## URL/ルーティング

- URL: `/admin/users/:user_id/keys/:id`
- ルート名: `admin_user_key_path`
- HTTPメソッド: GET (表示), DELETE (削除)
- コントローラ: `Admin::KeysController#show`

## 入出力項目

| 項目名 | 種別 | 必須 | 説明 |
|--------|------|------|------|
| user_id | パスパラメータ | 必須 | 対象ユーザーのユーザー名 |
| id | パスパラメータ | 必須 | SSHキーのID |

## 表示項目

### キー基本情報

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| タイトル | String | SSHキーの識別名 |
| 使用タイプ | String | 認証用/署名用などの使用目的 |
| 作成日 | DateTime | キー登録日時 |
| 最終使用日 | DateTime | 最後にキーが使用された日時（未使用の場合は「Never」） |
| 有効期限 | DateTime | キーの有効期限（期限切れの場合は赤色で「Expired」表示） |

### 公開鍵情報

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| SSH公開鍵 | Text | SSHキーの公開鍵全文 |
| MD5フィンガープリント | String | MD5形式のフィンガープリント |
| SHA256フィンガープリント | String | SHA256形式のフィンガープリント |

## イベント仕様

### 1-SSHキー削除

ユーザーが「Delete」ボタンをクリックした際の処理。

1. 確認モーダルが表示される
2. 確認後、`Admin::KeysController#destroy`が呼び出される
3. SSHキーがデータベースから削除される
4. 成功時：ユーザーのSSHキー一覧画面にリダイレクトし、成功メッセージを表示
5. 失敗時：ユーザーのSSHキー一覧画面にリダイレクトし、エラーメッセージを表示

### 2-クリップボードコピー

SSH公開鍵横のコピーボタンをクリックすると、公開鍵全文がクリップボードにコピーされる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | keys | SELECT | SSHキー情報の取得 |
| 画面表示 | users | SELECT | ユーザー情報の取得 |
| 削除ボタン押下 | keys | DELETE | SSHキーの削除 |

### テーブル別更新項目詳細

#### keys

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, title, key, fingerprint, fingerprint_sha256, usage_type, created_at, last_used_at, expires_at | user_id AND id で特定 | |
| DELETE | - | id で特定 | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG001 | 成功 | User key was successfully removed. | 削除成功時 |
| MSG002 | エラー | Failed to remove user key. | 削除失敗時 |
| MSG003 | 警告 | Warning! Insecure key. {message} | 安全でないキーが検出された場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| キーが存在しない | 404エラー画面を表示 |
| ユーザーが存在しない | 404エラー画面を表示 |
| 管理者権限がない | 403アクセス拒否画面を表示 |

## 備考

- SSHキーの有効期限が切れている場合、有効期限欄が赤色で「Expired」と表示される
- 安全でない暗号化方式のキーが検出された場合、警告バナーが表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

SSHキーモデルの構造を理解することが最初のステップ。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | key.rb | `app/models/key.rb` | SSHキーの属性、バリデーション、フィンガープリント生成ロジック |

**読解のコツ**: Railsモデルのバリデーションとコールバックに注目する。

#### Step 2: エントリーポイントを理解する

コントローラがリクエストを受け取り、ビューにデータを渡すフロー。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | keys_controller.rb | `app/controllers/admin/keys_controller.rb` | show/destroyアクションの実装 |

**主要処理フロー**:
1. **8-15行目**: showアクション - ユーザーのキーを取得して表示
2. **17-28行目**: destroyアクション - キーの削除処理

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/admin/keys/show.html.haml` | ビューのエントリーポイント |
| 3-2 | _key_details.html.haml | `app/views/user_settings/ssh_keys/_key_details.html.haml` | 共通キー詳細パーシャル |

**主要処理フロー**:
- **1-2行目**: ページタイトル設定と共通パーシャルのレンダリング

### プログラム呼び出し階層図

```
Admin::KeysController#show
    │
    ├─ user (private method)
    │      └─ User.find_by!(username: params[:user_id])
    │
    ├─ user.keys.find(params[:id])
    │
    └─ render view
           └─ user_settings/ssh_keys/_key_details.html.haml
                  ├─ ssh_key_delete_modal_data
                  └─ Pajamas components
```

### データフロー図

```
[入力]               [処理]                    [出力]

user_id (URL) ───▶ User.find_by! ───▶ @user
key_id (URL)  ───▶ @user.keys.find ───▶ @key
                                           │
                                           ▼
                              [View: key_details partial]
                                           │
                                           ▼
                              HTML (キー詳細情報表示)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| keys_controller.rb | `app/controllers/admin/keys_controller.rb` | コントローラ | リクエスト処理 |
| show.html.haml | `app/views/admin/keys/show.html.haml` | ビュー | メインビュー |
| _key_details.html.haml | `app/views/user_settings/ssh_keys/_key_details.html.haml` | パーシャル | キー詳細表示 |
| key.rb | `app/models/key.rb` | モデル | SSHキーモデル |
| admin.rb | `config/routes/admin.rb` | ルート | URLルーティング定義 |
