# 画面設計書 232-グループ一覧

## 概要

本ドキュメントは、GitLabの管理者向けグループ一覧画面の設計仕様を定義する。

### 本画面の処理概要

この画面では、管理者がシステム内のすべてのグループを一覧表示し、検索・フィルタリング・管理操作を行うことができる。Vueベースのシングルページアプリケーション（SPA）として実装されている。

**業務上の目的・背景**：システム管理者がGitLabインスタンス内のすべてのグループを把握・管理する必要がある。グループの使用状況の確認、問題のあるグループの特定、新規グループの作成など、システム全体のグループ管理を一元的に行うための画面である。大規模なGitLabインスタンスでは数千のグループが存在する可能性があり、効率的な検索・フィルタリング機能が重要となる。

**画面へのアクセス方法**：管理者エリア > 概要 > グループ、またはURL `/admin/groups` に直接アクセス。サイドナビゲーションの「Admin Area」→「Overview」→「Groups」からもアクセス可能。

**主要な操作・処理内容**：
1. グループの一覧表示（名前、パス、メンバー数、プロジェクト数等）
2. グループ名やパスによる検索
3. アクティブ/非アクティブグループのフィルタリング
4. 新規グループの作成画面への遷移
5. 個別グループの詳細画面への遷移

**画面遷移**：
- 遷移元：管理者ダッシュボード、サイドナビゲーション
- 遷移先：グループ詳細画面、グループ新規作成画面

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能。`can_admin_all_resources?`権限を持つユーザーのみ「New group」ボタンが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 112 | グループ管理 | 主機能 | 管理者向けグループ一覧の表示・管理 |
| 102 | グローバル検索 | 補助機能 | グループの検索機能 |

## 画面種別

一覧

## URL/ルーティング

- URL: `/admin/groups`
- アクティブフィルター: `/admin/groups/active`
- 非アクティブフィルター: `/admin/groups/inactive`
- ルート名: `admin_groups_path`
- HTTPメソッド: GET
- コントローラ: `Admin::GroupsController#index`

## 入出力項目

| 項目名 | 種別 | 必須 | 説明 |
|--------|------|------|------|
| search | クエリパラメータ | 任意 | グループ名/パスの検索文字列 |
| page | クエリパラメータ | 任意 | ページ番号 |

## 表示項目

### グループ一覧

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| アバター | Image | グループのアバター画像 |
| グループ名 | String | グループの名前（リンク） |
| グループパス | String | グループのフルパス |
| 説明 | String | グループの説明文 |
| メンバー数 | Integer | グループの直接メンバー数 |
| プロジェクト数 | Integer | グループ内のプロジェクト数 |
| 作成日 | DateTime | グループ作成日時 |
| 可視性レベル | Enum | Private/Internal/Public |

### 統計情報

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 総グループ数 | Integer | フィルター条件に合致するグループの総数 |

## イベント仕様

### 1-新規グループ作成

「New group」ボタンをクリックすると、グループ新規作成画面（`/admin/groups/new`）に遷移する。

### 2-グループ検索

検索フォームに文字列を入力して検索を実行すると、グループ名またはパスに一致するグループのみが表示される。

### 3-グループ詳細表示

グループ名をクリックすると、そのグループの詳細画面（`/admin/groups/:id`）に遷移する。

### 4-ページネーション

ページネーションコントロールで次ページ/前ページに移動可能。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | namespaces | SELECT | グループ一覧の取得 |
| 画面表示 | routes | SELECT | グループのパス情報取得 |
| 画面表示 | namespace_statistics | SELECT | グループの統計情報取得 |

### テーブル別更新項目詳細

#### namespaces

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, path, description, visibility_level, created_at | type = 'Group' | with_statistics スコープ使用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG001 | 情報 | No groups found | 検索結果が0件の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 管理者権限がない | 403アクセス拒否画面を表示 |
| データベース接続エラー | 500エラー画面を表示 |

## 備考

- この画面はVue.jsベースのSPAとして実装されている（`#js-admin-groups-app`）
- `admin_groups_app_data`ヘルパーがフロントエンドアプリケーションに必要なデータを提供
- グループ統計情報は`with_statistics`スコープで取得される
- イベントトラッキング（`event_tracking: 'view_admin_groups_pageload'`）が設定されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

グループモデルと関連する統計情報の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | group.rb | `app/models/group.rb` | グループモデルの属性とスコープ |
| 1-2 | namespace.rb | `app/models/namespace.rb` | 親クラスの構造（STI） |

**読解のコツ**: GroupはNamespaceのサブクラス（STI）であることを意識する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | groups_controller.rb | `app/controllers/admin/groups_controller.rb` | indexアクションの実装 |

**主要処理フロー**:
1. **10行目**: indexアクション - 空のメソッドだがビューがレンダリングされる
2. **73-75行目**: groupsメソッド - with_statistics.with_namespace_details.with_route

#### Step 3: ビューとフロントエンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/admin/groups/index.html.haml` | HAMLテンプレート |
| 3-2 | admin_groups_app_data | `app/helpers/admin/groups_helper.rb` | Vueアプリのデータ |

**主要処理フロー**:
- **10行目**: Vue.jsアプリケーションのマウントポイント
- **4-8行目**: ページヘッダーと新規作成ボタン

### プログラム呼び出し階層図

```
Admin::GroupsController#index
    │
    └─ render view
           │
           └─ index.html.haml
                  │
                  ├─ Layouts::PageHeadingComponent
                  │
                  └─ #js-admin-groups-app (Vue.js SPA)
                         │
                         └─ admin_groups_app_data (helper)
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTP GET ───▶ GroupsController#index ───▶ index.html.haml
                                                │
                                                ▼
                                    Vue.js App (SPA)
                                                │
                                                ▼
                               GraphQL/REST API calls
                                                │
                                                ▼
                                    グループ一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| groups_controller.rb | `app/controllers/admin/groups_controller.rb` | コントローラ | リクエスト処理 |
| index.html.haml | `app/views/admin/groups/index.html.haml` | ビュー | メインビュー |
| group.rb | `app/models/group.rb` | モデル | グループモデル |
| admin.rb | `config/routes/admin.rb` | ルート | URLルーティング定義 |
| groups_helper.rb | `app/helpers/admin/groups_helper.rb` | ヘルパー | Vueアプリデータ提供 |
