# 画面設計書 233-グループ詳細

## 概要

本ドキュメントは、GitLabの管理者向けグループ詳細画面の設計仕様を定義する。

### 本画面の処理概要

この画面では、管理者が特定のグループの詳細情報を確認し、メンバー管理やプロジェクト一覧の閲覧、グループ設定の編集などを行うことができる。

**業務上の目的・背景**：システム管理者がグループの詳細な情報を確認し、適切な管理を行う必要がある。グループのストレージ使用量、メンバー構成、所属プロジェクトなどを一元的に把握し、問題の特定や監査対応を行うための画面である。また、グループ設定の変更やメンバーのアクセス権管理の起点となる重要な画面である。

**画面へのアクセス方法**：管理者エリア > グループ一覧 > 対象グループをクリック、またはURL `/admin/groups/:id` に直接アクセス。

**主要な操作・処理内容**：
1. グループ基本情報（名前、パス、説明、可視性、作成日、ID）の確認
2. ストレージ使用量の確認
3. Git LFSステータスの確認
4. 所属プロジェクト一覧の確認
5. 共有プロジェクト一覧の確認
6. グループメンバー一覧の確認
7. アクセスリクエストの管理
8. 管理者メモの確認・編集
9. カスタム属性の確認
10. グループ編集画面への遷移

**画面遷移**：
- 遷移元：管理者グループ一覧画面
- 遷移先：グループ編集画面、プロジェクト詳細画面、ユーザー詳細画面、グループメンバー管理画面

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能。`can_admin_all_resources?`権限を持つユーザーに「Edit」ボタンが表示される。グループオーナーにはメンバー管理機能が追加で表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 112 | グループ管理 | 主機能 | 管理者向けグループ詳細の表示 |
| 85 | グループメンバー管理 | 補助機能 | グループメンバーの一覧表示 |
| 86 | 招待機能 | 補助機能 | アクセスリクエストの管理 |

## 画面種別

詳細

## URL/ルーティング

- URL: `/admin/groups/:id`
- ルート名: `admin_group_path`
- HTTPメソッド: GET
- コントローラ: `Admin::GroupsController#show`

## 入出力項目

| 項目名 | 種別 | 必須 | 説明 |
|--------|------|------|------|
| id | パスパラメータ | 必須 | グループのフルパス |
| members_page | クエリパラメータ | 任意 | メンバー一覧のページ番号 |
| projects_page | クエリパラメータ | 任意 | プロジェクト一覧のページ番号 |

## 表示項目

### グループ情報セクション

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| アバター | Image | グループのアバター画像 |
| 名前 | String | グループ名（リンク付き） |
| パス | String | グループのパス |
| 説明 | Text | グループの説明文 |
| 可視性レベル | String | Private/Internal/Public |
| 作成日 | DateTime | グループ作成日時 |
| ID | Integer | グループID |
| ストレージ使用量 | String | 使用中のストレージ容量 |
| Git LFSステータス | String | Git LFSの有効/無効状態 |

### プロジェクトセクション

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| プロジェクト名 | String | プロジェクト名（リンク付き） |
| ストレージサイズ | String | プロジェクトのストレージ使用量 |
| フルパス | String | プロジェクトのフルパス |

### グループメンバーセクション

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| メンバー数 | Integer | 直接メンバーの総数 |
| メンバー一覧 | Array | メンバー情報のリスト |

## イベント仕様

### 1-グループ編集

「Edit」ボタンをクリックすると、グループ編集画面（`/admin/groups/:id/edit`）に遷移する。

### 2-メンバー管理画面遷移

「Manage access」ボタンをクリックすると、グループメンバー管理画面に遷移する。

### 3-プロジェクト詳細表示

プロジェクト名をクリックすると、管理者向けプロジェクト詳細画面に遷移する。

### 4-ページネーション

メンバー一覧、プロジェクト一覧それぞれにページネーションが設定されている。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | namespaces | SELECT | グループ情報の取得 |
| 画面表示 | namespace_statistics | SELECT | 統計情報の取得 |
| 画面表示 | projects | SELECT | 所属プロジェクトの取得 |
| 画面表示 | project_statistics | SELECT | プロジェクト統計の取得 |
| 画面表示 | members | SELECT | グループメンバーの取得 |
| 画面表示 | users | SELECT | メンバーのユーザー情報取得 |

### テーブル別更新項目詳細

#### namespaces (Group)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, path, description, visibility_level, created_at, lfs_enabled | full_path で特定 | with_statistics スコープ使用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG001 | 情報 | No projects | プロジェクトが0件の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| グループが存在しない | 404エラー画面を表示 |
| 管理者権限がない | 403アクセス拒否画面を表示 |

## 備考

- グループは`with_statistics`スコープで統計情報を含めて取得される
- メンバーはアクセスレベル降順でソートされる
- 共有プロジェクト（他グループからの共有）も別セクションで表示される
- LDAP連携が有効な場合、LDAP グループリンクセクションが追加表示される（Enterprise Edition）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | group.rb | `app/models/group.rb` | グループモデル、統計スコープ |
| 1-2 | member.rb | `app/models/member.rb` | メンバーシップモデル |

**読解のコツ**: with_statisticsスコープがどのようなデータを取得するかに注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | groups_controller.rb | `app/controllers/admin/groups_controller.rb` | showアクションの実装 |

**主要処理フロー**:
1. **13-24行目**: showアクション
2. **18行目**: Group.with_statistics.find でグループ取得
3. **19-20行目**: メンバー一覧をアクセスレベル降順で取得
4. **21-22行目**: アクセスリクエスト一覧を取得
5. **23行目**: プロジェクト一覧を統計付きで取得

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/admin/groups/show.html.haml` | メインビュー |
| 3-2 | _member.html.haml | `app/views/shared/members/_member.html.haml` | メンバー行の表示 |

**主要処理フロー**:
- **17-57行目**: グループ情報セクション
- **58-76行目**: プロジェクトセクション
- **77-91行目**: 共有プロジェクトセクション
- **98-116行目**: グループメンバーセクション

### プログラム呼び出し階層図

```
Admin::GroupsController#show
    │
    ├─ Group.find_by_full_path (group method)
    │
    ├─ Group.with_statistics.find
    │
    ├─ present_members (concern)
    │      └─ MembersPresentation
    │
    ├─ AccessRequestsFinder.new.execute
    │
    └─ render view
           │
           └─ show.html.haml
                  ├─ Layouts::CrudComponent (Group info)
                  ├─ Layouts::CrudComponent (Projects)
                  ├─ shared/members/_member (partial)
                  └─ shared/admin/_admin_note (partial)
```

### データフロー図

```
[入力]               [処理]                    [出力]

group_id (URL) ───▶ Group.find_by_full_path ───▶ @group
                           │
                           ▼
               Group.with_statistics.find
                           │
                           ▼
               @group.members ───▶ @members
               @group.projects ───▶ @projects
               AccessRequestsFinder ───▶ @requesters
                           │
                           ▼
                  [View: show.html.haml]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| groups_controller.rb | `app/controllers/admin/groups_controller.rb` | コントローラ | リクエスト処理 |
| show.html.haml | `app/views/admin/groups/show.html.haml` | ビュー | メインビュー |
| _member.html.haml | `app/views/shared/members/_member.html.haml` | パーシャル | メンバー行表示 |
| _admin_note.html.haml | `app/views/shared/admin/_admin_note.html.haml` | パーシャル | 管理者メモ表示 |
| group.rb | `app/models/group.rb` | モデル | グループモデル |
| admin.rb | `config/routes/admin.rb` | ルート | URLルーティング定義 |
