# 画面設計書 234-グループ新規作成

## 概要

本ドキュメントは、GitLabの管理者向けグループ新規作成画面の設計仕様を定義する。

### 本画面の処理概要

この画面では、管理者が新しいグループを作成することができる。グループ名、パス、説明、可視性レベル、各種権限設定などを入力してグループを作成する。

**業務上の目的・背景**：システム管理者が組織のニーズに応じて新しいグループを作成する必要がある。部門やプロジェクトチーム単位でのグループ作成、特定の可視性設定が必要なグループの作成など、ユーザーからの依頼に基づくグループ作成や、システム管理上の理由によるグループ作成を行うための画面である。管理者が作成することで、ユーザーが作成できないような特殊な設定のグループも作成可能。

**画面へのアクセス方法**：管理者エリア > グループ一覧 > 「New group」ボタン、またはURL `/admin/groups/new` に直接アクセス。

**主要な操作・処理内容**：
1. グループ名の入力
2. グループパス（URL）の入力
3. グループ説明の入力
4. アバター画像のアップロード
5. 可視性レベル（Private/Internal/Public）の選択
6. アクセスリクエスト許可設定
7. LFS有効化設定
8. 2要素認証要求設定
9. Runner登録許可設定
10. プロジェクト作成レベル設定
11. サブグループ作成レベル設定
12. 管理者メモの入力
13. グループの作成実行

**画面遷移**：
- 遷移元：管理者グループ一覧画面
- 遷移先：成功時はグループ詳細画面、失敗時は本画面（エラー表示）

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能。Enterprise Edition固有の設定項目（ストレージ制限、プラン設定等）は該当機能が有効な場合のみ表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 112 | グループ管理 | 主機能 | 管理者によるグループ作成 |
| 9 | グループ作成 | 主機能 | グループ作成処理の実行 |

## 画面種別

登録

## URL/ルーティング

- URL: `/admin/groups/new`
- ルート名: `new_admin_group_path`
- HTTPメソッド: GET (フォーム表示), POST (作成実行)
- コントローラ: `Admin::GroupsController#new`, `Admin::GroupsController#create`

## 入出力項目

### 入力フォーム

| 項目名 | 種別 | 必須 | データ型 | 説明 | バリデーション |
|--------|------|------|----------|------|---------------|
| name | テキスト | 必須 | String | グループ名 | 最大255文字 |
| path | テキスト | 必須 | String | グループパス | URL形式、予約語禁止 |
| description | テキストエリア | 任意 | Text | グループ説明 | |
| avatar | ファイル | 任意 | Image | アバター画像 | 画像形式チェック |
| visibility_level | ラジオボタン | 必須 | Integer | 可視性レベル | 0(Private)/10(Internal)/20(Public) |
| request_access_enabled | チェックボックス | 任意 | Boolean | アクセスリクエスト許可 | |
| lfs_enabled | チェックボックス | 任意 | Boolean | LFS有効化 | |
| require_two_factor_authentication | チェックボックス | 任意 | Boolean | 2FA要求 | |
| two_factor_grace_period | 数値 | 条件付き | Integer | 2FA猶予期間（時間） | 2FA要求時のみ |
| runner_registration_enabled | チェックボックス | 任意 | Boolean | Runner登録許可 | |
| project_creation_level | セレクト | 任意 | Integer | プロジェクト作成レベル | |
| subgroup_creation_level | セレクト | 任意 | Integer | サブグループ作成レベル | |
| admin_note_attributes[note] | テキストエリア | 任意 | Text | 管理者メモ | |

## 表示項目

### セクション1: 命名と可視性

| 項目名 | 説明 |
|--------|------|
| グループ名 | グループの表示名入力 |
| グループパス | URLに使用されるパス入力 |
| グループ説明 | 説明文入力 |
| アバター | グループアイコンのアップロード |
| 可視性レベル | アクセス範囲の選択 |

### セクション2: 権限とグループ機能

| 項目名 | 説明 |
|--------|------|
| アクセスリクエスト許可 | 非メンバーからの参加リクエストを許可 |
| 2要素認証設定 | メンバーに2FAを要求 |
| Runner登録許可 | 新規Runnerの登録を許可 |

### セクション3: 管理者メモ

| 項目名 | 説明 |
|--------|------|
| 管理者メモ | 管理者向けの内部メモ |

## イベント仕様

### 1-グループ作成

「Create group」ボタンをクリックした際の処理。

1. フォームデータを`Admin::GroupsController#create`に送信
2. `Groups::CreateService`でグループを作成
3. 成功時：グループ詳細画面にリダイレクトし、成功メッセージを表示
4. 失敗時：本画面を再表示し、エラーメッセージを表示

### 2-キャンセル

「Cancel」ボタンをクリックすると、グループ一覧画面に戻る。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| グループ作成 | namespaces | INSERT | グループ情報の登録 |
| グループ作成 | routes | INSERT | URLルートの登録 |
| グループ作成 | namespace_settings | INSERT | グループ設定の登録 |
| グループ作成 | admin_notes | INSERT | 管理者メモの登録（任意） |

### テーブル別更新項目詳細

#### namespaces

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | |
| INSERT | path | フォーム入力値 | 自動変換あり |
| INSERT | description | フォーム入力値 | |
| INSERT | visibility_level | フォーム入力値 | デフォルト値あり |
| INSERT | type | 'Group' | STI |
| INSERT | lfs_enabled | フォーム入力値 | |
| INSERT | request_access_enabled | フォーム入力値 | |
| INSERT | organization_id | Current.organization.id | 現在の組織ID |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG001 | 成功 | Group {group_name} was successfully created. | 作成成功時 |
| MSG002 | エラー | {バリデーションエラーメッセージ} | 作成失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 管理者権限がない | 403アクセス拒否画面を表示 |
| パスが重複 | エラーメッセージを表示して再入力を促す |
| 予約語パス使用 | エラーメッセージを表示して再入力を促す |

## 備考

- グループ作成時に`Current.organization.id`が自動的に設定される
- デフォルトの可視性レベルは`default_group_visibility`ヘルパーで取得
- 「Groups can also be created from...」のTipsアラートが表示される
- Runner登録を無効にすると、既存の登録トークンがリセットされる（更新時のみ）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | group.rb | `app/models/group.rb` | グループモデル、バリデーション |
| 1-2 | namespace.rb | `app/models/namespace.rb` | 親クラスの構造 |

**読解のコツ**: Groupのバリデーションルールと許可されるパラメータを確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | groups_controller.rb | `app/controllers/admin/groups_controller.rb` | new/createアクション |

**主要処理フロー**:
1. **27-30行目**: newアクション - 空のGroupオブジェクトと管理者メモを初期化
2. **36-46行目**: createアクション - Groups::CreateServiceを使用してグループ作成
3. **85-108行目**: group_params, allowed_group_params - 許可されるパラメータ定義

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create_service.rb | `app/services/groups/create_service.rb` | グループ作成ロジック |

**主要処理フロー**:
- グループのビルドと保存
- ネストした属性（admin_note等）の処理
- 失敗時のエラーハンドリング

#### Step 4: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | new.html.haml | `app/views/admin/groups/new.html.haml` | フォーム表示 |
| 4-2 | _form.html.haml | `app/views/admin/groups/_form.html.haml` | フォーム本体 |

**主要処理フロー**:
- **1-6行目** (new): ページタイトルとヘッダー
- **1-45行目** (_form): フォーム構造とセクション

### プログラム呼び出し階層図

```
Admin::GroupsController#new
    │
    ├─ Group.new
    │
    └─ @group.build_admin_note
           │
           └─ render view
                  └─ _form.html.haml

Admin::GroupsController#create
    │
    ├─ group_params (private)
    │
    └─ Groups::CreateService.new.execute
           │
           ├─ Group.new
           ├─ Group#save
           │
           └─ Success → redirect_to [:admin, @group]
              Failure → render "new"
```

### データフロー図

```
[入力]               [処理]                    [出力]

Form Data ───▶ GroupsController#create
                      │
                      ▼
               group_params
                      │
                      ▼
         Groups::CreateService.execute
                      │
                      ├─ Success ───▶ redirect + flash[:notice]
                      │
                      └─ Failure ───▶ render "new" + errors
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| groups_controller.rb | `app/controllers/admin/groups_controller.rb` | コントローラ | リクエスト処理 |
| new.html.haml | `app/views/admin/groups/new.html.haml` | ビュー | フォーム表示 |
| _form.html.haml | `app/views/admin/groups/_form.html.haml` | パーシャル | フォーム本体 |
| create_service.rb | `app/services/groups/create_service.rb` | サービス | 作成ロジック |
| group.rb | `app/models/group.rb` | モデル | グループモデル |
| admin.rb | `config/routes/admin.rb` | ルート | URLルーティング定義 |
