# 画面設計書 236-プロジェクト一覧

## 概要

本ドキュメントは、GitLabの管理者向けプロジェクト一覧画面の設計仕様を定義する。

### 本画面の処理概要

この画面では、管理者がシステム内のすべてのプロジェクトを一覧表示し、検索・フィルタリング・管理操作を行うことができる。Vue.jsベースのシングルページアプリケーション（SPA）として実装されている。

**業務上の目的・背景**：システム管理者がGitLabインスタンス内のすべてのプロジェクトを把握・管理する必要がある。プロジェクトの使用状況の確認、問題のあるプロジェクトの特定、ストレージ使用量の監視など、システム全体のプロジェクト管理を一元的に行うための画面である。大規模なGitLabインスタンスでは数万のプロジェクトが存在する可能性があり、効率的な検索・フィルタリング機能が重要となる。

**画面へのアクセス方法**：管理者エリア > 概要 > プロジェクト、またはURL `/admin/projects` に直接アクセス。サイドナビゲーションの「Admin Area」→「Overview」→「Projects」からもアクセス可能。

**主要な操作・処理内容**：
1. プロジェクトの一覧表示（名前、パス、オーナー、可視性、統計情報等）
2. プロジェクト名やパスによる検索
3. アクティブ/非アクティブプロジェクトのフィルタリング
4. 可視性レベルによるフィルタリング
5. 新規プロジェクトの作成画面への遷移
6. 個別プロジェクトの詳細画面への遷移

**画面遷移**：
- 遷移元：管理者ダッシュボード、サイドナビゲーション
- 遷移先：プロジェクト詳細画面、プロジェクト新規作成画面

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能。`can_admin_all_resources?`権限を持つユーザーのみ「New Project」ボタンが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 113 | プロジェクト管理 | 主機能 | 管理者向けプロジェクト一覧の表示・管理 |
| 102 | グローバル検索 | 補助機能 | プロジェクトの検索機能 |

## 画面種別

一覧

## URL/ルーティング

- URL: `/admin/projects`
- アクティブフィルター: `/admin/projects/active`
- 非アクティブフィルター: `/admin/projects/inactive`
- ルート名: `admin_projects_path`
- HTTPメソッド: GET
- コントローラ: `Admin::ProjectsController#index`（※コントローラにはindexアクションが定義されていないため、Vue.js SPAが処理）

## 入出力項目

| 項目名 | 種別 | 必須 | 説明 |
|--------|------|------|------|
| search | クエリパラメータ | 任意 | プロジェクト名/パスの検索文字列 |
| visibility_level | クエリパラメータ | 任意 | 可視性レベルフィルター |
| page | クエリパラメータ | 任意 | ページ番号 |

## 表示項目

### プロジェクト一覧

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| アバター | Image | プロジェクトのアバター画像 |
| プロジェクト名 | String | プロジェクトの名前（リンク） |
| プロジェクトパス | String | プロジェクトのフルパス |
| 説明 | String | プロジェクトの説明文 |
| オーナー/ネームスペース | String | プロジェクトの所属グループまたはユーザー |
| 可視性レベル | Enum | Private/Internal/Public |
| ストレージ使用量 | String | プロジェクトのストレージ容量 |
| 最終アクティビティ | DateTime | 最後のアクティビティ日時 |

### 統計情報

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 総プロジェクト数 | Integer | フィルター条件に合致するプロジェクトの総数 |

## イベント仕様

### 1-新規プロジェクト作成

「New Project」ボタンをクリックすると、プロジェクト新規作成画面（`/projects/new`）に遷移する。

### 2-プロジェクト検索

検索フォームに文字列を入力して検索を実行すると、プロジェクト名またはパスに一致するプロジェクトのみが表示される。

### 3-プロジェクト詳細表示

プロジェクト名をクリックすると、そのプロジェクトの管理者向け詳細画面（`/admin/projects/:namespace_id/:id`）に遷移する。

### 4-可視性フィルタリング

可視性レベル（Private/Internal/Public）でプロジェクトをフィルタリングできる。

### 5-ページネーション

ページネーションコントロールで次ページ/前ページに移動可能。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | projects | SELECT | プロジェクト一覧の取得 |
| 画面表示 | namespaces | SELECT | ネームスペース情報取得 |
| 画面表示 | project_statistics | SELECT | プロジェクト統計情報取得 |

### テーブル別更新項目詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, path, description, visibility_level, created_at, last_activity_at, namespace_id | 検索条件に基づく | with_statistics スコープ使用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG001 | 情報 | No projects found | 検索結果が0件の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 管理者権限がない | 403アクセス拒否画面を表示 |
| データベース接続エラー | 500エラー画面を表示 |

## 備考

- この画面はVue.jsベースのSPAとして実装されている（`#js-admin-projects-app`）
- `admin_projects_app_data`ヘルパーがフロントエンドアプリケーションに必要なデータを提供
- イベントトラッキング（`event_tracking: 'view_admin_projects_pageload'`）が設定されている
- 中国版GitLab (JiHu) への移行バナーが条件付きで表示される場合がある
- 可視性フィルターのデフォルト値は空配列（すべて表示）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プロジェクトモデルと関連する統計情報の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project.rb | `app/models/project.rb` | プロジェクトモデルの属性とスコープ |
| 1-2 | project_statistics.rb | `app/models/project_statistics.rb` | ストレージ統計の構造 |

**読解のコツ**: with_statisticsスコープがどのようなデータを取得するかに注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | projects_controller.rb | `app/controllers/admin/projects_controller.rb` | コントローラ構造（indexアクションなし） |

**主要処理フロー**:
- コントローラにindexアクションは定義されていない
- ルーティングでindex用のアクションが定義されている（E-03参照）
- 実際の一覧表示はVue.js SPAが担当

#### Step 3: ビューとフロントエンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/admin/projects/index.html.haml` | HAMLテンプレート |
| 3-2 | admin_projects_app_data | `app/helpers/admin/projects_helper.rb` | Vueアプリのデータ |

**主要処理フロー**:
- **16行目**: Vue.jsアプリケーションのマウントポイント
- **10-14行目**: ページヘッダーと新規作成ボタン
- **6-8行目**: JiHu移行バナー（条件付き）

### プログラム呼び出し階層図

```
HTTP GET /admin/projects
    │
    └─ routes/admin.rb (resources :projects, only: [:index])
           │
           └─ Admin::ProjectsController (implicit index)
                  │
                  └─ render view
                         │
                         └─ index.html.haml
                                │
                                ├─ Layouts::PageHeadingComponent
                                │
                                └─ #js-admin-projects-app (Vue.js SPA)
                                       │
                                       └─ admin_projects_app_data (helper)
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTP GET ───▶ Rails routing ───▶ index.html.haml
                                        │
                                        ▼
                            Vue.js App (SPA)
                                        │
                                        ▼
                           GraphQL/REST API calls
                                        │
                                        ▼
                           プロジェクト一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| projects_controller.rb | `app/controllers/admin/projects_controller.rb` | コントローラ | リクエスト処理 |
| index.html.haml | `app/views/admin/projects/index.html.haml` | ビュー | メインビュー |
| project.rb | `app/models/project.rb` | モデル | プロジェクトモデル |
| admin.rb | `config/routes/admin.rb` | ルート | URLルーティング定義 |
| projects_helper.rb | `app/helpers/admin/projects_helper.rb` | ヘルパー | Vueアプリデータ提供 |
