# 画面設計書 237-プロジェクト詳細

## 概要

本ドキュメントは、GitLabの管理者向けプロジェクト詳細画面の設計仕様を定義する。

### 本画面の処理概要

この画面では、管理者が特定のプロジェクトの詳細情報を確認し、メンバー管理、プロジェクト移行、リポジトリチェックなどの管理操作を行うことができる。

**業務上の目的・背景**：システム管理者がプロジェクトの詳細な情報を確認し、適切な管理を行う必要がある。プロジェクトのストレージ使用量、メンバー構成、リポジトリの状態などを一元的に把握し、問題の特定や監査対応を行うための画面である。また、プロジェクトの移行（別ネームスペースへの移動）やリポジトリの整合性チェックなど、重要な管理操作の起点となる画面である。

**画面へのアクセス方法**：管理者エリア > プロジェクト一覧 > 対象プロジェクトをクリック、またはURL `/admin/:namespace_id/:project_id` に直接アクセス。

**主要な操作・処理内容**：
1. プロジェクト基本情報（名前、ネームスペース、オーナー、作成日、ID）の確認
2. リポジトリ情報（HTTP/SSH URL、ストレージ名、相対パス）の確認
3. ストレージ使用量の確認
4. Git LFSステータスの確認
5. 最終コミット情報の確認
6. グループメンバー一覧の確認
7. プロジェクトメンバー一覧の確認
8. アクセスリクエストの管理
9. プロジェクトの別ネームスペースへの移行
10. リポジトリチェックの実行
11. カスタム属性の確認
12. プロジェクト編集画面への遷移

**画面遷移**：
- 遷移元：管理者プロジェクト一覧画面
- 遷移先：プロジェクト編集画面、グループ詳細画面、ユーザー詳細画面、メンバー管理画面

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能。`can_admin_all_resources?`権限を持つユーザーに「Edit」ボタン、移行機能、リポジトリチェック機能が表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 113 | プロジェクト管理 | 主機能 | 管理者向けプロジェクト詳細の表示 |
| 84 | プロジェクトメンバー管理 | 補助機能 | プロジェクトメンバーの一覧表示 |
| 85 | グループメンバー管理 | 補助機能 | グループメンバーの一覧表示 |
| 5 | プロジェクト移行 | 補助機能 | プロジェクトの別ネームスペースへの移行 |

## 画面種別

詳細

## URL/ルーティング

- URL: `/admin/:namespace_id/:project_id`
- ルート名: `admin_namespace_project_path`
- HTTPメソッド: GET
- コントローラ: `Admin::ProjectsController#show`

## 入出力項目

| 項目名 | 種別 | 必須 | 説明 |
|--------|------|------|------|
| namespace_id | パスパラメータ | 必須 | プロジェクトのネームスペースパス |
| project_id | パスパラメータ | 必須 | プロジェクトのパス |
| group_members_page | クエリパラメータ | 任意 | グループメンバー一覧のページ番号 |
| project_members_page | クエリパラメータ | 任意 | プロジェクトメンバー一覧のページ番号 |

## 表示項目

### プロジェクト情報セクション

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 名前 | String | プロジェクト名（リンク付き） |
| ネームスペース | String | 所属グループまたはユーザー |
| オーナー | String | プロジェクトオーナー |
| 作成者 | String | プロジェクト作成者 |
| 作成日 | DateTime | プロジェクト作成日時 |
| ID | Integer | プロジェクトID |
| HTTP URL | String | HTTPクローンURL |
| SSH URL | String | SSHクローンURL |
| ストレージ名 | String | Gitalyストレージ名 |
| 相対パス | String | リポジトリの相対パス |
| ストレージ使用量 | String | 使用中のストレージ容量 |
| 最終コミット | String | 最後のコミット情報 |
| Git LFSステータス | String | Git LFSの有効/無効状態 |
| アーカイブ状態 | String | アーカイブされている場合に表示 |
| 可視性レベル | String | Private/Internal/Public |

### グループメンバーセクション（グループ所属プロジェクトのみ）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| メンバー数 | Integer | グループメンバーの総数 |
| メンバー一覧 | Array | メンバー情報のリスト |

### プロジェクトメンバーセクション

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| メンバー数 | Integer | プロジェクトメンバーの総数 |
| メンバー一覧 | Array | メンバー情報のリスト |

### 移行セクション

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 移行先ネームスペース | Select | 移行先の選択 |

### リポジトリチェックセクション

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 最終チェック日時 | DateTime | 前回のリポジトリチェック日時 |
| チェック結果 | String | 成功/失敗 |

## イベント仕様

### 1-プロジェクト編集

「Edit」ボタンをクリックすると、プロジェクト編集画面に遷移する。

### 2-プロジェクト移行

「Transfer」ボタンをクリックすると、選択したネームスペースにプロジェクトを移行する。

1. フォームでネームスペースを選択
2. 「Transfer」ボタンをクリック
3. `Projects::TransferService`でプロジェクトを移行
4. 成功時：本画面を再表示（新URLで）
5. 失敗時：エラーメッセージを表示

### 3-リポジトリチェック

「Trigger repository check」ボタンをクリックすると、リポジトリの整合性チェックを実行する。

1. ボタンをクリック
2. `RepositoryCheck::SingleRepositoryWorker`をキューに追加
3. 成功メッセージを表示してリダイレクト

### 4-メンバー管理画面遷移

「Manage access」ボタンをクリックすると、グループまたはプロジェクトのメンバー管理画面に遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | projects | SELECT | プロジェクト情報の取得 |
| 画面表示 | namespaces | SELECT | ネームスペース情報の取得 |
| 画面表示 | project_statistics | SELECT | 統計情報の取得 |
| 画面表示 | members | SELECT | メンバー情報の取得 |
| プロジェクト移行 | projects | UPDATE | namespace_id の変更 |
| プロジェクト移行 | routes | UPDATE | パスの更新 |
| リポジトリチェック | projects | UPDATE | last_repository_check_at の更新 |

### テーブル別更新項目詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | namespace_id + path で特定 | |
| UPDATE (移行) | namespace_id | 新しいネームスペースID | TransferService経由 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG001 | 成功 | Repository check was triggered. | リポジトリチェック開始時 |
| MSG002 | 警告 | Last repository check failed. See the 'repocheck.log' file for error messages. | リポジトリチェック失敗時 |
| MSG003 | エラー | {移行エラーメッセージ} | プロジェクト移行失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| プロジェクトが存在しない | 404エラー画面を表示 |
| 管理者権限がない | 403アクセス拒否画面を表示 |
| リポジトリが存在しない | 「repository: does not exist」と表示 |

## 備考

- リポジトリチェックが失敗した場合、画面上部に警告バナーが表示される
- プロジェクトがアーカイブされている場合（または親グループがアーカイブ）、「archived: project is read-only」が表示される
- Geo機能が有効な場合、Geoステータスウィジェットが追加表示される（Enterprise Edition）
- 共有Runner設定が表示される場合がある（Enterprise Edition）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project.rb | `app/models/project.rb` | プロジェクトモデル、リポジトリ関連メソッド |
| 1-2 | project_statistics.rb | `app/models/project_statistics.rb` | ストレージ統計 |

**読解のコツ**: リポジトリ存在チェック、ストレージ情報取得に注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | projects_controller.rb | `app/controllers/admin/projects_controller.rb` | show/transfer/repository_checkアクション |

**主要処理フロー**:
1. **13-23行目**: showアクション - グループメンバー、プロジェクトメンバー、リクエスターを取得
2. **36-44行目**: transferアクション - TransferService経由で移行
3. **64-71行目**: repository_checkアクション - ワーカーをキューに追加

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/admin/projects/show.html.haml` | メインビュー |

**主要処理フロー**:
- **14-22行目**: リポジトリチェック失敗時の警告バナー
- **25-133行目**: プロジェクト情報セクション
- **139-148行目**: 移行セクション
- **149-166行目**: リポジトリチェックセクション
- **167-203行目**: メンバーセクション

### プログラム呼び出し階層図

```
Admin::ProjectsController#show
    │
    ├─ project (private method)
    │      └─ Project.find_by_full_path
    │
    ├─ group (private method)
    │      └─ @project.group
    │
    ├─ present_members (concern)
    │      └─ MembersPresentation
    │
    ├─ AccessRequestsFinder.new.execute
    │
    └─ render view
           │
           └─ show.html.haml
                  ├─ Layouts::CrudComponent (Project info)
                  ├─ shared/members/_member (partial)
                  ├─ Transfer form
                  └─ Repository check form
```

### データフロー図

```
[入力]               [処理]                    [出力]

namespace_id +       Project.find_by_full_path
project_id (URL) ───▶          │            ───▶ @project
                               │
                               ▼
                         @project.group ───▶ @group
                               │
                               ▼
                   group.members / project.members
                               │
                               ▼
                      [View: show.html.haml]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| projects_controller.rb | `app/controllers/admin/projects_controller.rb` | コントローラ | リクエスト処理 |
| show.html.haml | `app/views/admin/projects/show.html.haml` | ビュー | メインビュー |
| _member.html.haml | `app/views/shared/members/_member.html.haml` | パーシャル | メンバー行表示 |
| project.rb | `app/models/project.rb` | モデル | プロジェクトモデル |
| transfer_service.rb | `app/services/projects/transfer_service.rb` | サービス | プロジェクト移行 |
| admin.rb | `config/routes/admin.rb` | ルート | URLルーティング定義 |
