# 画面設計書 238-プロジェクト編集

## 概要

本ドキュメントは、GitLabの管理者向けプロジェクト編集画面の設計仕様を定義する。

### 本画面の処理概要

この画面では、管理者が既存のプロジェクトの設定を編集することができる。プロジェクト名、説明、Runner登録設定などを変更してプロジェクト情報を更新する。

**業務上の目的・背景**：システム管理者が既存プロジェクトの設定を変更する必要がある。プロジェクト名の変更、説明の更新、CI/CD設定（Runner登録の有効/無効）の変更など、プロジェクトの基本設定を管理者権限で変更するための画面である。通常のプロジェクト設定画面よりもシンプルな構成で、管理者が必要最小限の設定変更を行える。

**画面へのアクセス方法**：管理者エリア > プロジェクト一覧 > プロジェクト詳細 > 「Edit」ボタン、またはURL `/admin/:namespace_id/:project_id/edit` に直接アクセス。

**主要な操作・処理内容**：
1. プロジェクト名の変更
2. プロジェクト説明の変更
3. Runner登録許可設定の変更
4. プロジェクト設定の保存

**画面遷移**：
- 遷移元：管理者プロジェクト詳細画面
- 遷移先：成功時はプロジェクト詳細画面、失敗時は本画面（エラー表示）

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能。Runner登録設定はシステム全体の設定で無効化されている場合は無効状態で表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 113 | プロジェクト管理 | 主機能 | 管理者によるプロジェクト編集 |
| 2 | プロジェクト編集 | 主機能 | プロジェクト編集処理の実行 |

## 画面種別

編集

## URL/ルーティング

- URL: `/admin/:namespace_id/:project_id/edit`
- ルート名: `edit_admin_namespace_project_path`
- HTTPメソッド: GET (フォーム表示), PATCH/PUT (更新実行)
- コントローラ: `Admin::ProjectsController#edit`, `Admin::ProjectsController#update`

## 入出力項目

### パスパラメータ

| 項目名 | 種別 | 必須 | 説明 |
|--------|------|------|------|
| namespace_id | パスパラメータ | 必須 | プロジェクトのネームスペースパス |
| project_id | パスパラメータ | 必須 | プロジェクトのパス |

### 入力フォーム

| 項目名 | 種別 | 必須 | データ型 | 説明 | バリデーション |
|--------|------|------|----------|------|---------------|
| name | テキスト | 必須 | String | プロジェクト名 | 最大255文字 |
| id | テキスト（読取専用） | - | Integer | プロジェクトID | 変更不可 |
| description | テキストエリア | 任意 | Text | プロジェクト説明 | |
| runner_registration_enabled | チェックボックス | 任意 | Boolean | Runner登録許可 | |

## 表示項目

### セクション1: 命名

| 項目名 | 説明 |
|--------|------|
| プロジェクト名 | 現在のプロジェクト名（編集可能） |
| プロジェクトID | 現在のID（読取専用） |
| プロジェクト説明 | 現在の説明文（編集可能） |

### セクション2: 権限とプロジェクト機能

| 項目名 | 説明 |
|--------|------|
| Runner登録許可 | 新規Runnerの登録を許可するかどうか |

## イベント仕様

### 1-プロジェクト更新

「Save changes」ボタンをクリックした際の処理。

1. フォームデータを`Admin::ProjectsController#update`に送信
2. `Projects::UpdateService`でプロジェクトを更新
3. Runner登録を無効にした場合、登録トークンをリセット
4. 成功時：プロジェクト詳細画面にリダイレクトし、成功メッセージを表示
5. 失敗時：本画面を再表示し、エラーメッセージを表示

### 2-キャンセル

「Cancel」ボタンをクリックすると、プロジェクト詳細画面に戻る。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | projects | SELECT | プロジェクト情報の取得 |
| プロジェクト更新 | projects | UPDATE | プロジェクト情報の更新 |
| Runner登録無効化 | ci_runners | UPDATE | 登録トークンのリセット |

### テーブル別更新項目詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | |
| UPDATE | description | フォーム入力値 | |

#### project_settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | runner_registration_enabled | フォーム入力値 | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG001 | 成功 | Project '{project_name}' was successfully updated. | 更新成功時 |
| MSG002 | エラー | {バリデーションエラーメッセージ} | 更新失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| プロジェクトが存在しない | 404エラー画面を表示 |
| 管理者権限がない | 403アクセス拒否画面を表示 |
| プロジェクト名が空 | エラーメッセージを表示して再入力を促す |

## 備考

- 管理者向け編集画面では、通常のプロジェクト設定画面と比べて編集可能な項目が限定されている
- Runner登録を無効にすると、既存の登録トークンがリセットされる
- Runner登録設定は、システム全体の設定（Settings > CI/CD）で無効化されている場合は、チェックボックスが無効状態で表示される
- プロジェクトIDは参照用に表示されるが、変更することはできない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project.rb | `app/models/project.rb` | プロジェクトモデル、更新バリデーション |
| 1-2 | project_setting.rb | `app/models/project_setting.rb` | Runner登録設定 |

**読解のコツ**: 許可されるパラメータと関連設定の関係に注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | projects_controller.rb | `app/controllers/admin/projects_controller.rb` | edit/updateアクション |

**主要処理フロー**:
1. **47行目**: editアクション - 空のメソッド（ビューのレンダリングのみ）
2. **49-61行目**: updateアクション - Projects::UpdateServiceで更新
3. **53-55行目**: Runner登録無効時のトークンリセット
4. **90-95行目**: allowed_project_params - 許可されるパラメータ（限定的）

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | update_service.rb | `app/services/projects/update_service.rb` | プロジェクト更新ロジック |

**主要処理フロー**:
- プロジェクト属性の更新
- 関連設定の更新
- 失敗時のエラーハンドリング

#### Step 4: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | edit.html.haml | `app/views/admin/projects/edit.html.haml` | フォーム表示 |
| 4-2 | _form.html.haml | `app/views/admin/projects/_form.html.haml` | フォーム本体 |

**主要処理フロー**:
- **1-4行目** (edit): パンくずとページタイトル
- **6行目** (edit): ページヘッダー
- **7行目** (edit): フォームパーシャルの呼び出し

### プログラム呼び出し階層図

```
Admin::ProjectsController#edit
    │
    ├─ project (private method)
    │      └─ Project.find_by_full_path
    │
    └─ render view
           └─ edit.html.haml
                  └─ _form.html.haml

Admin::ProjectsController#update
    │
    ├─ project_params (private)
    │
    ├─ Projects::UpdateService.new.execute
    │      │
    │      └─ Project#update
    │
    ├─ (if runner_registration disabled)
    │      └─ Ci::Runners::ResetRegistrationTokenService.execute
    │
    └─ Success → redirect_to [:admin, @project]
       Failure → render "edit"
```

### データフロー図

```
[入力]               [処理]                    [出力]

namespace_id +       Project.find_by_full_path
project_id (URL) ───▶          │            ───▶ @project
                               │
                               ▼
                       edit.html.haml
                               │
                       [ユーザー入力]
                               │
                               ▼
Form Data ───▶ ProjectsController#update
                      │
                      ▼
         Projects::UpdateService.execute
                      │
                      ├─ Success ───▶ redirect + flash[:notice]
                      │
                      └─ Failure ───▶ render "edit" + errors
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| projects_controller.rb | `app/controllers/admin/projects_controller.rb` | コントローラ | リクエスト処理 |
| edit.html.haml | `app/views/admin/projects/edit.html.haml` | ビュー | フォーム表示 |
| _form.html.haml | `app/views/admin/projects/_form.html.haml` | パーシャル | フォーム本体 |
| update_service.rb | `app/services/projects/update_service.rb` | サービス | 更新ロジック |
| project.rb | `app/models/project.rb` | モデル | プロジェクトモデル |
| admin.rb | `config/routes/admin.rb` | ルート | URLルーティング定義 |
