# 画面設計書 239-組織一覧

## 概要

本ドキュメントは、GitLabの管理者向け組織一覧画面の設計仕様を定義する。

### 本画面の処理概要

この画面では、管理者がシステム内のすべての組織（Organization）を一覧表示することができる。Vue.jsベースのシングルページアプリケーション（SPA）として実装されている。

**業務上の目的・背景**：GitLabの組織（Organization）機能は、複数のグループやプロジェクトを包括的に管理するための上位階層として導入された機能である。システム管理者がインスタンス内のすべての組織を把握・管理するための画面であり、組織単位でのリソース管理や監査に使用される。この機能はフィーチャーフラグで制御されており、有効化されている場合のみアクセス可能。

**画面へのアクセス方法**：管理者エリア > 概要 > 組織、またはURL `/admin/organizations` に直接アクセス。サイドナビゲーションの「Admin Area」→「Overview」→「Organizations」からもアクセス可能。

**主要な操作・処理内容**：
1. 組織の一覧表示（名前、パス、作成日等）
2. 組織の検索
3. 個別組織の詳細画面への遷移

**画面遷移**：
- 遷移元：管理者ダッシュボード、サイドナビゲーション
- 遷移先：組織詳細画面

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能。フィーチャーフラグ`ui_for_organizations_enabled?`が有効な場合のみアクセスできる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 134 | 組織管理 | 主機能 | 管理者向け組織一覧の表示 |

## 画面種別

一覧

## URL/ルーティング

- URL: `/admin/organizations`
- ルート名: `admin_organizations_path`
- HTTPメソッド: GET
- コントローラ: `Admin::OrganizationsController#index`

## 入出力項目

| 項目名 | 種別 | 必須 | 説明 |
|--------|------|------|------|
| search | クエリパラメータ | 任意 | 組織名/パスの検索文字列 |
| page | クエリパラメータ | 任意 | ページ番号 |

## 表示項目

### 組織一覧

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| アバター | Image | 組織のアバター画像 |
| 組織名 | String | 組織の名前（リンク） |
| 組織パス | String | 組織のパス |
| 説明 | String | 組織の説明文 |
| グループ数 | Integer | 組織内のグループ数 |
| プロジェクト数 | Integer | 組織内のプロジェクト数 |
| ユーザー数 | Integer | 組織のユーザー数 |
| 作成日 | DateTime | 組織作成日時 |

### 統計情報

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 総組織数 | Integer | フィルター条件に合致する組織の総数 |

## イベント仕様

### 1-組織検索

検索フォームに文字列を入力して検索を実行すると、組織名またはパスに一致する組織のみが表示される。

### 2-組織詳細表示

組織名をクリックすると、その組織の詳細画面に遷移する。

### 3-ページネーション

ページネーションコントロールで次ページ/前ページに移動可能。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | organizations | SELECT | 組織一覧の取得 |
| 画面表示 | organization_users | SELECT | ユーザー数の取得 |

### テーブル別更新項目詳細

#### organizations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, path, description, avatar, created_at | 検索条件に基づく | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG001 | 情報 | No organizations found | 検索結果が0件の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 管理者権限がない | 403アクセス拒否画面を表示 |
| フィーチャーフラグが無効 | 403アクセス拒否画面を表示 |
| データベース接続エラー | 500エラー画面を表示 |

## 備考

- この画面はVue.jsベースのSPAとして実装されている（`#js-admin-organizations-index`）
- `admin_organizations_index_app_data`ヘルパーがフロントエンドアプリケーションに必要なデータを提供
- 組織機能はフィーチャーフラグ`ui_for_organizations_enabled?`で制御されている
- `organization_switching`フィーチャーフラグも画面表示時にプッシュされる
- 組織機能はGitLabの比較的新しい機能であり、将来的に拡張される可能性がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

組織モデルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | organization.rb | `app/models/organizations/organization.rb` | 組織モデルの属性とスコープ |

**読解のコツ**: 組織とグループ/プロジェクトの関係に注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | organizations_controller.rb | `app/controllers/admin/organizations_controller.rb` | indexアクションとフィーチャーフラグチェック |

**主要処理フロー**:
1. **9-12行目**: before_actionでフィーチャーフラグをチェック
2. **10-12行目**: organization_switchingフィーチャーフラグをプッシュ
3. **14行目**: indexアクション - 空のメソッド（ビューのレンダリングのみ）
4. **17-19行目**: check_feature_flag!でアクセス制御

#### Step 3: ビューとフロントエンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/admin/organizations/index.html.haml` | HAMLテンプレート |

**主要処理フロー**:
- **1行目**: ページタイトル設定
- **3行目**: Vue.jsアプリケーションのマウントポイントとデータ設定

### プログラム呼び出し階層図

```
HTTP GET /admin/organizations
    │
    ├─ before_action: check_feature_flag!
    │      │
    │      └─ ui_for_organizations_enabled? → access_denied! (if false)
    │
    ├─ before_action: push_frontend_feature_flag
    │      │
    │      └─ push_frontend_feature_flag(:organization_switching)
    │
    └─ Admin::OrganizationsController#index
           │
           └─ render view
                  │
                  └─ index.html.haml
                         │
                         └─ #js-admin-organizations-index (Vue.js SPA)
                                │
                                └─ admin_organizations_index_app_data (helper)
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTP GET ───▶ check_feature_flag! ───▶ (access_denied! or continue)
                      │
                      ▼
         OrganizationsController#index
                      │
                      ▼
                index.html.haml
                      │
                      ▼
              Vue.js App (SPA)
                      │
                      ▼
         GraphQL/REST API calls
                      │
                      ▼
              組織一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| organizations_controller.rb | `app/controllers/admin/organizations_controller.rb` | コントローラ | リクエスト処理 |
| index.html.haml | `app/views/admin/organizations/index.html.haml` | ビュー | メインビュー |
| organization.rb | `app/models/organizations/organization.rb` | モデル | 組織モデル |
| admin.rb | `config/routes/admin.rb` | ルート | URLルーティング定義 |
| organization_helper.rb | `app/helpers/organizations/organization_helper.rb` | ヘルパー | 組織関連ヘルパー |
