# 画面設計書 244-アプリケーション詳細

## 概要

本ドキュメントは、GitLab管理者がOAuthアプリケーションの詳細情報を確認する画面の設計書です。

### 本画面の処理概要

アプリケーション詳細画面は、登録済みOAuthアプリケーションの詳細情報（アプリケーションID、シークレット、スコープなど）を表示する管理者専用画面です。

**業務上の目的・背景**：OAuthアプリケーションを外部システムと連携する際、アプリケーションIDやクライアントシークレットなどの認証情報が必要になります。管理者はこの画面から認証情報を確認し、外部システムの設定に使用します。また、セキュリティ上の理由でシークレットを更新する機能も提供されます。

**画面へのアクセス方法**：
1. 管理者としてGitLabにログイン
2. 左サイドメニューから「Admin Area」をクリック
3. 「Applications」をクリック
4. 対象アプリケーション名をクリック

**主要な操作・処理内容**：
1. アプリケーション詳細情報の表示
2. クライアントシークレットの再生成（Renewボタン）
3. アプリケーション編集画面への遷移
4. アプリケーション削除
5. 一覧画面への戻り

**画面遷移**：
- 遷移元：アプリケーション一覧画面
- 遷移先：アプリケーション編集画面、アプリケーション一覧画面

**権限による表示制御**：管理者権限を持つユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 88 | OAuth2プロバイダ | 主機能 | OAuthアプリケーション詳細表示 |

## 画面種別

詳細

## URL/ルーティング

- URL: `/admin/applications/:id`
- HTTP メソッド: GET
- ルート名: `admin_application`

## 入出力項目

本画面は詳細表示のため、入力項目は限定的です。

| 項目名 | 項目ID | 型 | 操作 | 備考 |
|--------|--------|-----|------|------|
| シークレット再生成 | renew | ボタン | Renewボタン押下 | Ajax処理 |

## 表示項目

| 項目名 | 表示形式 | 備考 |
|--------|----------|------|
| ページタイトル | テキスト | "Application: {application_name}" |
| パンくずリスト | リンク | Applications > {application_name} |
| Application ID | テキスト | 読み取り専用 |
| Secret | テキスト | マスク表示、コピー機能 |
| Callback URLs | テキスト/リスト | 複数行対応 |
| Confidential | ラベル | Yes/No |
| Trusted | ラベル | Yes/No（管理者画面のみ） |
| Scopes | ラベル | 許可されたスコープ一覧 |
| Edit | ボタン | 編集画面へ |
| Renew secret | ボタン | シークレット再生成 |
| Delete | ボタン | 削除確認モーダル |

## イベント仕様

### 1-シークレット再生成（Renew secret）

**トリガー**: 「Renew secret」ボタンクリック

**処理フロー**:
1. 確認ダイアログ表示
2. 確認後、PUTリクエスト送信（`/admin/applications/:id/renew`）
3. `Admin::ApplicationsController#renew`アクション呼び出し
4. `@application.renew_secret`実行
5. 新しいシークレットをJSON形式で返却
6. 画面上のシークレット表示を更新

### 2-編集画面遷移

**トリガー**: 「Edit」ボタンクリック

**処理フロー**: アプリケーション編集画面へ遷移

### 3-アプリケーション削除

**トリガー**: 「Delete」ボタンクリック

**処理フロー**:
1. 確認モーダル表示
2. 確認後、DELETEリクエスト送信
3. アプリケーション削除
4. 一覧画面へリダイレクト

### 4-一覧画面への戻り

**トリガー**: パンくずリスト「Applications」クリック

**処理フロー**: アプリケーション一覧画面へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Renew secret押下 | oauth_applications | UPDATE | シークレット更新 |
| Delete押下 | oauth_applications | DELETE | レコード削除 |
| Delete押下 | oauth_access_tokens | DELETE | 関連トークン削除 |

### テーブル別更新項目詳細

#### oauth_applications

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | secret | 新規生成されたシークレット | ハッシュ化して保存 |
| UPDATE | updated_at | 現在日時 | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 成功 | Application was successfully destroyed. | 削除成功時 |
| MSG002 | 成功 | シークレット再生成成功 | Renew成功時（JSON応答） |
| MSG003 | エラー | シークレット再生成失敗 | Renew失敗時（JSON応答） |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|---------------|
| 権限不足 | 403エラー画面へリダイレクト | アクセスが拒否されました |
| アプリケーション未検出 | 404エラー画面表示 | ページが見つかりません |
| シークレット再生成エラー | 422エラー返却 | エラーメッセージ（JSON） |

## 備考

- シークレットは通常マスク表示され、クリックでコピー可能
- 新規作成直後は平文のシークレットが表示される（@created = true時）
- シークレット再生成はAjax処理で、ページリロードなしで完了
- Trusted行は管理者画面でのみ表示される（`show_trusted_row: true`）
- 共有パーシャル`shared/doorkeeper/applications/show`を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | oauth_application.rb | `app/models/authn/oauth_application.rb` | OAuthアプリケーションモデル |

**読解のコツ**:
- `Doorkeeper::Application`の継承
- シークレット関連メソッド（`secret_matches?`）

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | applications_controller.rb | `app/controllers/admin/applications_controller.rb` | show/renewアクション |

**主要処理フロー**:
1. **6行目**: `before_action :set_application`でアプリケーションロード
2. **17行目**: `show`アクション（空メソッド）
3. **46-54行目**: `renew`アクション - シークレット再生成
4. **71-73行目**: `set_application`メソッド

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/admin/applications/show.html.haml` | 詳細画面レイアウト |
| 3-2 | _show.html.haml | `app/views/shared/doorkeeper/applications/_show.html.haml` | 共有パーシャル |

**主要処理フロー**:
- **6-11行目**: パーシャル呼び出しとパス設定
- `show_trusted_row: true`で管理者用表示

#### Step 4: Renewアクションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | applications_controller.rb | `app/controllers/admin/applications_controller.rb` | renewアクション |

**主要処理フロー**:
- **47行目**: `@application.renew_secret`
- **49行目**: 成功時に新しいシークレットをJSONで返却
- **51行目**: 失敗時にエラー返却

### プログラム呼び出し階層図

```
ブラウザ (GET /admin/applications/:id)
    │
    ├─ before_action :set_application
    │      └─ ApplicationsFinder.new(id: params[:id]).execute
    │
    ├─ Admin::ApplicationsController#show
    │
    └─ View: admin/applications/show.html.haml
           └─ Partial: shared/doorkeeper/applications/_show
                  ├─ Application ID表示
                  ├─ Secret表示
                  ├─ Scopes表示
                  └─ アクションボタン

ブラウザ (PUT /admin/applications/:id/renew)
    │
    └─ Admin::ApplicationsController#renew
           ├─ @application.renew_secret
           ├─ @application.save
           └─ JSON response (secret or errors)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

アプリケーションID ───▶ ApplicationsController#show ──▶ 詳細HTML
                              │
                              └─ ApplicationsFinder

Renewボタン押下 ──────▶ ApplicationsController#renew ──▶ JSON (new secret)
                              │
                              ├─ renew_secret
                              └─ save
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| applications_controller.rb | `app/controllers/admin/applications_controller.rb` | コントローラ | リクエスト処理 |
| oauth_application.rb | `app/models/authn/oauth_application.rb` | モデル | データ定義 |
| show.html.haml | `app/views/admin/applications/show.html.haml` | ビュー | 詳細画面 |
| _show.html.haml | `app/views/shared/doorkeeper/applications/_show.html.haml` | パーシャル | 共有表示 |
| applications_finder.rb | `app/finders/applications_finder.rb` | ファインダー | クエリ |
| admin.rb | `config/routes/admin.rb` | 設定 | ルーティング |
