# 画面設計書 246-アプリケーション編集

## 概要

本ドキュメントは、GitLab管理者が既存OAuthアプリケーションの設定を編集する画面の設計書です。

### 本画面の処理概要

アプリケーション編集画面は、登録済みOAuthアプリケーションの設定（名前、リダイレクトURI、スコープなど）を変更する管理者専用画面です。

**業務上の目的・背景**：OAuthアプリケーションの運用中に、リダイレクトURLの変更、スコープの追加・削除、信頼設定の変更などが必要になることがあります。管理者はこの画面からアプリケーション設定を更新し、外部システムとの連携を適切に維持します。

**画面へのアクセス方法**：
1. 管理者としてGitLabにログイン
2. 左サイドメニューから「Admin Area」をクリック
3. 「Applications」をクリック
4. 対象アプリケーションの編集アイコン（鉛筆）をクリック

または、アプリケーション詳細画面から「Edit」ボタンをクリック

**主要な操作・処理内容**：
1. アプリケーション名の編集
2. リダイレクトURI（コールバックURL）の編集
3. Trusted オプションの変更
4. Confidential オプションの変更
5. OAuthスコープの変更
6. 「Save application」ボタンで保存

**画面遷移**：
- 遷移元：アプリケーション一覧画面、アプリケーション詳細画面
- 遷移先（成功時）：アプリケーション詳細画面
- 遷移先（失敗時）：本画面（エラーメッセージ表示）
- キャンセル時：アプリケーション一覧画面

**権限による表示制御**：管理者権限を持つユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 88 | OAuth2プロバイダ | 主機能 | OAuthアプリケーション編集 |

## 画面種別

編集

## URL/ルーティング

- URL: `/admin/applications/:id/edit`
- HTTP メソッド: GET（画面表示）/ PATCH/PUT（アプリケーション更新）
- ルート名: `edit_admin_application` / `admin_application`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | バリデーション | 備考 |
|--------|--------|-----|------|--------|----------------|------|
| Name | name | String | ○ | - | Doorkeeper標準 | アプリケーション名 |
| Redirect URI | redirect_uri | Text | ○ | - | URI形式 | 複数行対応 |
| Trusted | trusted | Boolean | - | - | - | 自動認可フラグ |
| Confidential | confidential | Boolean | - | - | - | 機密クライアントフラグ |
| Scopes | scopes | Array | ○ | - | 1つ以上必須 | OAuthスコープ |

## 表示項目

| 項目名 | 表示形式 | 備考 |
|--------|----------|------|
| ページタイトル | テキスト | "Edit application" |
| パンくずリスト | リンク | Applications > {application_name} > Edit |
| Web IDE OAuth警告 | アラート | Web IDE OAuthアプリの場合表示 |
| Name入力欄 | テキストフィールド | 既存値プリセット |
| Redirect URI入力欄 | テキストエリア | 既存値プリセット |
| Trustedチェックボックス | チェックボックス | 既存値プリセット |
| Confidentialチェックボックス | チェックボックス | 既存値プリセット |
| Scopesチェックボックス群 | チェックボックス | 既存値プリセット |

## イベント仕様

### 1-アプリケーション更新（Save application）

**トリガー**: 「Save application」ボタンクリック

**処理フロー**:
1. フォームデータのサーバー送信
2. `Admin::ApplicationsController#update`アクション呼び出し
3. `@application.update(application_params)`実行
4. バリデーション実行
5. 成功時: アプリケーション詳細画面へリダイレクト（成功メッセージ付き）
6. 失敗時: 本画面再表示（エラーメッセージ表示）

### 2-キャンセル

**トリガー**: 「Cancel」リンククリック

**処理フロー**: アプリケーション一覧画面へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Save application押下 | oauth_applications | UPDATE | アプリケーションレコード更新 |

### テーブル別更新項目詳細

#### oauth_applications

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | アプリケーション名 |
| UPDATE | redirect_uri | フォーム入力値 | リダイレクトURI |
| UPDATE | scopes | フォーム選択値 | スコープ文字列 |
| UPDATE | confidential | フォームチェック状態 | 機密フラグ |
| UPDATE | trusted | フォームチェック状態 | 信頼フラグ |
| UPDATE | updated_at | 現在日時 | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 成功 | Application was successfully updated. | 更新成功時 |
| MSG002 | エラー | Name can't be blank | 名前未入力時 |
| MSG003 | エラー | Redirect URI can't be blank | リダイレクトURI未入力時 |
| MSG004 | 警告 | Web IDE OAuth application設定に関する警告 | Web IDE OAuthアプリ編集時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|---------------|
| 権限不足 | 403エラー画面へリダイレクト | アクセスが拒否されました |
| アプリケーション未検出 | 404エラー画面表示 | ページが見つかりません |
| バリデーションエラー | 画面再表示 | 各フィールドにエラーメッセージ表示 |

## 備考

- Web IDE用OAuthアプリケーションを編集する際は警告コールアウトが表示される
- シークレットは本画面では変更不可（詳細画面のRenew機能を使用）
- 更新成功時は詳細画面にリダイレクト
- スコープ変更時は既存のアクセストークンに影響する可能性あり
- trustedパラメータは`permitted_params`でオーバーライド追加されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | oauth_application.rb | `app/models/authn/oauth_application.rb` | OAuthアプリケーションモデル |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | applications_controller.rb | `app/controllers/admin/applications_controller.rb` | edit/updateアクション |

**主要処理フロー**:
1. **6行目**: `before_action :set_application`でアプリケーションロード
2. **7行目**: `before_action :load_scopes`でスコープロード
3. **23行目**: `edit`アクション（空メソッド）
4. **38-44行目**: `update`アクション
5. **75-77行目**: `permitted_params`オーバーライド（trusted追加）

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | edit.html.haml | `app/views/admin/applications/edit.html.haml` | 編集画面レイアウト |
| 3-2 | _form.html.haml | `app/views/admin/applications/_form.html.haml` | 入力フォーム |

**主要処理フロー**:
- **6行目**: Web IDE OAuth警告コールアウト表示
- **9行目**: @url設定（PATCH先）
- **10行目**: フォームパーシャル呼び出し

### プログラム呼び出し階層図

```
ブラウザ (GET /admin/applications/:id/edit)
    │
    ├─ before_action :set_application
    │      └─ ApplicationsFinder.new(id: params[:id]).execute
    │
    ├─ before_action :load_scopes
    │
    ├─ Admin::ApplicationsController#edit
    │
    └─ View: admin/applications/edit.html.haml
           ├─ Web IDE OAuth Callout (条件付き)
           └─ Partial: admin/applications/_form
                  └─ 既存値プリセット

ブラウザ (PATCH /admin/applications/:id)
    │
    ├─ before_action :set_application
    │
    └─ Admin::ApplicationsController#update
           ├─ @application.update(application_params)
           ├─ 成功: redirect_to admin_application_path
           └─ 失敗: render :edit
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォームデータ ───────▶ ApplicationsController#update ──▶ 成功: 詳細画面
  - name                      │                              (フラッシュメッセージ)
  - redirect_uri              ├─ application_params
  - trusted                   ├─ @application.update
  - confidential              │     └─ バリデーション
  - scopes                    │
                              └───────────────────────▶ 失敗: 編集画面
                                                            (エラーメッセージ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| applications_controller.rb | `app/controllers/admin/applications_controller.rb` | コントローラ | リクエスト処理 |
| oauth_application.rb | `app/models/authn/oauth_application.rb` | モデル | データ定義 |
| edit.html.haml | `app/views/admin/applications/edit.html.haml` | ビュー | 編集画面 |
| _form.html.haml | `app/views/admin/applications/_form.html.haml` | ビュー | 入力フォーム |
| _web_ide_oauth_application_callout.html.haml | `app/views/admin/applications/_web_ide_oauth_application_callout.html.haml` | パーシャル | Web IDE警告 |
| admin.rb | `config/routes/admin.rb` | 設定 | ルーティング |
| oauth_applications.rb | `app/controllers/concerns/oauth_applications.rb` | Concern | 共通処理 |
