# 画面設計書 248-不正利用レポート詳細

## 概要

本ドキュメントは、GitLab管理者が不正利用レポートの詳細を確認し、対応アクションを実行する画面の設計書です。

### 本画面の処理概要

不正利用レポート詳細画面は、報告された不正利用の詳細情報を表示し、管理者が適切な対応（ユーザーのBAN、ブロック、信頼付与、削除など）を行うための画面です。

**業務上の目的・背景**：不正利用レポートを受け取った管理者は、報告内容を詳細に確認し、適切な対応を判断する必要があります。この画面では報告されたユーザーの情報、報告内容、類似レポート、過去の対応履歴などを確認でき、ワンクリックでユーザー対応アクションを実行できます。

**画面へのアクセス方法**：
1. 管理者としてGitLabにログイン
2. 左サイドメニューから「Admin Area」をクリック
3. 「Abuse reports」をクリック
4. 対象レポートをクリック

**主要な操作・処理内容**：
1. レポート詳細情報の表示
2. 報告されたユーザーのプロフィール表示
3. 報告されたコンテンツの表示
4. 類似レポートの確認
5. ユーザー対応アクション実行（BAN、ブロック、削除、信頼付与）
6. レポートのクローズ
7. レポートの削除

**画面遷移**：
- 遷移元：不正利用レポート一覧画面
- 遷移先：不正利用レポート一覧画面（アクション実行後）

**権限による表示制御**：管理者権限を持つユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 139 | 監査イベント | 主機能 | 不正利用レポート詳細表示・対応処理 |

## 画面種別

詳細

## URL/ルーティング

- URL: `/admin/abuse_reports/:id`
- HTTP メソッド: GET（表示）/ PUT（更新）/ DELETE（削除）
- ルート名: `admin_abuse_report`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 備考 |
|--------|--------|-----|------|------|
| ユーザーアクション | user_action | String | - | ban_user, block_user, delete_user, trust_user, close_report |
| クローズフラグ | close | Boolean | - | レポートを同時にクローズ |
| 理由 | reason | String | - | 対応理由 |
| コメント | comment | Text | - | 追加コメント |
| ユーザー削除フラグ | remove_user | Boolean | - | 削除時にユーザーも削除 |

## 表示項目

| 項目名 | 表示形式 | 備考 |
|--------|----------|------|
| ページタイトル | テキスト | ユーザー名 |
| パンくずリスト | リンク | Abuse reports > {user_name} |
| 報告対象ユーザー情報 | パネル | 名前、アバター、登録日等 |
| レポート詳細 | パネル | カテゴリ、メッセージ、報告日時等 |
| 報告されたコンテンツ | パネル | 該当コンテンツへのリンク |
| 類似レポート | リスト | 同一ユーザーの他レポート |
| 過去のクローズ済みレポート | リスト | 履歴表示 |
| アクションボタン | ボタン群 | BAN、ブロック、信頼、削除等 |

## イベント仕様

### 1-ユーザーBAN

**トリガー**: 「Ban user」ボタンクリック

**処理フロー**:
1. 確認ダイアログ/理由入力
2. `Admin::AbuseReportsController#moderate_user`へPUTリクエスト
3. `Admin::AbuseReports::ModerateUserService`実行
4. `Users::BanService`でユーザーBAN
5. レポートクローズ（オプション）
6. イベント記録

### 2-ユーザーブロック

**トリガー**: 「Block user」ボタンクリック

**処理フロー**:
1. 確認ダイアログ
2. `moderate_user`アクション呼び出し
3. `Users::BlockService`でユーザーブロック
4. レポートクローズ（オプション）

### 3-ユーザー削除

**トリガー**: 「Delete user」ボタンクリック

**処理フロー**:
1. 確認ダイアログ
2. `moderate_user`アクション呼び出し
3. `user.delete_async`で非同期削除
4. レポートクローズ

### 4-ユーザー信頼付与

**トリガー**: 「Trust user」ボタンクリック

**処理フロー**:
1. 確認ダイアログ
2. `moderate_user`アクション呼び出し
3. `Users::TrustService`で信頼付与
4. レポートクローズ（オプション）

### 5-レポートクローズ

**トリガー**: 「Close report」ボタンクリック

**処理フロー**:
1. 理由選択/コメント入力
2. `moderate_user`アクション呼び出し
3. レポートをclosed状態に更新
4. 類似オープンレポートも同時クローズ

### 6-レポート削除

**トリガー**: 「Delete report」ボタンクリック

**処理フロー**:
1. 確認ダイアログ
2. `Admin::AbuseReportsController#destroy`へDELETEリクエスト
3. レポート削除
4. オプションでユーザー削除

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ユーザーBAN | users | UPDATE | state更新 |
| ユーザーBAN | abuse_reports | UPDATE | status更新 |
| ユーザーBAN | abuse_report_events | INSERT | イベント記録 |
| ユーザーブロック | users | UPDATE | state更新 |
| ユーザー削除 | users | DELETE | ユーザー削除（非同期） |
| レポートクローズ | abuse_reports | UPDATE | status更新 |
| レポート削除 | abuse_reports | DELETE | レコード削除 |

### テーブル別更新項目詳細

#### abuse_reports

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | status | 'closed' | クローズ時 |
| DELETE | - | id = 指定ID | 削除時 |

#### abuse_report_events

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | action | アクション種別 | ban_user等 |
| INSERT | user_id | current_user.id | 実行者 |
| INSERT | reason | 選択理由 | 対応理由 |
| INSERT | comment | 入力コメント | 追加コメント |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 成功 | ユーザーがBANされました | BAN成功時 |
| MSG002 | 成功 | ユーザーがブロックされました | ブロック成功時 |
| MSG003 | 成功 | レポートがクローズされました | クローズ成功時 |
| MSG004 | エラー | Admin is required | 管理者権限なし |
| MSG005 | エラー | Action is required | アクション未指定 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|---------------|
| 権限不足 | 403エラー画面へリダイレクト | アクセスが拒否されました |
| レポート未検出 | 404エラー画面表示 | ページが見つかりません |
| アクション失敗 | 422エラー返却 | エラーメッセージ |

## 備考

- Vue.jsコンポーネント（`#js-abuse-reports-detail-view`）でレンダリング
- 類似レポート（同一ユーザー・同一カテゴリ）は自動検出され表示
- クローズ時は類似オープンレポートも同時クローズされる
- イベント記録は`ResourceEvents::AbuseReportEvent`に保存
- 対応理由は`ResourceEvents::AbuseReportEvent.reasons`で定義

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | abuse_report.rb | `app/models/abuse_report.rb` | AbuseReportモデル、関連メソッド |

**読解のコツ**:
- `remove_user`メソッドでユーザー削除処理確認
- `similar_open_reports_for_user`で類似レポート取得
- `past_closed_reports_for_user`で過去履歴取得

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | abuse_reports_controller.rb | `app/controllers/admin/abuse_reports_controller.rb` | show/moderate_user/destroyアクション |

**主要処理フロー**:
1. **7行目**: `before_action :find_abuse_report`でレポートロード
2. **13行目**: `show`アクション
3. **25-33行目**: `moderate_user`アクション - ModerateUserService呼び出し
4. **35-40行目**: `destroy`アクション

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | moderate_user_service.rb | `app/services/admin/abuse_reports/moderate_user_service.rb` | ユーザー対応ロジック |

**主要処理フロー**:
- **15-26行目**: `execute`メソッド - アクション実行・イベント記録
- **39-47行目**: `perform_action` - アクション種別に応じた処理分岐
- **73-78行目**: `close_similar_open_reports` - 類似レポート同時クローズ

#### Step 4: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | show.html.haml | `app/views/admin/abuse_reports/show.html.haml` | 詳細画面レイアウト |
| 4-2 | abuse_reports_helper.rb | `app/helpers/admin/abuse_reports_helper.rb` | データヘルパー |

**主要処理フロー**:
- **6行目**: Vue.jsコンポーネントマウントポイント
- `abuse_report_data`でシリアライズデータ生成

### プログラム呼び出し階層図

```
ブラウザ (GET /admin/abuse_reports/:id)
    │
    ├─ before_action :find_abuse_report
    │
    ├─ Admin::AbuseReportsController#show
    │
    └─ View: admin/abuse_reports/show.html.haml
           └─ Vue.js Component: #js-abuse-reports-detail-view

ブラウザ (PUT /admin/abuse_reports/:id/moderate_user)
    │
    ├─ before_action :find_abuse_report
    │
    └─ Admin::AbuseReportsController#moderate_user
           └─ Admin::AbuseReports::ModerateUserService
                  ├─ determine_action
                  ├─ perform_action
                  │      ├─ ban_user → Users::BanService
                  │      ├─ block_user → Users::BlockService
                  │      ├─ delete_user → user.delete_async
                  │      ├─ trust_user → Users::TrustService
                  │      └─ close_report
                  └─ close_report_and_record_event
```

### データフロー図

```
[入力]                    [処理]                         [出力]

アクション選択 ─────▶ AbuseReportsController ─────────▶ JSON応答
  - user_action           #moderate_user
  - close                      │
  - reason                     ├─ ModerateUserService
  - comment                    │      ├─ perform_action
                               │      └─ record_event
                               │
                               └─ ServiceResponse
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| abuse_reports_controller.rb | `app/controllers/admin/abuse_reports_controller.rb` | コントローラ | リクエスト処理 |
| abuse_report.rb | `app/models/abuse_report.rb` | モデル | データ定義 |
| moderate_user_service.rb | `app/services/admin/abuse_reports/moderate_user_service.rb` | サービス | 対応ロジック |
| show.html.haml | `app/views/admin/abuse_reports/show.html.haml` | ビュー | 詳細画面 |
| abuse_reports_helper.rb | `app/helpers/admin/abuse_reports_helper.rb` | ヘルパー | データシリアライズ |
| abuse_report_details_serializer.rb | `app/serializers/admin/abuse_report_details_serializer.rb` | シリアライザ | JSON変換 |
| ban_service.rb | `app/services/users/ban_service.rb` | サービス | BAN処理 |
| block_service.rb | `app/services/users/block_service.rb` | サービス | ブロック処理 |
| trust_service.rb | `app/services/users/trust_service.rb` | サービス | 信頼付与処理 |
