# 画面設計書 25-プロジェクト新規作成

## 概要

本ドキュメントは、GitLabのプロジェクト新規作成画面に関する設計書である。この画面はユーザーが新しいプロジェクトを作成するためのフォームを提供し、空のプロジェクト作成、テンプレートからの作成、外部サービスからのインポートなど複数の作成方法をサポートする。

### 本画面の処理概要

プロジェクト新規作成画面は、GitLabで新しいプロジェクトを作成するための包括的なインターフェースを提供する。ユーザーはプロジェクト名、パス、可視性レベルなどの基本情報を入力し、オプションでREADMEの初期化やCI/CD設定を含めることができる。

**業務上の目的・背景**：ソフトウェア開発プロジェクトの開始点として、プロジェクト作成は最も基本的な機能である。この画面では、空のプロジェクト作成だけでなく、ベストプラクティスを含むテンプレートからの作成、GitHub/Bitbucket等からのインポート機能も提供し、様々なワークフローに対応している。適切な可視性設定により、セキュリティとコラボレーションのバランスを取ることができる。

**画面へのアクセス方法**：
- ナビゲーションバーの「+」メニューから「New project」を選択
- ダッシュボードの「New project」ボタンをクリック
- 直接URL `/projects/new` にアクセス
- グループ内から「New project」を選択（namespace_idが設定される）

**主要な操作・処理内容**：
1. 空のプロジェクト作成 - プロジェクト名、パス、可視性を設定して作成
2. テンプレートからの作成 - 定義済みテンプレートを選択して作成
3. 外部サービスからのインポート - GitHub、Bitbucket、GitLab等からインポート
4. README/SAST/Secret Detection初期化 - セキュリティ機能の初期設定
5. SHA256リポジトリ形式の選択（フィーチャーフラグ有効時）

**画面遷移**：
- 遷移元：ダッシュボード、グループ詳細、ナビゲーションメニュー
- 遷移先：作成成功時はプロジェクト詳細画面、インポート時はインポート状態画面

**権限による表示制御**：
- 未ログインユーザー：アクセス不可（ログイン必須）
- ログインユーザー：自身の名前空間へのプロジェクト作成
- グループメンバー：`create_projects`権限があるグループへの作成
- プロジェクト数制限：ユーザーの`projects_limit`による制限

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | プロジェクト作成 | 主機能 | 新規プロジェクトの作成処理 |
| 7 | プロジェクトフォーク | 補助機能 | フォークオプションの選択 |

## 画面種別

登録

## URL/ルーティング

- URL: `/projects/new`
- ルーティング: `config/routes.rb` - `resources :projects`
- コントローラ: `ProjectsController#new`, `ProjectsController#create`

## 入出力項目

| 項目名 | 入力/出力 | 必須 | データ型 | 説明 |
|--------|----------|------|----------|------|
| namespace_id | 入力 | - | Integer | 作成先の名前空間ID（グループまたはユーザー） |
| name | 入力 | 必須 | String | プロジェクト名 |
| path | 入力 | 必須 | String | プロジェクトパス（URL用） |
| description | 入力 | - | Text | プロジェクトの説明 |
| visibility_level | 入力 | 必須 | Enum | public/internal/private |
| initialize_with_readme | 入力 | - | Boolean | READMEを初期化 |
| initialize_with_sast | 入力 | - | Boolean | SASTを初期化 |
| initialize_with_secret_detection | 入力 | - | Boolean | シークレット検出を初期化 |
| template_name | 入力 | - | String | テンプレート名 |
| import_url | 入力 | - | String | インポート元URL |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 名前空間セレクター | Select | プロジェクト作成先の名前空間選択 |
| プロジェクト名入力 | Input | プロジェクト名の入力フィールド |
| プロジェクトパス入力 | Input | URLパスの入力フィールド |
| 可視性ラジオボタン | Radio | public/internal/private選択 |
| テンプレート一覧 | List | 利用可能なプロジェクトテンプレート |
| インポートオプション | List | 利用可能なインポートソース |
| ガイドライン | Text | プロジェクト作成ガイドライン（管理者設定） |

## イベント仕様

### 1-ページ読み込み

1. `ProjectsController#new` が呼び出される
2. `namespace_id`パラメータがある場合、名前空間を取得
3. 名前空間への`create_projects`権限チェック
4. 利用可能なグループの取得（`Groups::AcceptingProjectCreationsFinder`）
5. 新規Projectオブジェクトを初期化
6. フィーチャーフラグに応じたビューをレンダリング

### 2-プロジェクト作成（空のプロジェクト）

1. `ProjectsController#create` が呼び出される
2. `Projects::CreateService` でプロジェクト作成
3. 成功時：プロジェクト詳細画面にリダイレクト
4. 失敗時：エラーメッセージを表示して`new`を再レンダリング

### 3-テンプレートからの作成

1. テンプレートタブでテンプレートを選択
2. テンプレート選択後、プロジェクト情報を入力
3. 作成処理でテンプレートコンテンツをコピー

### 4-インポート

- 各インポートソースのボタンをクリック
- 対応するインポート画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| プロジェクト作成 | projects | INSERT | プロジェクトレコード作成 |
| プロジェクト作成 | project_features | INSERT | 機能設定の初期化 |
| プロジェクト作成 | project_settings | INSERT | プロジェクト設定の初期化 |
| プロジェクト作成 | namespaces | SELECT | 名前空間情報の取得 |
| プロジェクト作成 | users | SELECT/UPDATE | ユーザー情報とプロジェクト数更新 |

### テーブル別更新項目詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 入力値 | プロジェクト名 |
| INSERT | path | 入力値 | URLパス |
| INSERT | namespace_id | 入力値または current_user.namespace_id | 名前空間 |
| INSERT | visibility_level | 入力値 | 可視性レベル |
| INSERT | creator_id | current_user.id | 作成者 |
| INSERT | description | 入力値 | 説明（オプション） |

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 | 表示条件 |
|------|------------|--------------|---------|
| 成功 | project_created | Project '%{project_name}' was successfully created. | 作成成功時 |
| エラー | access_denied | You don't have permission to create projects | 権限なしの場合 |
| 情報 | no_import_options | No import options available | インポートが無効の場合 |
| 情報 | contact_admin | Contact an administrator to enable options for importing your project | インポート無効時の案内 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 名前空間が存在しない | 404エラーまたはアクセス拒否 |
| 作成権限がない | アクセス拒否（access_denied!） |
| プロジェクト数制限超過 | バリデーションエラー表示 |
| 名前/パスが重複 | バリデーションエラー表示 |
| インポートURLが無効 | バリデーションエラー表示 |

## 備考

- `new_project_creation_form`フィーチャーフラグでVue.js版UIを切り替え
- `support_sha256_repositories`フィーチャーフラグでSHA256形式を選択可能
- 管理者設定の`brand_new_project_guidelines`でガイドラインを表示
- `push_to_create_project_command`でGitコマンドでの作成方法を案内
- インポートソースは管理者設定で有効/無効を制御

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プロジェクト作成に関連するモデルとサービスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project.rb | `app/models/project.rb` | Projectモデル、バリデーション |
| 1-2 | create_service.rb | `app/services/projects/create_service.rb` | プロジェクト作成ロジック |

**読解のコツ**: `Projects::CreateService#execute`メソッドで作成処理の全体フローを把握する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | projects_controller.rb | `app/controllers/projects_controller.rb` | new/createアクション |

**主要処理フロー**:
1. **93-106行目**: `new` アクション
2. **94行目**: `namespace_id`から名前空間取得
3. **95行目**: 権限チェック
4. **99-101行目**: 利用可能グループの取得
5. **105行目**: Projectオブジェクト初期化
6. **114-125行目**: `create` アクション
7. **115行目**: `Projects::CreateService`呼び出し
8. **117-123行目**: 成功/失敗時の処理分岐

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/projects/new.html.haml` | メインビュー |
| 3-2 | _new_project_fields.html.haml | `app/views/projects/_new_project_fields.html.haml` | 入力フォームフィールド |
| 3-3 | _project_templates.html.haml | `app/views/projects/_project_templates.html.haml` | テンプレート選択 |
| 3-4 | _import_project_pane.html.haml | `app/views/projects/_import_project_pane.html.haml` | インポートオプション |

**主要処理フロー**:
- **8-49行目（new.html.haml）**: フィーチャーフラグによるVue.js版/従来版の切り替え
- **9-48行目（new.html.haml）**: Vue.js版のdata属性設定
- **66-91行目（new.html.haml）**: 従来版のタブパネル構成

### プログラム呼び出し階層図

```
ProjectsController#new
    │
    ├─ Namespace.find_by(id: params[:namespace_id])
    │
    ├─ can?(current_user, :create_projects, @namespace)
    │      └─ access_denied!
    │
    ├─ Groups::AcceptingProjectCreationsFinder.new(current_user).execute
    │
    └─ Project.new(namespace_id: @namespace&.id)

ProjectsController#create
    │
    └─ Projects::CreateService.new(current_user, project_params).execute
           │
           ├─ Project.new
           │
           ├─ プロジェクトバリデーション
           │
           ├─ Gitリポジトリ作成
           │
           ├─ project_features作成
           │
           ├─ project_settings作成
           │
           └─ READMEファイル作成（オプション）
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───▶ ProjectsController#create ───▶ @project
    │                     │
    ├─ name              ├─ Projects::CreateService
    ├─ path              │      │
    ├─ visibility_level  │      ├─ Project.create
    ├─ namespace_id      │      │
    └─ options           │      ├─ Gitリポジトリ初期化
                         │      │
                         │      └─ 関連レコード作成
                         │
                         └─────────────────▶ リダイレクト/エラー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| projects_controller.rb | `app/controllers/projects_controller.rb` | コントローラ | リクエストハンドリング |
| new.html.haml | `app/views/projects/new.html.haml` | テンプレート | メインビュー |
| _new_project_fields.html.haml | `app/views/projects/_new_project_fields.html.haml` | パーシャル | 入力フォーム |
| _project_templates.html.haml | `app/views/projects/_project_templates.html.haml` | パーシャル | テンプレート選択 |
| _import_project_pane.html.haml | `app/views/projects/_import_project_pane.html.haml` | パーシャル | インポートオプション |
| create_service.rb | `app/services/projects/create_service.rb` | サービス | 作成ビジネスロジック |
| project.rb | `app/models/project.rb` | モデル | Projectモデル |
| accepting_project_creations_finder.rb | `app/finders/groups/accepting_project_creations_finder.rb` | ファインダー | 作成可能グループ検索 |
