# 画面設計書 251-ブロードキャストメッセージ編集

## 概要

本ドキュメントは、GitLab管理者向けブロードキャストメッセージ編集画面の設計書です。既存のブロードキャストメッセージの内容を編集し、ユーザーに表示されるシステム通知を更新するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：ブロードキャストメッセージは、システム管理者がGitLabインスタンス全体のユーザーに対して重要な通知（メンテナンス予定、システム変更、お知らせなど）を表示するための機能です。この編集画面では、既に作成されたメッセージの内容、表示期間、対象ユーザー、テーマなどを変更することができます。運用中のメッセージ内容を修正したり、表示期間を延長・短縮したりする際に使用されます。

**画面へのアクセス方法**：管理者エリア（Admin Area）のナビゲーションから「Messages」を選択し、ブロードキャストメッセージ一覧画面から編集したいメッセージの「Edit」ボタンをクリックしてアクセスします。URLパターンは `/admin/broadcast_messages/:id/edit` です。

**主要な操作・処理内容**：
1. メッセージ本文の編集（Markdown形式対応）
2. メッセージタイプの変更（バナー/通知）
3. テーマ（色）の変更（indigo, blue, green, red, dark, lightなど10種類）
4. 表示開始日時・終了日時の変更
5. 対象パス（特定のURLパスにのみ表示）の設定
6. 対象アクセスレベル（Guest, Reporter, Developer, Maintainer, Owner）の設定
7. 解除可能フラグ（ユーザーがメッセージを閉じられるか）の設定
8. CLI表示フラグの設定
9. プレビュー機能でメッセージの見た目を確認

**画面遷移**：
- 遷移元：ブロードキャストメッセージ一覧画面（/admin/broadcast_messages）
- 遷移先：保存成功時はブロードキャストメッセージ一覧画面へリダイレクト、保存失敗時は編集画面に留まりエラー表示

**権限による表示制御**：管理者権限（Admin）を持つユーザーのみがこの画面にアクセス可能です。非管理者がアクセスしようとすると、アクセス拒否画面にリダイレクトされます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 118 | ブロードキャストメッセージ | 主機能 | ブロードキャストメッセージの編集処理 |

## 画面種別

編集

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|----------|
| GET | /admin/broadcast_messages/:id/edit | 編集画面表示 |
| PUT/PATCH | /admin/broadcast_messages/:id | 更新処理 |

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|----------|------|
| メッセージ本文 | message | Text | ○ | 入力 | Markdown形式で記述可能な通知メッセージ本文 |
| メッセージタイプ | broadcast_type | Enum | ○ | 入力 | banner（バナー）または notification（通知） |
| テーマ | theme | Enum | ○ | 入力 | indigo, light-indigo, blue, light-blue, green, light-green, red, light-red, dark, lightから選択 |
| 開始日時 | starts_at | DateTime | ○ | 入力 | メッセージ表示開始日時 |
| 終了日時 | ends_at | DateTime | ○ | 入力 | メッセージ表示終了日時 |
| 対象パス | target_path | String | - | 入力 | 特定URLパスへの表示制限（ワイルドカード対応） |
| 対象アクセスレベル | target_access_levels | Array | - | 入力 | 特定ロールのユーザーへの表示制限 |
| 解除可能 | dismissable | Boolean | - | 入力 | ユーザーがメッセージを閉じられるか |
| CLI表示 | show_in_cli | Boolean | - | 入力 | CLIからのアクセス時にも表示するか |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| パンくずリスト | ヘッダー下 | Messages > {メッセージID} > Edit |
| ページタイトル | 上部 | "Broadcast Messages" |
| プレビューエリア | フォーム上部 | 編集中メッセージのプレビュー表示 |
| フォーム入力エリア | 中央 | 各入力項目のフォーム |

## イベント仕様

### 1-保存ボタン押下

**処理フロー**:
1. フォームデータをサーバーに送信（PUT/PATCH）
2. バリデーション実行（message, starts_at, ends_at, broadcast_type必須チェック）
3. バリデーション成功時：DBを更新し、Redisキャッシュをフラッシュ
4. 一覧画面へリダイレクト（成功通知表示）
5. バリデーション失敗時：編集画面に留まりエラーメッセージ表示

### 2-プレビューボタン押下

**処理フロー**:
1. 現在の入力内容でプレビューAPIを呼び出し（POST /admin/broadcast_messages/preview）
2. レンダリングされたHTMLを取得
3. プレビューエリアに表示

### 3-キャンセルボタン押下

**処理フロー**:
1. 一覧画面へリダイレクト（変更は破棄）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | system_broadcast_messages | UPDATE | メッセージ情報の更新 |

### テーブル別更新項目詳細

#### system_broadcast_messages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | message | フォーム入力値 | Markdown形式 |
| UPDATE | broadcast_type | フォーム入力値 | 1: banner, 2: notification |
| UPDATE | theme | フォーム入力値 | 0-9の整数値 |
| UPDATE | starts_at | フォーム入力値 | |
| UPDATE | ends_at | フォーム入力値 | |
| UPDATE | target_path | フォーム入力値 | NULLable |
| UPDATE | target_access_levels | フォーム入力値 | 配列形式 |
| UPDATE | dismissable | フォーム入力値 | |
| UPDATE | show_in_cli | フォーム入力値 | |
| UPDATE | cached_markdown_version | 自動計算 | |
| UPDATE | message_html | 自動生成 | Markdownレンダリング結果 |
| UPDATE | updated_at | 現在時刻 | |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| MSG-001 | Broadcast Message was successfully updated. | 更新成功時 | 成功 |
| MSG-002 | {フィールド名} can't be blank | 必須項目未入力時 | エラー |
| MSG-003 | {フィールド名} is invalid | バリデーションエラー時 | エラー |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| メッセージが存在しない | 404 Not Foundエラー画面を表示 |
| 権限不足 | 403 Forbiddenエラー画面を表示 |
| サーバーエラー | 500エラー画面を表示 |

## 備考

- メッセージはMarkdown形式で入力可能で、特定のHTMLタグも許可されている
- target_access_levelsには Guest(10), Planner(15), Reporter(20), Developer(30), Maintainer(40), Owner(50) が指定可能
- 更新後はRedisキャッシュ（CACHE_KEY, BANNER_CACHE_KEY, NOTIFICATION_CACHE_KEY）が自動的にクリアされる
- 本画面はJavaScript（Vue.js）コンポーネント（js-broadcast-message）で実装されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ブロードキャストメッセージのデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | broadcast_message.rb | `app/models/system/broadcast_message.rb` | enum定義（theme, broadcast_type）、バリデーション、キャッシュ機構を確認 |

**読解のコツ**: `enum :theme` と `enum :broadcast_type` の定義を確認し、どのような値が許可されているかを把握する。`ALLOWED_TARGET_ACCESS_LEVELS` 定数で対象アクセスレベルの許可値を確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | broadcast_messages_controller.rb | `app/controllers/admin/broadcast_messages_controller.rb` | edit/updateアクションの処理フロー |

**主要処理フロー**:
1. **17行目**: `edit` アクション - 空の実装、`before_action`でメッセージ取得
2. **41-59行目**: `update` アクション - JSON/HTML両形式対応、成功/失敗時の処理分岐
3. **78-79行目**: `find_broadcast_message` - IDでメッセージを取得
4. **86-98行目**: `broadcast_message_params` - 許可パラメータの定義

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | edit.html.haml | `app/views/admin/broadcast_messages/edit.html.haml` | Vue.jsコンポーネントへのデータ受け渡し |

**主要処理フロー**:
- **6行目**: `#js-broadcast-message` - Vue.jsコンポーネントのマウントポイント
- `broadcast_message_data(@broadcast_message)` ヘルパーでデータを準備

#### Step 4: ヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | broadcast_messages_helper.rb | `app/helpers/admin/broadcast_messages_helper.rb` | `broadcast_message_data` メソッドの実装 |

**主要処理フロー**:
- **86-102行目**: `broadcast_message_data` - Vue.jsコンポーネントに渡すデータ構造

### プログラム呼び出し階層図

```
edit.html.haml
    │
    ├─ BroadcastMessagesController#edit
    │      └─ find_broadcast_message (before_action)
    │             └─ System::BroadcastMessage.find
    │
    └─ broadcast_message_data (Helper)
           └─ target_access_level_options
                  └─ Gitlab::Access.human_access

[保存時]
BroadcastMessagesController#update
    │
    ├─ broadcast_message_params (Strong Parameters)
    │
    ├─ @broadcast_message.update
    │      └─ System::BroadcastMessage (ActiveRecord)
    │             ├─ validations
    │             ├─ cache_markdown_field
    │             └─ after_commit: flush_redis_cache
    │
    └─ redirect_to / render
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ブラウザ                  Rails Controller
(フォーム送信) ──────────▶ BroadcastMessagesController  ──────────▶ DB更新
                              │                                      │
                              ▼                                      ▼
                         Strong Parameters              system_broadcast_messages
                              │                                      │
                              ▼                                      ▼
                         Model#update                   Redis Cache Flush
                              │                                      │
                              ▼                                      ▼
                         Validations                    Redirect to Index
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| broadcast_messages_controller.rb | `app/controllers/admin/broadcast_messages_controller.rb` | コントローラー | リクエスト処理 |
| broadcast_message.rb | `app/models/system/broadcast_message.rb` | モデル | データ層・バリデーション |
| edit.html.haml | `app/views/admin/broadcast_messages/edit.html.haml` | ビュー | 画面テンプレート |
| broadcast_messages_helper.rb | `app/helpers/admin/broadcast_messages_helper.rb` | ヘルパー | ビュー用ヘルパー |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義（106-108行目） |
