# 画面設計書 252-Webhook一覧

## 概要

本ドキュメントは、GitLab管理者向けシステムWebhook一覧画面の設計書です。GitLabインスタンス全体に対するシステムフック（Webhook）の設定・管理を行うための画面です。

### 本画面の処理概要

**業務上の目的・背景**：システムWebhook（System Hooks）は、GitLabインスタンス全体で発生するイベント（プロジェクト作成、ユーザー追加、リポジトリ更新など）を外部システムに通知するための機能です。CI/CDパイプライン連携、監査システム連携、自動化ツール連携などの用途で使用されます。この一覧画面では、登録されているすべてのシステムWebhookを確認し、新規追加や既存設定の管理を行います。

**画面へのアクセス方法**：管理者エリア（Admin Area）のナビゲーションから「System Hooks」を選択してアクセスします。URLは `/admin/hooks` です。GitLab.comでは利用できない機能のため、セルフホスト環境でのみ表示されます。

**主要な操作・処理内容**：
1. 登録済みシステムWebhookの一覧表示
2. 新規システムWebhookの追加
3. Webhook名、説明、URL、シークレットトークンの設定
4. トリガーイベントの選択（リポジトリ更新、Push、Tag Push、マージリクエスト）
5. SSL検証の有効/無効設定
6. 登録済みWebhookのテスト実行
7. Webhookの削除

**画面遷移**：
- 遷移元：管理者ダッシュボード、管理者メニュー
- 遷移先：Webhook編集画面（/admin/hooks/:id/edit）

**権限による表示制御**：管理者権限（Admin）を持つユーザーのみがこの画面にアクセス可能です。GitLab.comでは非表示となります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 94 | システムWebhook | 主機能 | システムWebhookの一覧表示・新規追加 |

## 画面種別

一覧 / 登録

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|----------|
| GET | /admin/hooks | 一覧表示 |
| POST | /admin/hooks | 新規登録 |
| DELETE | /admin/hooks/:id | 削除 |

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|----------|------|
| 名前 | name | String | - | 入力 | Webhookの識別名（任意） |
| 説明 | description | Text | - | 入力 | Webhookの説明文（最大2048文字） |
| URL | url | String | ○ | 入力 | Webhook送信先URL |
| シークレットトークン | token | String | - | 入力 | ペイロード検証用トークン |
| リポジトリ更新イベント | repository_update_events | Boolean | - | 入力 | リポジトリ更新時に通知（デフォルトON） |
| Pushイベント | push_events | Boolean | - | 入力 | Push時に通知（デフォルトOFF） |
| Tag Pushイベント | tag_push_events | Boolean | - | 入力 | タグPush時に通知 |
| マージリクエストイベント | merge_requests_events | Boolean | - | 入力 | MRイベント時に通知（デフォルトOFF） |
| SSL検証 | enable_ssl_verification | Boolean | - | 入力 | SSL証明書の検証を有効化 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| ページタイトル | ヘッダー | "System hooks" |
| 説明文 | タイトル下 | システムフックの説明とヘルプリンク |
| Webhook一覧 | 中央 | 登録済みWebhookのリスト |
| 新規追加フォーム | 下部 | 折りたたみ式の新規登録フォーム |
| File Hooks情報 | 最下部 | ファイルフックの説明（該当する場合） |

## イベント仕様

### 1-新規Webhook追加ボタン押下

**処理フロー**:
1. 「Add new webhook」トグルボタンで入力フォームを表示
2. 必要項目を入力
3. 「Add webhook」ボタンでサーバーに送信（POST）
4. バリデーション成功時：DBに保存し一覧を更新
5. バリデーション失敗時：エラーメッセージを表示

### 2-テストボタン押下

**処理フロー**:
1. POST /admin/hooks/:id/test を実行
2. TestHooks::SystemServiceを呼び出し
3. テスト結果をフラッシュメッセージで表示
4. 一覧画面にリダイレクト

### 3-削除ボタン押下

**処理フロー**:
1. 確認ダイアログを表示
2. 確認後、DELETE /admin/hooks/:id を実行
3. DBからWebhookを削除
4. 一覧を更新

### 4-編集リンク押下

**処理フロー**:
1. /admin/hooks/:id/edit にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規追加 | web_hooks | INSERT | 新規Webhookレコード作成 |
| 削除 | web_hooks | DELETE | Webhookレコード削除 |
| 削除 | web_hook_logs | DELETE | 関連ログレコード削除 |

### テーブル別更新項目詳細

#### web_hooks (type: SystemHook)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | type | 'SystemHook' | STI識別子 |
| INSERT | name | フォーム入力値 | |
| INSERT | description | フォーム入力値 | |
| INSERT | url | フォーム入力値 | |
| INSERT | token | フォーム入力値 | 暗号化保存 |
| INSERT | repository_update_events | フォーム入力値 | デフォルトtrue |
| INSERT | push_events | フォーム入力値 | デフォルトfalse |
| INSERT | tag_push_events | フォーム入力値 | |
| INSERT | merge_requests_events | フォーム入力値 | デフォルトfalse |
| INSERT | enable_ssl_verification | フォーム入力値 | |
| INSERT | organization_id | Current.organization.id | 必須 |
| INSERT | created_at | 現在時刻 | |
| INSERT | updated_at | 現在時刻 | |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| MSG-001 | Hook was successfully created. | 新規作成成功時 | 成功 |
| MSG-002 | Hook was successfully deleted. | 削除成功時 | 成功 |
| MSG-003 | Hook executed successfully: HTTP {status} | テスト成功時 | 成功 |
| MSG-004 | Hook execution failed: {error} | テスト失敗時 | エラー |
| MSG-005 | URL can't be blank | URL未入力時 | エラー |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| GitLab.com環境 | 404 Not Found（機能非表示） |
| 権限不足 | 403 Forbidden |
| サーバーエラー | 500エラー画面を表示 |

## 備考

- システムWebhookはGitLab.comでは利用不可（セルフホスト環境専用）
- URLは `allow_local_requests_from_system_hooks?` 設定によりローカルアドレスも許可可能
- シークレットトークンは表示時にマスクされる
- テスト実行時は指定されたtriggerパラメータに基づきダミーイベントを送信

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、SystemHookのデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | system_hook.rb | `app/models/hooks/system_hook.rb` | 利用可能なフック種別、デフォルト値、バリデーション |

**読解のコツ**: `AVAILABLE_HOOKS` 定数で利用可能なトリガー種別を確認。`triggerable_hooks` メソッドでトリガー設定の仕組みを理解する。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | hooks_controller.rb | `app/controllers/admin/hooks_controller.rb` | HookActionsモジュールのinclude、testアクション |
| 2-2 | hook_actions.rb | `app/controllers/concerns/web_hooks/hook_actions.rb` | index/create/edit/update/destroyの共通実装 |

**主要処理フロー**:
1. **8行目**: `before_action :not_found` - GitLab.comでは非表示
2. **10-15行目**: `test` アクション - Webhookのテスト実行
3. **20-21行目**: `relation` メソッド - SystemHookを返す

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/admin/hooks/index.html.haml` | 共有パーシャルの呼び出し |
| 3-2 | _index.html.haml | `app/views/shared/web_hooks/_index.html.haml` | Webhook一覧UI実装 |
| 3-3 | _form.html.haml | `app/views/admin/hooks/_form.html.haml` | システムフック専用フォーム |

**主要処理フロー**:
- **3-7行目**: `SettingsSectionComponent` でレイアウト構成
- 共有パーシャル `shared/web_hooks/index` で一覧表示

#### Step 4: 共有コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | _hook.html.haml | `app/views/shared/web_hooks/_hook.html.haml` | 個別Webhook表示 |
| 4-2 | _description.html.haml | `app/views/shared/web_hooks/_description.html.haml` | 説明文表示 |

### プログラム呼び出し階層図

```
index.html.haml
    │
    ├─ Admin::HooksController#index
    │      └─ WebHooks::HookActions#index (concern)
    │             └─ relation (SystemHook)
    │
    ├─ SettingsSectionComponent
    │      └─ shared/web_hooks/_index
    │             ├─ CrudComponent (一覧表示)
    │             │      └─ shared/web_hooks/_hook (各Webhook)
    │             │
    │             └─ gitlab_ui_form_for (新規登録フォーム)
    │                    └─ admin/hooks/_form
    │
    └─ shared/file_hooks/_index (ファイルフック情報)

[新規登録時]
Admin::HooksController#create
    │
    └─ WebHooks::HookActions#create
           └─ SystemHook.new.save

[テスト時]
Admin::HooksController#test
    │
    └─ TestHooks::SystemService#execute
           └─ WebHook#execute (HTTPリクエスト送信)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ブラウザ                  Rails Controller
(フォーム送信) ──────────▶ Admin::HooksController   ──────────▶ DB更新
                              │                                    │
                              ▼                                    ▼
                         HookActions concern              web_hooks テーブル
                              │                                    │
                              ▼                                    ▼
                         SystemHook Model                一覧画面に表示
                              │
                              ▼
                         Validations

[テスト実行]
テストボタン ─────────────▶ test action ─────────────────▶ 外部URL
                              │                              │
                              ▼                              ▼
                         SystemService              HTTP Response
                              │                              │
                              ▼                              ▼
                         WebHookLog                 結果表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| hooks_controller.rb | `app/controllers/admin/hooks_controller.rb` | コントローラー | リクエスト処理 |
| hook_actions.rb | `app/controllers/concerns/web_hooks/hook_actions.rb` | Concern | 共通アクション |
| system_hook.rb | `app/models/hooks/system_hook.rb` | モデル | データ層 |
| index.html.haml | `app/views/admin/hooks/index.html.haml` | ビュー | メインテンプレート |
| _form.html.haml | `app/views/admin/hooks/_form.html.haml` | ビュー | フォームパーシャル |
| _index.html.haml | `app/views/shared/web_hooks/_index.html.haml` | ビュー | 共有一覧パーシャル |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義（94-104行目） |
