# 画面設計書 253-Webhook編集

## 概要

本ドキュメントは、GitLab管理者向けシステムWebhook編集画面の設計書です。既存のシステムWebhookの設定を変更し、Webhookログの確認を行うための画面です。

### 本画面の処理概要

**業務上の目的・背景**：システムWebhookの運用において、送信先URLの変更、トリガーイベントの追加・削除、SSL検証設定の変更などが必要になる場合があります。また、Webhookの動作確認や障害調査のために、過去の実行ログを確認する必要もあります。この編集画面では、Webhook設定の変更とログ確認を一画面で行うことができます。

**画面へのアクセス方法**：管理者エリアのSystem Hooks一覧画面（/admin/hooks）から編集したいWebhookの「Edit」ボタンをクリックしてアクセスします。URLパターンは `/admin/hooks/:id/edit` です。

**主要な操作・処理内容**：
1. Webhook設定の編集（名前、説明、URL、トークン、トリガー、SSL検証）
2. 設定の保存
3. Webhookのテスト実行
4. Webhookの削除
5. 過去の実行ログ（Hook Logs）の確認
6. 実行ログの再送信

**画面遷移**：
- 遷移元：Webhook一覧画面（/admin/hooks）
- 遷移先：保存成功時は編集画面に留まる、削除時は一覧画面へ、ログ詳細は /admin/hooks/:hook_id/hook_logs/:id

**権限による表示制御**：管理者権限（Admin）を持つユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 94 | システムWebhook | 主機能 | システムWebhookの編集・テスト・ログ確認 |

## 画面種別

編集

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|----------|
| GET | /admin/hooks/:id/edit | 編集画面表示 |
| PUT/PATCH | /admin/hooks/:id | 更新処理 |
| DELETE | /admin/hooks/:id | 削除処理 |
| POST | /admin/hooks/:id/test | テスト実行 |

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|----------|------|
| 名前 | name | String | - | 入力 | Webhookの識別名 |
| 説明 | description | Text | - | 入力 | Webhookの説明文（最大2048文字） |
| URL | url | String | ○ | 入力 | Webhook送信先URL |
| シークレットトークン | token | String | - | 入力 | マスク表示、変更時のみ入力 |
| リポジトリ更新イベント | repository_update_events | Boolean | - | 入力 | トリガーイベント |
| Pushイベント | push_events | Boolean | - | 入力 | トリガーイベント |
| Tag Pushイベント | tag_push_events | Boolean | - | 入力 | トリガーイベント |
| マージリクエストイベント | merge_requests_events | Boolean | - | 入力 | トリガーイベント |
| SSL検証 | enable_ssl_verification | Boolean | - | 入力 | SSL証明書検証 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| パンくずリスト | ヘッダー下 | System hooks > Edit system hook |
| エラーメッセージ | フォーム上部 | Webhook実行エラー時のエラー内容 |
| 編集フォーム | 上部 | Webhook設定の編集フォーム |
| アクションボタン | フォーム下部 | Save changes, Test, Close, Delete |
| Hook Logs | 下部 | 過去の実行ログ一覧 |

## イベント仕様

### 1-Save changesボタン押下

**処理フロー**:
1. フォームデータをサーバーに送信（PUT/PATCH）
2. バリデーション実行
3. 成功時：DB更新、編集画面をリロード
4. 失敗時：エラーメッセージ表示

### 2-Testボタン押下

**処理フロー**:
1. POST /admin/hooks/:id/test を実行
2. TestHooks::SystemServiceを呼び出し
3. 指定トリガーでテストペイロードを送信
4. 結果をフラッシュメッセージで表示
5. 編集画面にリダイレクト

### 3-Deleteボタン押下

**処理フロー**:
1. 確認ダイアログ「Are you sure you want to delete this webhook?」表示
2. 確認後、DELETE /admin/hooks/:id を実行
3. DBからWebhookと関連ログを削除
4. 一覧画面にリダイレクト

### 4-Closeボタン押下

**処理フロー**:
1. 一覧画面（/admin/hooks）にリダイレクト

### 5-Hook Logの詳細表示リンク押下

**処理フロー**:
1. /admin/hooks/:hook_id/hook_logs/:id にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Save changes | web_hooks | UPDATE | Webhook設定更新 |
| Delete | web_hooks | DELETE | Webhookレコード削除 |
| Delete | web_hook_logs | DELETE | 関連ログ削除 |
| Test | web_hook_logs | INSERT | テスト実行ログ追加 |

### テーブル別更新項目詳細

#### web_hooks

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | |
| UPDATE | description | フォーム入力値 | |
| UPDATE | url | フォーム入力値 | |
| UPDATE | token | フォーム入力値 | 暗号化保存、空なら変更なし |
| UPDATE | repository_update_events | フォーム入力値 | |
| UPDATE | push_events | フォーム入力値 | |
| UPDATE | tag_push_events | フォーム入力値 | |
| UPDATE | merge_requests_events | フォーム入力値 | |
| UPDATE | enable_ssl_verification | フォーム入力値 | |
| UPDATE | updated_at | 現在時刻 | |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| MSG-001 | Hook was successfully updated. | 更新成功時 | 成功 |
| MSG-002 | Are you sure you want to delete this webhook? | 削除確認時 | 確認 |
| MSG-003 | Hook executed successfully: HTTP {status} | テスト成功時 | 成功 |
| MSG-004 | Hook execution failed: {error} | テスト失敗時 | エラー |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| Webhookが存在しない | 404 Not Found |
| 権限不足 | 403 Forbidden |
| バリデーションエラー | エラーメッセージと共に編集画面表示 |

## 備考

- トークンは表示時にマスク表示され、空のまま保存すると既存値が維持される
- Hook Logsは最近のものから時系列で表示される
- テスト実行時は実際に外部URLにHTTPリクエストが送信される
- 削除操作は危険なため、赤色のボタンで表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | system_hook.rb | `app/models/hooks/system_hook.rb` | SystemHookモデルの構造 |
| 1-2 | web_hook_log.rb | `app/models/web_hook_log.rb` | ログデータ構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | hooks_controller.rb | `app/controllers/admin/hooks_controller.rb` | editアクション、testアクション |

**主要処理フロー**:
1. **4行目**: HookActionsモジュールのinclude
2. **10-15行目**: testアクション - テスト実行ロジック
3. **24-26行目**: hookメソッド - 対象Webhookの取得

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | edit.html.haml | `app/views/admin/hooks/edit.html.haml` | 編集画面構成 |
| 3-2 | _form.html.haml | `app/views/admin/hooks/_form.html.haml` | フォーム項目 |

**主要処理フロー**:
- **4行目**: エラーメッセージ表示
- **10-11行目**: フォームパーシャル呼び出し
- **13-19行目**: アクションボタン（Save, Test, Close, Delete）
- **23行目**: Hook Logsパーシャル呼び出し

### プログラム呼び出し階層図

```
edit.html.haml
    │
    ├─ Admin::HooksController#edit
    │      └─ WebHooks::HookActions#edit
    │             └─ hook (SystemHook.find)
    │
    ├─ hook_errors (エラー表示)
    │
    ├─ SettingsSectionComponent
    │      └─ gitlab_ui_form_for
    │             └─ admin/hooks/_form
    │
    ├─ settings-sticky-footer (ボタン群)
    │      ├─ Submit (Save changes)
    │      ├─ shared/web_hooks/_test_button
    │      ├─ link_button_to (Close)
    │      └─ link_button_to (Delete)
    │
    └─ shared/hook_logs/_index (ログ一覧)

[保存時]
Admin::HooksController#update
    │
    └─ WebHooks::HookActions#update
           └─ @hook.update(hook_params)

[テスト時]
Admin::HooksController#test
    │
    └─ TestHooks::SystemService#execute
           └─ hook.execute (HTTP送信)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

編集フォーム ───────────▶ HooksController#update ───────▶ web_hooks更新
                              │
                              ▼
                         SystemHook#update

テストボタン ───────────▶ HooksController#test ─────────▶ 外部URL
                              │                              │
                              ▼                              ▼
                         SystemService              web_hook_logs
                              │
                              ▼
                         Flash Message

削除ボタン ─────────────▶ HooksController#destroy ─────▶ web_hooks削除
                                                          ├─ hook削除
                                                          └─ logs削除
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| hooks_controller.rb | `app/controllers/admin/hooks_controller.rb` | コントローラー | リクエスト処理 |
| system_hook.rb | `app/models/hooks/system_hook.rb` | モデル | Webhookデータ |
| web_hook_log.rb | `app/models/web_hook_log.rb` | モデル | 実行ログデータ |
| edit.html.haml | `app/views/admin/hooks/edit.html.haml` | ビュー | 編集画面 |
| _form.html.haml | `app/views/admin/hooks/_form.html.haml` | ビュー | フォーム |
| _index.html.haml | `app/views/shared/hook_logs/_index.html.haml` | ビュー | ログ一覧 |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義 |
