# 画面設計書 254-Webhookログ詳細

## 概要

本ドキュメントは、GitLab管理者向けシステムWebhookログ詳細画面の設計書です。Webhookの実行結果（リクエスト内容、レスポンス内容）を確認し、必要に応じてリクエストを再送信するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：Webhook連携において、外部システムへの通知が正常に行われたかを確認する必要があります。また、障害発生時の原因調査や、失敗したリクエストの再送信も重要な運用タスクです。この詳細画面では、特定のWebhookリクエストの詳細情報（送信したペイロード、受信したレスポンス、処理時間など）を確認し、必要に応じて再送信を行うことができます。

**画面へのアクセス方法**：管理者エリアのWebhook編集画面（/admin/hooks/:id/edit）のHook Logs一覧から、確認したいログの詳細リンクをクリックしてアクセスします。URLパターンは `/admin/hooks/:hook_id/hook_logs/:id` です。

**主要な操作・処理内容**：
1. リクエスト詳細の確認（URL、HTTPメソッド、ペイロード、ヘッダー）
2. レスポンス詳細の確認（ステータスコード、ボディ、ヘッダー）
3. 処理時間の確認
4. エラー情報の確認（内部エラーがあった場合）
5. リクエストの再送信

**画面遷移**：
- 遷移元：Webhook編集画面のHook Logs一覧
- 遷移先：再送信後は編集画面（/admin/hooks/:id/edit）へリダイレクト

**権限による表示制御**：管理者権限（Admin）を持つユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 94 | システムWebhook | 主機能 | Webhookログの詳細表示・再送信 |

## 画面種別

詳細

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|----------|
| GET | /admin/hooks/:hook_id/hook_logs/:id | 詳細表示 |
| POST | /admin/hooks/:hook_id/hook_logs/:id/retry | 再送信 |

## 入出力項目

該当なし（詳細表示のみ）

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| ページタイトル | ヘッダー | "Request details" |
| Resend Requestボタン | 右上 | リクエスト再送信ボタン |
| HTTPメソッド・URL | 上部 | "POST {URL}" バッジ表示 |
| トリガー種別 | 上部 | トリガーイベント名バッジ |
| 処理時間 | 上部 | 実行時間と経過時間 |
| 内部エラー | 上部（該当時） | 内部エラーメッセージ（赤色アラート） |
| Response | 中央 | レスポンスセクション |
| - ステータス | 中央 | HTTPステータスコードバッジ |
| - ボディ | 中央 | レスポンスボディ（pre形式） |
| - ヘッダー | 中央 | レスポンスヘッダー一覧 |
| Request | 下部 | リクエストセクション |
| - ボディ | 下部 | リクエストペイロード（JSON整形表示） |
| - ヘッダー | 下部 | リクエストヘッダー一覧 |

## イベント仕様

### 1-Resend Requestボタン押下

**処理フロー**:
1. POST /admin/hooks/:hook_id/hook_logs/:id/retry を実行
2. HookLogActionsモジュールのretryアクション呼び出し
3. 元のリクエストデータで再度HTTPリクエスト送信
4. 新しいログレコードを作成
5. Webhook編集画面（/admin/hooks/:id/edit）にリダイレクト

**注意**: リクエストデータがオーバーサイズ（大きすぎる）場合、再送信ボタンは無効化される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Resend Request | web_hook_logs | INSERT | 新しい実行ログ追加 |

### テーブル別更新項目詳細

#### web_hook_logs（再送信時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | web_hook_id | 親Webhook ID | |
| INSERT | trigger | 元ログのtrigger値 | |
| INSERT | url | 元ログのurl値 | |
| INSERT | request_data | 元ログのrequest_data | |
| INSERT | request_headers | 元ログのrequest_headers | |
| INSERT | response_status | 新しいレスポンスステータス | |
| INSERT | response_body | 新しいレスポンスボディ | |
| INSERT | response_headers | 新しいレスポンスヘッダー | |
| INSERT | execution_duration | 新しい実行時間 | |
| INSERT | created_at | 現在時刻 | |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| MSG-001 | Request data is too large | データサイズ超過時 | 情報（ツールチップ） |
| MSG-002 | Response body is empty | レスポンスボディが空の場合 | 情報 |
| MSG-003 | Response headers are empty | レスポンスヘッダーが空の場合 | 情報 |
| MSG-004 | Internal error occurred while delivering this webhook. | 内部エラー発生時 | エラー |
| MSG-005 | Error: {error_message} | 内部エラーの詳細 | エラー |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ログが存在しない | 404 Not Found |
| 親Webhookが存在しない | 404 Not Found |
| 権限不足 | 403 Forbidden |
| データサイズ超過 | 再送信ボタン無効化、ツールチップで説明 |

## 備考

- リクエストデータはJSON形式で整形表示（pretty_generate）される
- ヘッダー情報はキー：値の形式で表示される
- 処理時間は小数点以下2桁まで表示される
- 経過時間は相対表示（例：「2 hours ago」）でツールチップに正確な日時
- オーバーサイズのリクエストは "Request data is too large" と表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | web_hook_log.rb | `app/models/web_hook_log.rb` | ログデータ構造、oversize?メソッド |

**読解のコツ**: `oversize?` メソッドで再送信可否の判定ロジックを確認する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | hook_logs_controller.rb | `app/controllers/admin/hook_logs_controller.rb` | showアクション、retryアクション |

**主要処理フロー**:
1. **5行目**: HookLogActionsモジュールのinclude
2. **9-10行目**: hookメソッド - 親SystemHookの取得
3. **12-14行目**: after_retry_redirect_path - 再送信後のリダイレクト先

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/admin/hook_logs/show.html.haml` | 画面構成 |
| 3-2 | _content.html.haml | `app/views/shared/hook_logs/_content.html.haml` | 詳細表示内容 |

**主要処理フロー（show.html.haml）**:
- **1行目**: ページタイトル設定
- **2行目**: PageHeadingComponent
- **4-10行目**: Resend Requestボタン（oversize判定）
- **12行目**: _contentパーシャル呼び出し

**主要処理フロー（_content.html.haml）**:
- **1-5行目**: HTTPメソッド、URL、トリガーバッジ表示
- **7-8行目**: 処理時間・経過時間表示
- **12-17行目**: 内部エラーアラート（該当時）
- **19-38行目**: レスポンスセクション
- **40-52行目**: リクエストセクション

### プログラム呼び出し階層図

```
show.html.haml
    │
    ├─ Admin::HookLogsController#show
    │      └─ WebHooks::HookLogActions#show
    │             ├─ hook (SystemHook.find)
    │             └─ hook_log (WebHookLog.find)
    │
    ├─ PageHeadingComponent
    │
    ├─ ButtonComponent (Resend Request)
    │      └─ hook_log.oversize? で有効/無効判定
    │
    └─ shared/hook_logs/_content
           ├─ gl_badge_tag (POST, trigger)
           ├─ time_ago_with_tooltip
           ├─ AlertComponent (internal_error)
           ├─ _status_label (response status)
           ├─ response_body (pre)
           ├─ response_headers
           ├─ request_data (JSON.pretty_generate)
           └─ request_headers

[再送信時]
Admin::HookLogsController#retry
    │
    └─ WebHooks::HookLogActions#retry
           └─ hook_log.retry
                  └─ WebHook#execute (HTTP送信)
                         └─ 新しいWebHookLog作成
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ブラウザ               HookLogsController#show
(GET) ────────────────▶      │                    ────────▶ 画面表示
                             ▼
                        hook_log取得
                             │
                             ▼
                        _contentパーシャル
                             │
                             ├─ response表示
                             └─ request表示

Resend Request         HookLogsController#retry
ボタン押下 ────────────▶     │                    ────────▶ リダイレクト
                             ▼
                        HookLogActions#retry
                             │
                             ▼
                        WebHook#execute ─────────────────▶ 外部URL
                             │                                │
                             ▼                                ▼
                        新WebHookLog作成              HTTP Response
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| hook_logs_controller.rb | `app/controllers/admin/hook_logs_controller.rb` | コントローラー | リクエスト処理 |
| hook_log_actions.rb | `app/controllers/concerns/web_hooks/hook_log_actions.rb` | Concern | 共通アクション |
| web_hook_log.rb | `app/models/web_hook_log.rb` | モデル | ログデータ |
| show.html.haml | `app/views/admin/hook_logs/show.html.haml` | ビュー | 詳細画面 |
| _content.html.haml | `app/views/shared/hook_logs/_content.html.haml` | ビュー | 詳細内容 |
| _status_label.html.haml | `app/views/shared/hook_logs/_status_label.html.haml` | ビュー | ステータスバッジ |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義（99-103行目） |
