# 画面設計書 255-デプロイキー一覧

## 概要

本ドキュメントは、GitLab管理者向けシステムデプロイキー一覧画面の設計書です。GitLabインスタンス全体で公開されているデプロイキーの管理を行うための画面です。

### 本画面の処理概要

**業務上の目的・背景**：デプロイキーは、パスワードなしでリポジトリにアクセスするためのSSH公開鍵です。CI/CDパイプラインや自動化ツールがリポジトリにアクセスする際に使用されます。システム管理者は、この一覧画面でインスタンス全体の公開デプロイキーを確認・管理し、セキュリティ監査やキーのローテーション作業を行います。

**画面へのアクセス方法**：管理者エリア（Admin Area）のナビゲーションから「Deploy Keys」を選択してアクセスします。URLは `/admin/deploy_keys` です。

**主要な操作・処理内容**：
1. 公開デプロイキーの一覧表示
2. 各デプロイキーの詳細情報確認（タイトル、フィンガープリント、作成日時、有効期限）
3. デプロイキーが関連付けられているプロジェクトの確認
4. 新規デプロイキー作成画面への遷移
5. デプロイキー編集画面への遷移
6. デプロイキーの削除

**画面遷移**：
- 遷移元：管理者ダッシュボード、管理者メニュー
- 遷移先：新規作成画面（/admin/deploy_keys/new）、編集画面（/admin/deploy_keys/:id/edit）

**権限による表示制御**：管理者権限（Admin）を持つユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 119 | デプロイキー管理 | 主機能 | システムデプロイキーの一覧表示・管理 |

## 画面種別

一覧

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|----------|
| GET | /admin/deploy_keys | 一覧表示 |
| DELETE | /admin/deploy_keys/:id | 削除処理 |

## 入出力項目

該当なし（一覧表示のみ）

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| ページタイトル | ヘッダー | "Deploy keys" |
| 新規作成ボタン | 右上 | 新規デプロイキー作成画面へのリンク |
| デプロイキー一覧テーブル | 中央 | Vue.jsコンポーネントによる一覧表示 |
| 空状態表示 | 中央 | デプロイキーがない場合のメッセージ |

### 一覧テーブルカラム（想定）

| カラム名 | 説明 |
|---------|------|
| タイトル | デプロイキーの名称 |
| フィンガープリント | SSH鍵のフィンガープリント（SHA256） |
| 作成日時 | デプロイキー登録日時 |
| 有効期限 | 設定されている場合の期限日 |
| プロジェクト | 関連付けられているプロジェクト数 |
| アクション | 編集・削除ボタン |

## イベント仕様

### 1-新規作成ボタン押下

**処理フロー**:
1. /admin/deploy_keys/new にリダイレクト

### 2-編集ボタン押下

**処理フロー**:
1. /admin/deploy_keys/:id/edit にリダイレクト

### 3-削除ボタン押下

**処理フロー**:
1. 確認ダイアログを表示
2. 確認後、DELETE /admin/deploy_keys/:id を実行
3. DBからデプロイキーを削除
4. 一覧を更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | keys | DELETE | デプロイキーレコード削除 |
| 削除 | deploy_keys_projects | DELETE | 関連付け削除（dependent: :destroy） |

### テーブル別更新項目詳細

#### keys (type: DeployKey, public: true)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | (全カラム) | WHERE id = :id AND type = 'DeployKey' AND public = true | |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| MSG-001 | Deploy key was successfully deleted. | 削除成功時 | 成功 |
| MSG-002 | (空状態イラスト・メッセージ) | キーが存在しない場合 | 情報 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 403 Forbidden |
| サーバーエラー | 500エラー画面を表示 |

## 備考

- この画面は公開デプロイキー（public: true）のみを対象とする
- 各プロジェクト固有のデプロイキーは対象外
- 一覧表示はVue.jsコンポーネント（#js-admin-deploy-keys-table）で実装
- 削除時はHTML/JSON両形式のレスポンスに対応

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | deploy_key.rb | `app/models/deploy_key.rb` | STI構造、スコープ、関連付け |

**読解のコツ**: `scope :are_public` で公開キーのみ取得する仕組みを確認。`has_many :deploy_keys_projects` でプロジェクトとの関連を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | deploy_keys_controller.rb | `app/controllers/admin/deploy_keys_controller.rb` | indexアクション、destroyアクション |

**主要処理フロー**:
1. **4行目**: before_actionでdeploy_keysを取得
2. **10行目**: indexアクション（空の実装、before_actionで準備完了）
3. **38-45行目**: destroyアクション
4. **53-55行目**: deploy_keysメソッド - `DeployKey.are_public`

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/admin/deploy_keys/index.html.haml` | Vue.jsコンポーネントへのデータ受け渡し |

**主要処理フロー**:
- **1行目**: ページタイトル設定
- **3行目**: PageHeadingComponentで見出し表示
- **5行目**: Vue.jsコンポーネントのマウントポイント

#### Step 4: ヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | deploy_key_helper.rb | `app/helpers/admin/deploy_key_helper.rb` | admin_deploy_keys_dataメソッド |

**主要処理フロー**:
- **5-11行目**: Vue.jsコンポーネントに渡すデータ（パス情報、空状態SVG）

### プログラム呼び出し階層図

```
index.html.haml
    │
    ├─ Admin::DeployKeysController#index
    │      └─ before_action :deploy_keys
    │             └─ DeployKey.are_public
    │
    ├─ PageHeadingComponent
    │
    └─ #js-admin-deploy-keys-table (Vue.js)
           └─ admin_deploy_keys_data (Helper)
                  ├─ edit_path
                  ├─ delete_path
                  ├─ create_path
                  └─ empty_state_svg_path

[削除時]
Admin::DeployKeysController#destroy
    │
    ├─ before_action :deploy_key
    │      └─ deploy_keys.find(params[:id])
    │
    └─ deploy_key.destroy
           └─ DeployKeysProject (dependent: :destroy)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ブラウザ               DeployKeysController#index
(GET) ────────────────▶      │                    ────────▶ 画面表示
                             ▼
                        DeployKey.are_public
                             │
                             ▼
                        Vue.jsコンポーネント
                             │
                             ▼
                        テーブル表示

削除ボタン             DeployKeysController#destroy
押下 ─────────────────▶      │                    ────────▶ リダイレクト
                             ▼                              / JSON応答
                        deploy_key.destroy
                             │
                             ▼
                        DB削除
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| deploy_keys_controller.rb | `app/controllers/admin/deploy_keys_controller.rb` | コントローラー | リクエスト処理 |
| deploy_key.rb | `app/models/deploy_key.rb` | モデル | デプロイキーデータ |
| index.html.haml | `app/views/admin/deploy_keys/index.html.haml` | ビュー | 一覧画面 |
| deploy_key_helper.rb | `app/helpers/admin/deploy_key_helper.rb` | ヘルパー | Vue.jsデータ準備 |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義（92行目） |
