# 画面設計書 256-デプロイキー新規作成

## 概要

本ドキュメントは、GitLab管理者向けシステムデプロイキー新規作成画面の設計書です。GitLabインスタンス全体で使用可能な公開デプロイキーを新規に登録するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：デプロイキーは、パスワードなしでリポジトリにアクセスするためのSSH公開鍵です。システム管理者が新しいデプロイキーを登録することで、CI/CDパイプラインや自動化ツールがセキュアにリポジトリにアクセスできるようになります。この画面では、SSH公開鍵、タイトル、有効期限を設定して新規デプロイキーを作成します。

**画面へのアクセス方法**：管理者エリアのデプロイキー一覧画面（/admin/deploy_keys）から「New deploy key」ボタンをクリックしてアクセスします。URLは `/admin/deploy_keys/new` です。

**主要な操作・処理内容**：
1. デプロイキーのタイトル入力
2. SSH公開鍵の入力（貼り付け）
3. 有効期限の設定（任意）
4. デプロイキーの作成

**画面遷移**：
- 遷移元：デプロイキー一覧画面（/admin/deploy_keys）
- 遷移先：作成成功時は一覧画面へリダイレクト、失敗時は新規作成画面に留まる

**権限による表示制御**：管理者権限（Admin）を持つユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 119 | デプロイキー管理 | 主機能 | システムデプロイキーの新規作成 |

## 画面種別

登録

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|----------|
| GET | /admin/deploy_keys/new | 新規作成画面表示 |
| POST | /admin/deploy_keys | 作成処理 |

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|----------|------|
| タイトル | title | String | ○ | 入力 | デプロイキーの識別名 |
| 公開鍵 | key | Text | ○ | 入力 | SSH公開鍵（RSA, ED25519等） |
| 有効期限 | expires_at | Date | - | 入力 | キーの有効期限（任意） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| パンくずリスト | ヘッダー下 | Deploy keys > New deploy key |
| ページタイトル | 上部 | "New public deploy key" |
| 入力フォーム | 中央 | タイトル、公開鍵、有効期限の入力フォーム |
| ヘルプリンク | 公開鍵フィールド下 | SSH鍵生成方法へのリンク |
| アクションボタン | フォーム下部 | Create, Cancel |

## イベント仕様

### 1-Createボタン押下

**処理フロー**:
1. フォームデータをサーバーに送信（POST）
2. DeployKeys::CreateServiceを呼び出し
3. パラメータにpublic: true、organization: Current.organizationを追加
4. バリデーション実行（タイトル必須、鍵フォーマット検証）
5. 成功時：DBに保存し、一覧画面へリダイレクト
6. 失敗時：エラーメッセージと共に新規作成画面を再表示

### 2-Cancelボタン押下

**処理フロー**:
1. 一覧画面（/admin/deploy_keys）にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Create | keys | INSERT | 新規デプロイキーレコード作成 |

### テーブル別更新項目詳細

#### keys (type: DeployKey)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | type | 'DeployKey' | STI識別子 |
| INSERT | title | フォーム入力値 | |
| INSERT | key | フォーム入力値 | SSH公開鍵 |
| INSERT | fingerprint | 自動計算 | MD5フィンガープリント |
| INSERT | fingerprint_sha256 | 自動計算 | SHA256フィンガープリント |
| INSERT | expires_at | フォーム入力値 | NULLable |
| INSERT | public | true | 公開キーフラグ |
| INSERT | organization_id | Current.organization.id | |
| INSERT | created_at | 現在時刻 | |
| INSERT | updated_at | 現在時刻 | |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| MSG-001 | Title can't be blank | タイトル未入力時 | エラー |
| MSG-002 | Key can't be blank | 公開鍵未入力時 | エラー |
| MSG-003 | Key is invalid | 鍵フォーマットエラー時 | エラー |
| MSG-004 | Key has already been taken | 重複キー時 | エラー |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 403 Forbidden |
| バリデーションエラー | エラーメッセージと共に新規作成画面表示 |
| サーバーエラー | 500エラー画面を表示 |

## 備考

- SSH公開鍵はRSA、ED25519、ECDSA、DSA形式をサポート
- フィンガープリントは自動計算され、重複チェックに使用される
- 有効期限を設定すると、期限切れ後はキーが無効化される
- 作成されたキーはpublic: trueとなり、任意のプロジェクトに割り当て可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | deploy_key.rb | `app/models/deploy_key.rb` | モデル構造、バリデーション |
| 1-2 | key.rb | `app/models/key.rb` | 親クラス、フィンガープリント計算 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | deploy_keys_controller.rb | `app/controllers/admin/deploy_keys_controller.rb` | newアクション、createアクション |

**主要処理フロー**:
1. **12-14行目**: newアクション - 新規インスタンス作成
2. **16-24行目**: createアクション - CreateService呼び出し
3. **57-59行目**: create_paramsメソッド - 許可パラメータ

#### Step 3: サービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create_service.rb | `app/services/deploy_keys/create_service.rb` | デプロイキー作成ロジック |

#### Step 4: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | new.html.haml | `app/views/admin/deploy_keys/new.html.haml` | 画面構成 |
| 4-2 | _form.html.haml | `app/views/shared/deploy_keys/_form.html.haml` | フォーム項目 |

**主要処理フロー（new.html.haml）**:
- **1行目**: パンくずリスト追加
- **2行目**: ページタイトル設定
- **4行目**: PageHeadingComponent
- **6行目**: フォーム開始（gitlab_ui_form_for）
- **7行目**: _formパーシャル呼び出し
- **8-11行目**: アクションボタン（Create, Cancel）

**主要処理フロー（_form.html.haml）**:
- **7-9行目**: タイトル入力フィールド（readonly条件付き）
- **11-19行目**: 公開鍵入力フィールド（新規作成時のみ）
- **21-23行目**: 有効期限入力フィールド

### プログラム呼び出し階層図

```
new.html.haml
    │
    ├─ Admin::DeployKeysController#new
    │      └─ deploy_keys.new
    │             └─ DeployKey.new
    │
    ├─ PageHeadingComponent
    │
    └─ gitlab_ui_form_for
           └─ shared/deploy_keys/_form
                  ├─ title入力
                  ├─ key入力（テキストエリア）
                  └─ expires_at入力（datepicker）

[作成時]
Admin::DeployKeysController#create
    │
    ├─ DeployKeys::CreateService#execute
    │      └─ DeployKey.new + save
    │             ├─ public: true
    │             └─ organization: Current.organization
    │
    └─ redirect_to / render
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力            DeployKeysController#create
(POST) ─────────────────▶     │                    ────────▶ リダイレクト
                              ▼
                         create_params
                              │
                              ▼
                         CreateService#execute
                              │
                              ├─ public: true 追加
                              ├─ organization設定
                              │
                              ▼
                         DeployKey#save
                              │
                              ├─ fingerprint計算
                              ├─ fingerprint_sha256計算
                              │
                              ▼
                         keys テーブル INSERT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| deploy_keys_controller.rb | `app/controllers/admin/deploy_keys_controller.rb` | コントローラー | リクエスト処理 |
| create_service.rb | `app/services/deploy_keys/create_service.rb` | サービス | 作成ロジック |
| deploy_key.rb | `app/models/deploy_key.rb` | モデル | デプロイキーデータ |
| new.html.haml | `app/views/admin/deploy_keys/new.html.haml` | ビュー | 新規作成画面 |
| _form.html.haml | `app/views/shared/deploy_keys/_form.html.haml` | ビュー | フォームパーシャル |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義（92行目） |
