# 画面設計書 257-デプロイキー編集

## 概要

本ドキュメントは、GitLab管理者向けシステムデプロイキー編集画面の設計書です。既存の公開デプロイキーのタイトルを編集するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：デプロイキーの運用において、識別しやすいタイトルへの変更が必要になる場合があります。この編集画面では、既存のデプロイキーのタイトルを変更することができます。なお、セキュリティ上の理由から、公開鍵自体の変更はできません（新規作成・削除で対応）。

**画面へのアクセス方法**：管理者エリアのデプロイキー一覧画面（/admin/deploy_keys）から編集したいデプロイキーの「Edit」ボタンをクリックしてアクセスします。URLパターンは `/admin/deploy_keys/:id/edit` です。

**主要な操作・処理内容**：
1. デプロイキーのタイトル編集
2. フィンガープリント（SHA256, MD5）の確認（読み取り専用）
3. 有効期限の確認（読み取り専用）
4. 設定の保存

**画面遷移**：
- 遷移元：デプロイキー一覧画面（/admin/deploy_keys）
- 遷移先：保存成功時は一覧画面へリダイレクト、失敗時は編集画面に留まる

**権限による表示制御**：管理者権限（Admin）を持つユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 119 | デプロイキー管理 | 主機能 | システムデプロイキーの編集 |

## 画面種別

編集

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|----------|
| GET | /admin/deploy_keys/:id/edit | 編集画面表示 |
| PUT/PATCH | /admin/deploy_keys/:id | 更新処理 |

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|----------|------|
| タイトル | title | String | ○ | 入力 | デプロイキーの識別名 |
| フィンガープリント（SHA256） | fingerprint_sha256 | String | - | 出力 | 鍵のSHA256フィンガープリント（読み取り専用） |
| フィンガープリント（MD5） | fingerprint | String | - | 出力 | 鍵のMD5フィンガープリント（読み取り専用） |
| 有効期限 | expires_at | Date | - | 出力 | キーの有効期限（読み取り専用、設定されている場合のみ表示） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| パンくずリスト | ヘッダー下 | Deploy keys > Edit deploy key |
| ページタイトル | 上部 | "Edit public deploy key" |
| 入力フォーム | 中央 | タイトル編集フォーム、フィンガープリント表示 |
| アクションボタン | フォーム下部 | Save changes, Cancel |

## イベント仕様

### 1-Save changesボタン押下

**処理フロー**:
1. フォームデータをサーバーに送信（PUT/PATCH）
2. バリデーション実行（タイトル必須）
3. 成功時：DB更新、フラッシュメッセージ表示、一覧画面へリダイレクト
4. 失敗時：エラーメッセージと共に編集画面を再表示

### 2-Cancelボタン押下

**処理フロー**:
1. 一覧画面（/admin/deploy_keys）にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Save changes | keys | UPDATE | タイトルのみ更新 |

### テーブル別更新項目詳細

#### keys (type: DeployKey)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | title | フォーム入力値 | |
| UPDATE | updated_at | 現在時刻 | |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| MSG-001 | Deploy key was successfully updated. | 更新成功時 | 成功 |
| MSG-002 | Title can't be blank | タイトル未入力時 | エラー |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| デプロイキーが存在しない | 404 Not Found |
| 権限不足 | 403 Forbidden |
| バリデーションエラー | エラーメッセージと共に編集画面表示 |

## 備考

- 編集可能な項目はタイトルのみ
- 公開鍵、フィンガープリント、有効期限は変更不可（読み取り専用）
- フィンガープリントはSHA256とMD5の両方が表示される（存在する場合）
- update_paramsではtitleのみ許可

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | deploy_key.rb | `app/models/deploy_key.rb` | モデル構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | deploy_keys_controller.rb | `app/controllers/admin/deploy_keys_controller.rb` | editアクション、updateアクション |

**主要処理フロー**:
1. **5行目**: before_actionでdeploy_key取得
2. **26行目**: editアクション（空の実装、before_actionで準備完了）
3. **28-36行目**: updateアクション
4. **61-63行目**: update_paramsメソッド - titleのみ許可

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | edit.html.haml | `app/views/admin/deploy_keys/edit.html.haml` | 画面構成 |
| 3-2 | _form.html.haml | `app/views/shared/deploy_keys/_form.html.haml` | フォーム項目 |

**主要処理フロー（edit.html.haml）**:
- **1行目**: パンくずリスト追加
- **2行目**: ページタイトル設定
- **4行目**: PageHeadingComponent
- **6行目**: フォーム開始
- **7行目**: _formパーシャル呼び出し
- **8-11行目**: アクションボタン

**主要処理フロー（_form.html.haml）**:
- **7-9行目**: タイトル入力（update_deploy_key_title権限で読み取り専用制御）
- **24-36行目**: 既存キーの場合、フィンガープリント表示（読み取り専用）

### プログラム呼び出し階層図

```
edit.html.haml
    │
    ├─ Admin::DeployKeysController#edit
    │      └─ before_action :deploy_key
    │             └─ deploy_keys.find(params[:id])
    │
    ├─ PageHeadingComponent
    │
    └─ gitlab_ui_form_for
           └─ shared/deploy_keys/_form
                  ├─ title入力（編集可能）
                  ├─ fingerprint_sha256表示（読み取り専用）
                  ├─ fingerprint表示（読み取り専用）
                  └─ expires_at表示（読み取り専用）

[更新時]
Admin::DeployKeysController#update
    │
    ├─ update_params (titleのみ)
    │
    ├─ deploy_key.update
    │      └─ keys テーブル UPDATE
    │
    └─ redirect_to / render
```

### データフロー図

```
[入力]                    [処理]                         [出力]

編集フォーム            DeployKeysController#update
(PUT) ──────────────────▶     │                    ────────▶ リダイレクト
                              ▼
                         update_params
                              │
                              ▼
                         deploy_key.update
                              │
                              ▼
                         keys テーブル UPDATE
                         (titleのみ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| deploy_keys_controller.rb | `app/controllers/admin/deploy_keys_controller.rb` | コントローラー | リクエスト処理 |
| deploy_key.rb | `app/models/deploy_key.rb` | モデル | デプロイキーデータ |
| edit.html.haml | `app/views/admin/deploy_keys/edit.html.haml` | ビュー | 編集画面 |
| _form.html.haml | `app/views/shared/deploy_keys/_form.html.haml` | ビュー | フォームパーシャル |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義（92行目） |
