# 画面設計書 258-Runner一覧

## 概要

本ドキュメントは、GitLab管理者向けシステムRunner一覧画面の設計書です。GitLabインスタンス全体のCI/CD Runnerを管理するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：CI/CD RunnerはGitLabのCI/CDパイプラインでジョブを実行するエージェントです。システム管理者は、この一覧画面でインスタンス全体のRunner（インスタンスRunner、グループRunner、プロジェクトRunner）を確認・管理し、Runnerの稼働状況監視、キャパシティ計画、トラブルシューティングを行います。

**画面へのアクセス方法**：管理者エリア（Admin Area）のナビゲーションから「Runners」を選択してアクセスします。URLは `/admin/runners` です。

**主要な操作・処理内容**：
1. 全Runnerの一覧表示（ステータス、タイプ、タグ付き）
2. Runnerのフィルタリング（ステータス、タイプ、タグ）
3. Runnerの検索（説明、トークン）
4. 新規Runnerの登録画面への遷移
5. Runner詳細・編集画面への遷移
6. 登録トークンの管理（レガシー機能）

**画面遷移**：
- 遷移元：管理者ダッシュボード、管理者メニュー
- 遷移先：Runner詳細画面（/admin/runners/:id）、新規登録画面（/admin/runners/new）、編集画面（/admin/runners/:id/edit）

**権限による表示制御**：管理者権限（Admin）を持つユーザーのみがこの画面にアクセス可能です。can_admin_all_resources?権限で登録トークン表示を制御します。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 115 | ランナー管理 | 主機能 | システムRunnerの一覧表示・管理 |

## 画面種別

一覧

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|----------|
| GET | /admin/runners | 一覧表示 |
| GET | /admin/runners/tag_list.json | タグ候補取得 |
| DELETE | /admin/runners/:id | 削除処理 |

## 入出力項目

該当なし（一覧表示のみ）

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| パンくずリスト | ヘッダー下 | Runners |
| ページタイトル | 上部 | "Runners" |
| フィルター・検索エリア | 上部 | ステータス、タイプ、タグによるフィルタリング |
| 新規作成ボタン | 右上 | 新規Runner登録画面へのリンク |
| Runner一覧テーブル | 中央 | Vue.jsコンポーネントによる一覧表示 |
| 登録トークン | 下部（レガシー） | Runner登録用トークン（管理者のみ） |

### 一覧テーブルカラム（想定）

| カラム名 | 説明 |
|---------|------|
| ステータス | online/offline/stale/never_contacted |
| Runner ID | Runner識別子（#ID (短縮SHA)形式） |
| 説明 | Runnerの説明文 |
| タイプ | instance_type/group_type/project_type |
| タグ | 設定されているタグ一覧 |
| プロジェクト/グループ | 関連付けられているプロジェクト・グループ |
| アクション | 詳細・編集・一時停止・削除 |

## イベント仕様

### 1-新規作成ボタン押下

**処理フロー**:
1. /admin/runners/new にリダイレクト

### 2-Runner行クリック

**処理フロー**:
1. /admin/runners/:id にリダイレクト

### 3-編集ボタン押下

**処理フロー**:
1. /admin/runners/:id/edit にリダイレクト

### 4-一時停止/再開ボタン押下

**処理フロー**:
1. POST /admin/runners/:id/pause または /admin/runners/:id/resume を実行
2. Runnerのactive状態を切り替え
3. 一覧を更新

### 5-削除ボタン押下

**処理フロー**:
1. 確認ダイアログを表示
2. 確認後、DELETE /admin/runners/:id を実行
3. DBからRunnerを削除
4. 一覧を更新

### 6-フィルター変更

**処理フロー**:
1. フィルター条件に基づいて一覧を再取得
2. URLパラメータを更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一時停止/再開 | ci_runners | UPDATE | active状態の更新 |
| 削除 | ci_runners | DELETE | Runnerレコード削除 |
| 削除 | ci_runner_projects | DELETE | 関連付け削除 |
| 削除 | ci_runner_namespaces | DELETE | 関連付け削除 |

### テーブル別更新項目詳細

#### ci_runners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | active | true/false | 一時停止/再開時 |
| UPDATE | updated_at | 現在時刻 | |
| DELETE | (全カラム) | WHERE id = :id | 削除時 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| MSG-001 | Runner was successfully paused. | 一時停止成功時 | 成功 |
| MSG-002 | Runner was successfully resumed. | 再開成功時 | 成功 |
| MSG-003 | Runner was successfully deleted. | 削除成功時 | 成功 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 403 Forbidden |
| サーバーエラー | 500エラー画面を表示 |

## 備考

- 一覧表示はVue.jsコンポーネント（#js-admin-runners）で実装
- ステータスはonline, offline, never_contacted, staleの4種類
- Runner種別はinstance_type, group_type, project_typeの3種類
- ONLINE_CONTACT_TIMEOUTは2時間、STALE_TIMEOUTは7日
- レガシー登録トークン機能は段階的に廃止予定
- タグ候補はAPIから取得（最大20件）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | runner.rb | `app/models/ci/runner.rb` | enum定義、ステータス計算、タイムアウト定数 |

**読解のコツ**:
- `enum :runner_type` でRunner種別を確認
- `ONLINE_CONTACT_TIMEOUT`, `STALE_TIMEOUT` でステータス判定基準を確認
- `status` メソッド（`Ci::HasRunnerStatus`モジュール）でステータス計算ロジックを確認

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | runners_controller.rb | `app/controllers/admin/runners_controller.rb` | indexアクション、destroyアクション |

**主要処理フロー**:
1. **16行目**: indexアクション（空の実装、Vue.jsで描画）
2. **30-39行目**: updateアクション - UpdateRunnerService使用
3. **41-44行目**: tag_listアクション - タグ候補API

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/admin/runners/index.html.haml` | Vue.jsコンポーネントへのデータ受け渡し |

**主要処理フロー**:
- **1-2行目**: パンくずリスト、ページタイトル設定
- **4行目**: イベントトラッキングdiv
- **6行目**: Vue.jsコンポーネントのマウントポイント

#### Step 4: ヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | runners_helper.rb | `app/helpers/ci/runners_helper.rb` | admin_runners_app_dataメソッド |

**主要処理フロー**:
- **71-91行目**: Vue.jsコンポーネントに渡すデータ（パス情報、設定値）

### プログラム呼び出し階層図

```
index.html.haml
    │
    ├─ Admin::RunnersController#index
    │      └─ (空の実装、Vue.jsで描画)
    │
    └─ #js-admin-runners (Vue.js)
           └─ admin_runners_app_data (Helper)
                  ├─ runner_install_help_page
                  ├─ new_runner_path
                  ├─ allow_registration_token
                  ├─ registration_token (管理者のみ)
                  ├─ online_contact_timeout_secs
                  ├─ stale_timeout_secs
                  ├─ tag_suggestions_path
                  └─ can_admin_runners

[一時停止時]
Admin::RunnersController#pause
    │
    └─ runner.update(active: false)

[削除時]
Admin::RunnersController#destroy
    │
    └─ runner.destroy
           ├─ ci_runner_projects削除
           └─ ci_runner_namespaces削除
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ブラウザ               RunnersController#index
(GET) ────────────────▶      │                    ────────▶ 画面表示
                             │
                             ▼
                        admin_runners_app_data
                             │
                             ▼
                        Vue.jsコンポーネント
                             │
                             ▼
                        GraphQL API呼び出し
                             │
                             ▼
                        Ci::Runner一覧取得
                             │
                             ▼
                        テーブル表示

タグ候補取得           RunnersController#tag_list
(GET JSON) ─────────────▶    │                    ────────▶ JSON
                             ▼
                        Ci::TagsFinder#execute
                             │
                             ▼
                        Ci::TagSerializer
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| runners_controller.rb | `app/controllers/admin/runners_controller.rb` | コントローラー | リクエスト処理 |
| runner.rb | `app/models/ci/runner.rb` | モデル | Runnerデータ |
| index.html.haml | `app/views/admin/runners/index.html.haml` | ビュー | 一覧画面 |
| runners_helper.rb | `app/helpers/ci/runners_helper.rb` | ヘルパー | Vue.jsデータ準備 |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義（220-231行目） |
