# 画面設計書 259-Runner詳細

## 概要

本ドキュメントは、GitLab管理者向けシステムRunner詳細画面の設計書です。特定のCI/CD Runnerの詳細情報を確認するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：CI/CD Runnerの運用において、個々のRunnerの詳細情報（ステータス、設定、関連プロジェクト、最終接続時刻など）を確認する必要があります。この詳細画面では、Runnerの現在の状態を把握し、トラブルシューティングや設定変更の判断材料を得ることができます。

**画面へのアクセス方法**：管理者エリアのRunner一覧画面（/admin/runners）からRunnerの行をクリック、または詳細リンクをクリックしてアクセスします。URLパターンは `/admin/runners/:id` です。

**主要な操作・処理内容**：
1. Runnerの基本情報確認（ID、説明、トークン短縮形）
2. ステータス確認（online/offline/stale/never_contacted）
3. Runner種別の確認（インスタンス/グループ/プロジェクト）
4. タグ一覧の確認
5. 設定情報の確認（保護ブランチ限定、タグなしジョブ実行許可など）
6. 関連プロジェクト・グループの確認
7. 編集画面への遷移

**画面遷移**：
- 遷移元：Runner一覧画面（/admin/runners）
- 遷移先：編集画面（/admin/runners/:id/edit）

**権限による表示制御**：管理者権限（Admin）を持つユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 115 | ランナー管理 | 主機能 | システムRunnerの詳細表示 |

## 画面種別

詳細

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|----------|
| GET | /admin/runners/:id | 詳細表示 |

## 入出力項目

該当なし（詳細表示のみ）

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| パンくずリスト | ヘッダー下 | Runners > #{ID} ({短縮SHA}) |
| ページタイトル | 上部 | "#{ID} ({短縮SHA})" 形式 |
| Runner詳細 | 中央 | Vue.jsコンポーネントによる詳細表示 |

### 詳細表示項目（想定）

| 項目名 | 説明 |
|--------|------|
| ステータス | online/offline/stale/never_contacted（アイコン付き） |
| 最終接続時刻 | contacted_atの相対表示 |
| Runner ID | 内部ID |
| 説明 | description |
| Runner種別 | instance_type/group_type/project_type |
| 作成日時 | created_at |
| トークン有効期限 | token_expires_at |
| 保護ブランチ限定 | access_level (ref_protected) |
| タグなしジョブ実行 | run_untagged |
| ロック状態 | locked |
| タグ一覧 | tag_list |
| 最大タイムアウト | maximum_timeout |
| Runner Manager情報 | 接続しているマシン情報 |

## イベント仕様

### 1-編集ボタン押下

**処理フロー**:
1. /admin/runners/:id/edit にリダイレクト

### 2-一時停止/再開ボタン押下

**処理フロー**:
1. POST /admin/runners/:id/pause または /admin/runners/:id/resume を実行
2. Runnerのactive状態を切り替え
3. 画面を更新

### 3-削除ボタン押下

**処理フロー**:
1. 確認ダイアログを表示
2. 確認後、DELETE /admin/runners/:id を実行
3. 一覧画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一時停止/再開 | ci_runners | UPDATE | active状態の更新 |
| 削除 | ci_runners | DELETE | Runnerレコード削除 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| MSG-001 | Runner is online; last contact was {time} ago | オンライン時 | 情報 |
| MSG-002 | Runner is offline; last contact was {time} ago | オフライン時 | 警告 |
| MSG-003 | Runner is stale; last contact was {time} ago | 古い時 | 警告 |
| MSG-004 | Runner has never contacted this instance | 未接続時 | 情報 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| Runnerが存在しない | 404 Not Found |
| 権限不足 | 403 Forbidden |

## 備考

- 詳細表示はVue.jsコンポーネント（#js-admin-runner-show）で実装
- ステータスアイコンはヘルパー（runner_status_icon）で生成
- 短縮SHAはトークンの先頭8文字（プレフィックス除く）
- Runner Manager情報は接続したマシンごとの詳細を表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | runner.rb | `app/models/ci/runner.rb` | モデル構造、ステータス計算 |

**読解のコツ**: `short_sha` メソッドでトークン短縮形の計算ロジックを確認。`display_name` メソッドで表示名の決定ロジックを確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | runners_controller.rb | `app/controllers/admin/runners_controller.rb` | showアクション |

**主要処理フロー**:
1. **8行目**: before_actionでrunner取得
2. **18行目**: showアクション（空の実装、Vue.jsで描画）
3. **53-55行目**: runnerメソッド - Ci::Runner.find

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/admin/runners/show.html.haml` | Vue.jsコンポーネントへのデータ受け渡し |

**主要処理フロー**:
- **1行目**: ci_statusスタイル追加
- **3-4行目**: runner_short_nameでタイトル生成
- **6行目**: パンくずリスト追加
- **8行目**: Vue.jsコンポーネントのマウントポイント

#### Step 4: ヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | runners_helper.rb | `app/helpers/ci/runners_helper.rb` | runner_short_name, runner_status_icon |

**主要処理フロー**:
- **7-52行目**: runner_status_iconメソッド - ステータスに応じたアイコン生成
- **54-56行目**: runner_short_nameメソッド - 表示名生成

### プログラム呼び出し階層図

```
show.html.haml
    │
    ├─ Admin::RunnersController#show
    │      └─ before_action :runner
    │             └─ Ci::Runner.find(params[:id])
    │
    ├─ runner_short_name (Helper)
    │      └─ "#{runner.id} (#{runner.short_sha})"
    │
    └─ #js-admin-runner-show (Vue.js)
           ├─ runner_id: @runner.id
           ├─ runners_path: admin_runners_path
           └─ edit_path: edit_admin_runner_path

[詳細取得時]
Vue.jsコンポーネント
    │
    └─ GraphQL API
           └─ Ci::Runner取得
                  ├─ 基本情報
                  ├─ ステータス
                  ├─ タグ
                  ├─ 関連プロジェクト
                  └─ Runner Manager情報
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ブラウザ               RunnersController#show
(GET) ────────────────▶      │                    ────────▶ 画面表示
                             │
                             ▼
                        before_action :runner
                             │
                             ▼
                        Ci::Runner.find
                             │
                             ▼
                        show.html.haml
                             │
                             ▼
                        Vue.jsコンポーネント
                             │
                             ▼
                        GraphQL API
                             │
                             ▼
                        詳細表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| runners_controller.rb | `app/controllers/admin/runners_controller.rb` | コントローラー | リクエスト処理 |
| runner.rb | `app/models/ci/runner.rb` | モデル | Runnerデータ |
| show.html.haml | `app/views/admin/runners/show.html.haml` | ビュー | 詳細画面 |
| runners_helper.rb | `app/helpers/ci/runners_helper.rb` | ヘルパー | 表示ヘルパー |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義（220行目） |
