# 画面設計書 260-Runner新規登録

## 概要

本ドキュメントは、GitLab管理者向けシステムRunner新規登録画面の設計書です。新しいインスタンスRunnerを作成し、登録トークンを生成するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：CI/CD Runnerを新規に追加する際、まずGitLab上でRunnerを作成し、生成された登録トークンを使用してrunnerをGitLabインスタンスに登録します。この画面では、インスタンス全体で使用可能なRunner（instance_type）を作成し、Runnerの初期設定（タグ、保護ブランチ限定など）を行います。

**画面へのアクセス方法**：管理者エリアのRunner一覧画面（/admin/runners）から「New instance runner」ボタンをクリックしてアクセスします。URLは `/admin/runners/new` です。

**主要な操作・処理内容**：
1. Runnerの基本設定（タグ、説明）
2. 保護ブランチ限定の設定
3. タグなしジョブ実行許可の設定
4. 最大タイムアウトの設定
5. Runnerの作成
6. 登録コマンドの取得

**画面遷移**：
- 遷移元：Runner一覧画面（/admin/runners）
- 遷移先：作成後は登録画面（/admin/runners/:id/register）へ、一覧画面へ戻ることも可能

**権限による表示制御**：管理者権限（Admin）を持つユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 115 | ランナー管理 | 主機能 | システムRunnerの新規登録 |

## 画面種別

登録

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|----------|
| GET | /admin/runners/new | 新規登録画面表示 |
| POST | /admin/runners | 作成処理（API経由） |
| GET | /admin/runners/:id/register | 登録完了後の画面 |

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|----------|------|
| 説明 | description | String | - | 入力 | Runnerの説明文 |
| タグ | tag_list | Array | - | 入力 | ジョブマッチング用タグ |
| 保護ブランチ限定 | access_level | Enum | - | 入力 | ref_protected時は保護ブランチのジョブのみ実行 |
| タグなしジョブ実行 | run_untagged | Boolean | - | 入力 | タグなしジョブを実行するか |
| 最大タイムアウト | maximum_timeout | Integer | - | 入力 | ジョブの最大実行時間（秒） |
| ロック | locked | Boolean | - | 入力 | 他プロジェクトへの割り当て禁止 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| パンくずリスト | ヘッダー下 | Runners > Create |
| ページタイトル | 上部 | "Create an instance runner" |
| 設定フォーム | 中央 | Vue.jsコンポーネントによるウィザード形式 |
| 登録コマンド | 作成後 | gitlab-runner registerコマンド |

## イベント仕様

### 1-作成ボタン押下

**処理フロー**:
1. フォームデータをGraphQL API経由で送信
2. Runnerを作成（runner_type: instance_type, registration_type: authenticated_user）
3. 成功時：登録画面（/admin/runners/:id/register）にリダイレクト
4. 失敗時：エラーメッセージを表示

### 2-キャンセルボタン押下

**処理フロー**:
1. 一覧画面（/admin/runners）にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成 | ci_runners | INSERT | 新規Runnerレコード作成 |
| 作成 | ci_runner_taggings | INSERT | タグ関連付け作成 |

### テーブル別更新項目詳細

#### ci_runners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | runner_type | 1 (instance_type) | |
| INSERT | registration_type | 1 (authenticated_user) | |
| INSERT | creation_state | 0 (started) | |
| INSERT | description | フォーム入力値 | |
| INSERT | access_level | フォーム入力値 | 0: not_protected, 1: ref_protected |
| INSERT | run_untagged | フォーム入力値 | |
| INSERT | locked | フォーム入力値 | |
| INSERT | maximum_timeout | フォーム入力値 | |
| INSERT | active | true | |
| INSERT | token | 自動生成 | CREATED_RUNNER_TOKEN_PREFIX付き |
| INSERT | creator_id | current_user.id | |
| INSERT | created_at | 現在時刻 | |
| INSERT | updated_at | 現在時刻 | |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| MSG-001 | Runner created successfully | 作成成功時 | 成功 |
| MSG-002 | Tags list can not be empty when runner is not allowed to pick untagged jobs | タグなし実行OFF＋タグ未設定時 | エラー |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 403 Forbidden |
| バリデーションエラー | エラーメッセージを表示 |
| サーバーエラー | 500エラー画面を表示 |

## 備考

- 作成されるRunnerはinstance_type（インスタンスRunner）
- トークンはCREATED_RUNNER_TOKEN_PREFIX（glrt-）付きで生成
- 作成後は登録画面でgitlab-runner registerコマンドを表示
- 登録可能期間（REGISTRATION_AVAILABILITY_TIME）は作成から1時間
- runner_create_wizard_adminフィーチャーフラグで動作が変わる可能性あり

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | runner.rb | `app/models/ci/runner.rb` | enum定義、トークン生成、バリデーション |

**読解のコツ**:
- `CREATED_RUNNER_TOKEN_PREFIX` でトークンプレフィックスを確認
- `registration_type` enumでregistration_token/authenticated_userの違いを確認
- `creation_state` enumでstarted/finishedの違いを確認
- `REGISTRATION_AVAILABILITY_TIME` で登録可能期間を確認

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | runners_controller.rb | `app/controllers/admin/runners_controller.rb` | newアクション、registerアクション |

**主要処理フロー**:
1. **9-11行目**: before_actionでフィーチャーフラグをpush
2. **24行目**: newアクション（空の実装、Vue.jsで描画）
3. **26-28行目**: registerアクション

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/admin/runners/new.html.haml` | Vue.jsコンポーネントへのデータ受け渡し |

**主要処理フロー**:
- **1行目**: パンくずリスト追加
- **2行目**: パンくずタイトル設定
- **3行目**: ページタイトル設定
- **5行目**: Vue.jsコンポーネントのマウントポイント

### プログラム呼び出し階層図

```
new.html.haml
    │
    ├─ Admin::RunnersController#new
    │      └─ push_frontend_feature_flag(:runner_create_wizard_admin)
    │
    └─ #js-admin-new-runner (Vue.js)
           └─ runners_path: admin_runners_path

[作成時]
GraphQL Mutation
    │
    └─ Mutations::Ci::Runner::Create
           └─ Ci::Runner.create
                  ├─ runner_type: instance_type
                  ├─ registration_type: authenticated_user
                  ├─ creation_state: started
                  └─ token生成

[登録画面]
Admin::RunnersController#register
    │
    ├─ before_action :runner
    │
    └─ runner.registration_available?
           └─ 1時間以内かつstarted状態を確認
```

### データフロー図

```
[入力]                    [処理]                         [出力]

新規作成画面            Vue.jsコンポーネント
(フォーム入力) ─────────▶     │
                              ▼
                         GraphQL Mutation
                              │
                              ▼
                         Ci::Runner.create
                              │
                              ├─ token生成 (glrt-...)
                              ├─ runner_type設定
                              │
                              ▼
                         ci_runners INSERT
                              │
                              ▼
                         登録画面へリダイレクト
                              │
                              ▼
                         gitlab-runner register
                         コマンド表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| runners_controller.rb | `app/controllers/admin/runners_controller.rb` | コントローラー | リクエスト処理 |
| runner.rb | `app/models/ci/runner.rb` | モデル | Runnerデータ |
| new.html.haml | `app/views/admin/runners/new.html.haml` | ビュー | 新規登録画面 |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義（220行目） |
