# 画面設計書 264-ラベル一覧

## 概要

本ドキュメントは、GitLab管理者エリアにおける「ラベル一覧」画面の設計を記載したものです。システム全体のデフォルトラベル（テンプレートラベル）を管理するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：GitLabでは、課題やマージリクエストにラベルを付けて分類・管理します。管理者は、新規プロジェクト作成時に自動的に追加されるデフォルトラベルを定義することで、組織全体で一貫した課題管理の分類体系を提供できます。本画面は、これらのシステムレベルのテンプレートラベルの一元管理を可能にします。

**画面へのアクセス方法**：管理者エリア > ラベル、または `/admin/labels` に直接アクセスします。管理者権限が必要です。

**主要な操作・処理内容**：
1. テンプレートラベルの一覧表示（ページネーション付き）
2. 新規ラベル作成画面への遷移
3. ラベルの編集画面への遷移
4. ラベルの削除

**画面遷移**：
- 遷移元：管理者ダッシュボード、サイドバーナビゲーション
- 遷移先：ラベル新規作成画面、ラベル編集画面

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 120 | ラベル管理 | 主機能 | システムラベルの一覧表示・削除 |
| 40 | ラベル管理 | 補助機能 | ラベルの基本機能 |

## 画面種別

一覧

## URL/ルーティング

- URL: `/admin/labels`
- HTTPメソッド: GET（一覧表示）、DELETE（削除）
- コントローラー: `Admin::LabelsController#index`, `Admin::LabelsController#destroy`

## 入出力項目

### ページネーション

| 項目名 | 物理名 | 型 | 説明 |
|--------|--------|-----|------|
| ページ番号 | page | Integer | 表示するページ番号 |

## 表示項目

### ラベル一覧

| 項目名 | 説明 |
|--------|------|
| ラベル名 | ラベルのタイトル（背景色付きバッジ） |
| 説明 | ラベルの説明文 |
| アクション | 編集・削除ボタン |

### 統計情報

| 項目名 | 説明 |
|--------|------|
| ラベル総数 | 登録されているテンプレートラベルの総数 |

## イベント仕様

### 1-一覧表示

**トリガー**: 画面表示時

**処理フロー**:
1. `Label.in_organization(Current.organization).templates` でテンプレートラベルを取得
2. Kaminariによるページネーション適用
3. CrudComponentでラベル一覧を表示

### 2-ラベル削除

**トリガー**: ラベル行の削除ボタン押下

**処理フロー**:
1. 確認モーダル表示
2. DELETEリクエストを `/admin/labels/:id` に送信
3. 成功時：成功メッセージをフラッシュに設定し、一覧にリダイレクト
4. 失敗時：エラーメッセージをフラッシュに設定し、一覧にリダイレクト

### 3-新規作成への遷移

**トリガー**: 「New label」ボタン押下

**処理フロー**:
1. `/admin/labels/new` にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | labels | SELECT | テンプレートラベルを取得 |
| ラベル削除 | labels | DELETE | ラベルレコードを削除 |
| ラベル削除 | label_links | CASCADE DELETE | 関連するリンクを削除 |
| ラベル削除 | label_priorities | CASCADE DELETE | 関連する優先度を削除 |
| ラベル削除 | lists | CASCADE DELETE | 関連するボードリストを削除 |

### テーブル別更新項目詳細

#### labels

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | template = true | 組織に紐づくテンプレートラベル |
| DELETE | id | 指定されたID | 関連レコードも連動削除 |

## メッセージ仕様

| 種別 | 条件 | メッセージ |
|------|------|----------|
| 成功 | ラベル削除成功 | "{label_name} was removed" |
| エラー | ラベル削除失敗 | エラーメッセージ（full_messages） |
| 空状態 | ラベルが存在しない | "Define your default set of project labels" |
| 説明 | ラベル一覧ヘッダー | "Labels created here will be automatically added to new projects." |

## 例外処理

| 状態 | 処理 |
|------|------|
| ラベルが見つからない | 404エラー画面を表示 |
| 権限不足 | アクセス拒否画面にリダイレクト |
| 削除失敗 | エラーメッセージを表示し、一覧にリダイレクト |

## 備考

- テンプレートラベルは `template: true` フラグで識別される
- 組織ごとにラベルが分離されている（`in_organization`スコープ）
- ラベルが存在しない場合は空状態コンポーネントを表示
- ページ固有スタイル `page_bundles/labels` を使用
- イベントトラッキング: `view_admin_labels_pageload`

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | label.rb | `app/models/label.rb` | Labelモデルの属性、スコープ、関連 |
| 1-2 | base_label.rb | `app/models/concerns/base_label.rb` | 共通ラベル機能 |

**読解のコツ**: `templates`スコープと`in_organization`スコープの定義を確認。`template`フラグでテンプレートラベルを識別。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | labels_controller.rb | `app/controllers/admin/labels_controller.rb` | indexとdestroyアクション |

**主要処理フロー**:
1. **行9-11**: `index` - テンプレートラベルの取得とページネーション
2. **行41-57**: `destroy` - ラベルの削除処理

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/admin/labels/index.html.haml` | 一覧表示のレイアウト |

**主要処理フロー**:
- **行7**: イベントトラッキング用データ属性
- **行9-20**: CrudComponentによるラベル一覧表示
- **行22-29**: 空状態コンポーネント

#### Step 4: 共有コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | _label.html.haml | `app/views/admin/labels/_label.html.haml` | 個別ラベル行のパーシャル |

### プログラム呼び出し階層図

```
Admin::LabelsController#index
    │
    └─ Label.in_organization(Current.organization)
           └─ .templates
                  └─ .page(params[:page])

Admin::LabelsController#destroy
    │
    ├─ set_label (before_action)
    │      └─ Label.in_organization.templates.find(id)
    │
    └─ @label.destroy
           ├─ label_links.destroy_all
           ├─ label_priorities.destroy_all
           └─ lists.destroy_all
```

### データフロー図

```
[入力]                   [処理]                         [出力]

page パラメータ ───────▶ Label.templates ──────────▶ @labels
                              │
                              └─ in_organization
                              └─ page(params[:page])

label_id ─────────────▶ Label.find ────────────────▶ 削除完了
                              │
                              └─ destroy
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| labels_controller.rb | `app/controllers/admin/labels_controller.rb` | コントローラー | リクエスト処理 |
| index.html.haml | `app/views/admin/labels/index.html.haml` | テンプレート | 画面表示 |
| _label.html.haml | `app/views/admin/labels/_label.html.haml` | パーシャル | ラベル行表示 |
| label.rb | `app/models/label.rb` | モデル | ラベルデータモデル |
| base_label.rb | `app/models/concerns/base_label.rb` | Concern | 共通ラベル機能 |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義 |
| labels.scss | `app/assets/stylesheets/page_bundles/labels.scss` | スタイル | ラベル表示用CSS |
